/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.normalization.model;

import eu.europeana.normalization.model.NormalizationReport;

public final class NormalizationResult {
    private final NormalizationReport report;
    private final String normalizedRecordInEdmXml;
    private final String errorMessage;

    private NormalizationResult(String normalizedRecordInEdmXml, NormalizationReport report, String errorMessage) {
        this.normalizedRecordInEdmXml = normalizedRecordInEdmXml;
        this.report = report;
        this.errorMessage = errorMessage;
    }

    public static NormalizationResult createInstanceForError(String errorMessage, String edmRecord) {
        if (edmRecord == null) {
            throw new IllegalArgumentException("The record should not be null.");
        }
        if (errorMessage == null) {
            throw new IllegalArgumentException("The error message should not be null.");
        }
        return new NormalizationResult(edmRecord, null, errorMessage);
    }

    public static NormalizationResult createInstanceForSuccess(String normalizedRecordInEdmXml, NormalizationReport report) {
        if (normalizedRecordInEdmXml == null) {
            throw new IllegalArgumentException("The record should not be null.");
        }
        if (report == null) {
            throw new IllegalArgumentException("The report should not be null.");
        }
        return new NormalizationResult(normalizedRecordInEdmXml, report, null);
    }

    public NormalizationReport getReport() {
        return this.report;
    }

    public String getNormalizedRecordInEdmXml() {
        return this.normalizedRecordInEdmXml;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

