/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.normalization.languages;

import eu.europeana.normalization.languages.Language;
import eu.europeana.normalization.languages.LanguageMatch;
import eu.europeana.normalization.languages.Languages;
import eu.europeana.normalization.languages.LanguagesVocabulary;
import eu.europeana.normalization.settings.AmbiguityHandling;
import eu.europeana.normalization.util.NormalizationConfigurationException;
import eu.europeana.normalization.util.StringNormalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class LanguageMatcher {
    private static final Pattern LOCALE_CODE_PATTERN = Pattern.compile("\\A(\\p{Alpha}\\p{Alpha})-\\p{Alpha}\\p{Alpha}\\Z");
    private static final Pattern LANGUAGE_CODE_MATCHER = Pattern.compile("\\A\\p{Alpha}{2,3}\\Z");
    private final int minimumLabelLength;
    private final AmbiguityHandling ambiguityHandling;
    private final LanguagesVocabulary targetVocabulary;
    private final Function<String, String> stringNormalizer;
    private final Map<String, String> isoCodes = new HashMap<String, String>();
    private final Map<String, String> unambiguousLabels = new HashMap<String, String>();
    private final HashMap<String, List<String>> ambiguousLabels = new HashMap();

    public LanguageMatcher(int minimumLabelLength, AmbiguityHandling ambiguityHandling, LanguagesVocabulary targetVocabulary) throws NormalizationConfigurationException {
        this(minimumLabelLength, ambiguityHandling, targetVocabulary, Languages.getLanguages(), StringNormalizer::normalize);
    }

    LanguageMatcher(int minimumLabelLength, AmbiguityHandling ambiguityHandling, LanguagesVocabulary targetVocabulary, Languages languages, Function<String, String> stringNormalizer) {
        this.minimumLabelLength = minimumLabelLength;
        this.ambiguityHandling = ambiguityHandling;
        this.targetVocabulary = targetVocabulary;
        this.stringNormalizer = stringNormalizer;
        for (Language l : languages.getActiveLanguages()) {
            this.index(l);
        }
    }

    private void index(Language language2) {
        String languageId = language2.getNormalizedLanguageId(this.targetVocabulary);
        if (languageId == null) {
            return;
        }
        this.addCodeToIndex(language2.getIso6391(), languageId);
        this.addCodeToIndex(language2.getIso6392b(), languageId);
        this.addCodeToIndex(language2.getIso6392t(), languageId);
        this.addCodeToIndex(language2.getIso6393(), languageId);
        this.addCodeToIndex(language2.getAuthorityCode(), languageId);
        for (String label : language2.getAllLabels()) {
            if (label.length() < this.minimumLabelLength) continue;
            this.addLabelToIndex(label, languageId);
        }
    }

    private void addLabelToIndex(String label, String languageId) {
        String normalizedLabel = this.stringNormalizer.apply(label);
        if (this.ambiguousLabels.containsKey(normalizedLabel)) {
            List<String> alternatives = this.ambiguousLabels.get(normalizedLabel);
            if (!alternatives.contains(languageId)) {
                alternatives.add(languageId);
            }
        } else if (this.unambiguousLabels.containsKey(normalizedLabel)) {
            if (!this.unambiguousLabels.get(normalizedLabel).equals(languageId)) {
                String oldValue = this.unambiguousLabels.remove(normalizedLabel);
                ArrayList<String> alternatives = new ArrayList<String>();
                alternatives.add(oldValue);
                alternatives.add(languageId);
                this.ambiguousLabels.put(normalizedLabel, alternatives);
            }
        } else {
            this.unambiguousLabels.put(normalizedLabel, languageId);
        }
    }

    private void addCodeToIndex(String code, String languageId) {
        if (code == null) {
            return;
        }
        if (!LANGUAGE_CODE_MATCHER.matcher(code.trim()).matches()) {
            throw new IllegalArgumentException("Provided code does not qualify as a code: " + code);
        }
        String normalizedCode = this.stringNormalizer.apply(code);
        if (this.isoCodes.containsKey(normalizedCode) && !this.isoCodes.get(normalizedCode).equals(languageId)) {
            throw new IllegalStateException("Ambiguous iso code detected: " + normalizedCode);
        }
        this.isoCodes.put(normalizedCode, languageId);
    }

    public List<LanguageMatch> match(String input2) {
        String localeMatch = this.findLocaleMatch(input2);
        if (localeMatch != null) {
            return Collections.singletonList(new LanguageMatch(input2, localeMatch, LanguageMatch.Type.CODE_MATCH));
        }
        String[] words = this.stringNormalizer.apply(input2).split("\\s+");
        return Arrays.stream(words).map(this::matchNormalizedWord).collect(Collectors.toList());
    }

    private LanguageMatch matchNormalizedWord(String word) {
        List<String> ambiguousMatch;
        String unambiguousMatch;
        LanguageMatch result2 = null;
        String codeMatch = this.isoCodes.get(word);
        if (codeMatch != null) {
            result2 = new LanguageMatch(word, codeMatch, LanguageMatch.Type.CODE_MATCH);
        }
        if (result2 == null && (unambiguousMatch = this.unambiguousLabels.get(word)) != null) {
            result2 = new LanguageMatch(word, unambiguousMatch, LanguageMatch.Type.LABEL_MATCH);
        }
        if (result2 == null && (ambiguousMatch = this.ambiguousLabels.get(word)) != null) {
            String match;
            result2 = new LanguageMatch(word, match, (match = this.ambiguityHandling.resolveAmbiguousMatch(ambiguousMatch)) == null ? LanguageMatch.Type.NO_MATCH : LanguageMatch.Type.LABEL_MATCH);
        }
        if (result2 == null) {
            result2 = new LanguageMatch(word, null, LanguageMatch.Type.NO_MATCH);
        }
        return result2;
    }

    private String findLocaleMatch(String rawValue) {
        Matcher matcher = LOCALE_CODE_PATTERN.matcher(rawValue.trim());
        if (matcher.matches()) {
            return this.isoCodes.get(this.stringNormalizer.apply(matcher.group(1)));
        }
        return null;
    }
}

