/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.normalization;

import eu.europeana.normalization.languages.LanguageMatcher;
import eu.europeana.normalization.normalizers.CleanMarkupTagsNormalizer;
import eu.europeana.normalization.normalizers.CleanSpaceCharactersNormalizer;
import eu.europeana.normalization.normalizers.LanguageReferenceNormalizer;
import eu.europeana.normalization.normalizers.NormalizeAction;
import eu.europeana.normalization.normalizers.RemoveDuplicateStatementNormalizer;
import eu.europeana.normalization.settings.NormalizerSettings;
import eu.europeana.normalization.util.NormalizationConfigurationException;

public enum NormalizerStep {
    CLEAN_SPACE_CHARACTERS(settings -> new CleanSpaceCharactersNormalizer()),
    CLEAN_MARKUP_TAGS(settings -> new CleanMarkupTagsNormalizer(settings.getCleanMarkupTagsMode())),
    REMOVE_DUPLICATE_STATEMENTS(settings -> new RemoveDuplicateStatementNormalizer()),
    NORMALIZE_LANGUAGE_REFERENCES(settings -> {
        LanguageMatcher languageMatcher = new LanguageMatcher(settings.getMinLanguageLabelLength(), settings.getLanguageAmbiguityHandling(), settings.getTargetLanguageVocabulary());
        return new LanguageReferenceNormalizer(languageMatcher, settings.getMinimumConfidence(), settings.getLanguageElementsToNormalize());
    });

    private final ActionCreator actionCreator;

    private NormalizerStep(ActionCreator actionCreator) {
        this.actionCreator = actionCreator;
    }

    NormalizeAction createAction(NormalizerSettings settings) throws NormalizationConfigurationException {
        return this.actionCreator.create(settings);
    }

    @FunctionalInterface
    private static interface ActionCreator {
        public NormalizeAction create(NormalizerSettings var1) throws NormalizationConfigurationException;
    }
}

