/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.normalization;

import eu.europeana.normalization.Normalizer;
import eu.europeana.normalization.NormalizerImpl;
import eu.europeana.normalization.NormalizerStep;
import eu.europeana.normalization.normalizers.ChainedNormalizer;
import eu.europeana.normalization.normalizers.RecordNormalizeAction;
import eu.europeana.normalization.settings.NormalizerSettings;
import eu.europeana.normalization.util.NormalizationConfigurationException;
import java.util.ArrayList;

public class NormalizerFactory {
    private final NormalizerSettings settings;
    private static final NormalizerStep[] DEFAULT_NORMALIZER_STEPS = new NormalizerStep[]{NormalizerStep.CLEAN_SPACE_CHARACTERS, NormalizerStep.CLEAN_MARKUP_TAGS, NormalizerStep.NORMALIZE_LANGUAGE_REFERENCES, NormalizerStep.REMOVE_DUPLICATE_STATEMENTS};

    public NormalizerFactory() {
        this(new NormalizerSettings());
    }

    public NormalizerFactory(NormalizerSettings settings) {
        this.settings = settings;
    }

    public Normalizer getNormalizer() throws NormalizationConfigurationException {
        return this.getNormalizer(DEFAULT_NORMALIZER_STEPS);
    }

    public Normalizer getNormalizer(NormalizerStep ... normalizerSteps) throws NormalizationConfigurationException {
        if (normalizerSteps == null || normalizerSteps.length == 0) {
            throw new NormalizationConfigurationException("The list of steps cannot be empty.", null);
        }
        ArrayList<RecordNormalizeAction> actions = new ArrayList<RecordNormalizeAction>(normalizerSteps.length);
        for (NormalizerStep step : normalizerSteps) {
            actions.add(step.createAction(this.settings).getAsRecordNormalizer());
        }
        return new NormalizerImpl(new ChainedNormalizer(actions.toArray(new RecordNormalizeAction[0])));
    }
}

