/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.AnyTransliterator;
import com.ibm.icu.text.BreakTransliterator;
import com.ibm.icu.text.CaseFoldTransliterator;
import com.ibm.icu.text.CompoundTransliterator;
import com.ibm.icu.text.EscapeTransliterator;
import com.ibm.icu.text.LowercaseTransliterator;
import com.ibm.icu.text.NameUnicodeTransliterator;
import com.ibm.icu.text.NormalizationTransliterator;
import com.ibm.icu.text.NullTransliterator;
import com.ibm.icu.text.RemoveTransliterator;
import com.ibm.icu.text.Replaceable;
import com.ibm.icu.text.ReplaceableString;
import com.ibm.icu.text.RuleBasedTransliterator;
import com.ibm.icu.text.StringTransform;
import com.ibm.icu.text.TitlecaseTransliterator;
import com.ibm.icu.text.TransliteratorIDParser;
import com.ibm.icu.text.TransliteratorParser;
import com.ibm.icu.text.TransliteratorRegistry;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnescapeTransliterator;
import com.ibm.icu.text.UnicodeFilter;
import com.ibm.icu.text.UnicodeNameTransliterator;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UppercaseTransliterator;
import com.ibm.icu.util.CaseInsensitiveString;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Transliterator
implements StringTransform {
    public static final int FORWARD = 0;
    public static final int REVERSE = 1;
    private String ID;
    private UnicodeSet filter;
    private int maximumContextLength = 0;
    private static TransliteratorRegistry registry = new TransliteratorRegistry();
    private static Map<CaseInsensitiveString, String> displayNameCache = Collections.synchronizedMap(new HashMap());
    private static final String RB_DISPLAY_NAME_PREFIX = "%Translit%%";
    private static final String RB_SCRIPT_DISPLAY_NAME_PREFIX = "%Translit%";
    private static final String RB_DISPLAY_NAME_PATTERN = "TransliteratorNamePattern";
    static final char ID_DELIM = ';';
    static final char ID_SEP = '-';
    static final char VARIANT_SEP = '/';
    static final boolean DEBUG = false;
    private static final String INDEX = "index";
    private static final String RB_RULE_BASED_IDS = "RuleBasedTransliteratorIDs";

    protected Transliterator(String ID, UnicodeFilter filter2) {
        if (ID == null) {
            throw new NullPointerException();
        }
        this.ID = ID;
        this.setFilter(filter2);
    }

    public final int transliterate(Replaceable text2, int start, int limit) {
        if (start < 0 || limit < start || text2.length() < limit) {
            return -1;
        }
        Position pos = new Position(start, limit, start);
        this.filteredTransliterate(text2, pos, false, true);
        return pos.limit;
    }

    public final void transliterate(Replaceable text2) {
        this.transliterate(text2, 0, text2.length());
    }

    public final String transliterate(String text2) {
        ReplaceableString result2 = new ReplaceableString(text2);
        this.transliterate(result2);
        return result2.toString();
    }

    public final void transliterate(Replaceable text2, Position index2, String insertion) {
        index2.validate(text2.length());
        if (insertion != null) {
            text2.replace(index2.limit, index2.limit, insertion);
            index2.limit += insertion.length();
            index2.contextLimit += insertion.length();
        }
        if (index2.limit > 0 && UTF16.isLeadSurrogate(text2.charAt(index2.limit - 1))) {
            return;
        }
        this.filteredTransliterate(text2, index2, true, true);
    }

    public final void transliterate(Replaceable text2, Position index2, int insertion) {
        this.transliterate(text2, index2, UTF16.valueOf(insertion));
    }

    public final void transliterate(Replaceable text2, Position index2) {
        this.transliterate(text2, index2, null);
    }

    public final void finishTransliteration(Replaceable text2, Position index2) {
        index2.validate(text2.length());
        this.filteredTransliterate(text2, index2, false, true);
    }

    protected abstract void handleTransliterate(Replaceable var1, Position var2, boolean var3);

    private void filteredTransliterate(Replaceable text2, Position index2, boolean incremental, boolean rollback) {
        boolean isIncrementalRun;
        if (this.filter == null && !rollback) {
            this.handleTransliterate(text2, index2, incremental);
            return;
        }
        int globalLimit = index2.limit;
        Object log2 = null;
        do {
            int delta;
            if (this.filter != null) {
                int c;
                while (index2.start < globalLimit && !this.filter.contains(c = text2.char32At(index2.start))) {
                    index2.start += UTF16.getCharCount(c);
                }
                index2.limit = index2.start;
                while (index2.limit < globalLimit && this.filter.contains(c = text2.char32At(index2.limit))) {
                    index2.limit += UTF16.getCharCount(c);
                }
            }
            if (index2.start == index2.limit) break;
            boolean bl = isIncrementalRun = index2.limit < globalLimit ? false : incremental;
            if (rollback && isIncrementalRun) {
                int charLength;
                int runStart = index2.start;
                int runLimit = index2.limit;
                int runLength = runLimit - runStart;
                int rollbackOrigin = text2.length();
                text2.copy(runStart, runLimit, rollbackOrigin);
                int passStart = runStart;
                int rollbackStart = rollbackOrigin;
                int passLimit = index2.start;
                int uncommittedLength = 0;
                int totalDelta = 0;
                while ((passLimit += (charLength = UTF16.getCharCount(text2.char32At(passLimit)))) <= runLimit) {
                    uncommittedLength += charLength;
                    index2.limit = passLimit;
                    this.handleTransliterate(text2, index2, true);
                    delta = index2.limit - passLimit;
                    if (index2.start != index2.limit) {
                        int rs = rollbackStart + delta - (index2.limit - passStart);
                        text2.replace(passStart, index2.limit, "");
                        text2.copy(rs, rs + uncommittedLength, passStart);
                        index2.start = passStart;
                        index2.limit = passLimit;
                        index2.contextLimit -= delta;
                        continue;
                    }
                    passStart = passLimit = index2.start;
                    rollbackStart += delta + uncommittedLength;
                    uncommittedLength = 0;
                    runLimit += delta;
                    totalDelta += delta;
                }
                globalLimit += totalDelta;
                text2.replace(rollbackOrigin += totalDelta, rollbackOrigin + runLength, "");
                index2.start = passStart;
                continue;
            }
            int limit = index2.limit;
            this.handleTransliterate(text2, index2, isIncrementalRun);
            delta = index2.limit - limit;
            if (!isIncrementalRun && index2.start != index2.limit) {
                throw new RuntimeException("ERROR: Incomplete non-incremental transliteration by " + this.getID());
            }
            globalLimit += delta;
        } while (this.filter != null && !isIncrementalRun);
        index2.limit = globalLimit;
    }

    public void filteredTransliterate(Replaceable text2, Position index2, boolean incremental) {
        this.filteredTransliterate(text2, index2, incremental, false);
    }

    public final int getMaximumContextLength() {
        return this.maximumContextLength;
    }

    protected void setMaximumContextLength(int a) {
        if (a < 0) {
            throw new IllegalArgumentException("Invalid context length " + a);
        }
        this.maximumContextLength = a;
    }

    public final String getID() {
        return this.ID;
    }

    protected final void setID(String id) {
        this.ID = id;
    }

    public static final String getDisplayName(String ID) {
        return Transliterator.getDisplayName(ID, ULocale.getDefault(ULocale.Category.DISPLAY));
    }

    public static String getDisplayName(String id, Locale inLocale) {
        return Transliterator.getDisplayName(id, ULocale.forLocale(inLocale));
    }

    public static String getDisplayName(String id, ULocale inLocale) {
        String n;
        ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt51b/translit", inLocale);
        String[] stv = TransliteratorIDParser.IDtoSTV(id);
        if (stv == null) {
            return "";
        }
        String ID = stv[0] + '-' + stv[1];
        if (stv[2] != null && stv[2].length() > 0) {
            ID = ID + '/' + stv[2];
        }
        if ((n = displayNameCache.get(new CaseInsensitiveString(ID))) != null) {
            return n;
        }
        try {
            return bundle.getString(RB_DISPLAY_NAME_PREFIX + ID);
        }
        catch (MissingResourceException e) {
            try {
                MessageFormat format2 = new MessageFormat(bundle.getString(RB_DISPLAY_NAME_PATTERN));
                Object[] args = new Object[]{2, stv[0], stv[1]};
                for (int j = 1; j <= 2; ++j) {
                    try {
                        args[j] = bundle.getString(RB_SCRIPT_DISPLAY_NAME_PREFIX + (String)args[j]);
                        continue;
                    }
                    catch (MissingResourceException e2) {
                        // empty catch block
                    }
                }
                return stv[2].length() > 0 ? format2.format(args) + '/' + stv[2] : format2.format(args);
            }
            catch (MissingResourceException e2) {
                throw new RuntimeException();
            }
        }
    }

    public final UnicodeFilter getFilter() {
        return this.filter;
    }

    public void setFilter(UnicodeFilter filter2) {
        if (filter2 == null) {
            this.filter = null;
        } else {
            try {
                this.filter = new UnicodeSet((UnicodeSet)filter2).freeze();
            }
            catch (Exception e) {
                this.filter = new UnicodeSet();
                filter2.addMatchSetTo(this.filter);
                this.filter.freeze();
            }
        }
    }

    public static final Transliterator getInstance(String ID) {
        return Transliterator.getInstance(ID, 0);
    }

    public static Transliterator getInstance(String ID, int dir) {
        StringBuffer canonID = new StringBuffer();
        ArrayList<TransliteratorIDParser.SingleID> list2 = new ArrayList<TransliteratorIDParser.SingleID>();
        UnicodeSet[] globalFilter = new UnicodeSet[1];
        if (!TransliteratorIDParser.parseCompoundID(ID, dir, canonID, list2, globalFilter)) {
            throw new IllegalArgumentException("Invalid ID " + ID);
        }
        List<Transliterator> translits = TransliteratorIDParser.instantiateList(list2);
        Transliterator t = null;
        t = list2.size() > 1 || canonID.indexOf(";") >= 0 ? new CompoundTransliterator(translits) : translits.get(0);
        t.setID(canonID.toString());
        if (globalFilter[0] != null) {
            t.setFilter(globalFilter[0]);
        }
        return t;
    }

    static Transliterator getBasicInstance(String id, String canonID) {
        StringBuffer s2 = new StringBuffer();
        Transliterator t = registry.get(id, s2);
        if (s2.length() != 0) {
            t = Transliterator.getInstance(s2.toString(), 0);
        }
        if (t != null && canonID != null) {
            t.setID(canonID);
        }
        return t;
    }

    public static final Transliterator createFromRules(String ID, String rules, int dir) {
        Transliterator t = null;
        TransliteratorParser parser = new TransliteratorParser();
        parser.parse(rules, dir);
        if (parser.idBlockVector.size() == 0 && parser.dataVector.size() == 0) {
            t = new NullTransliterator();
        } else if (parser.idBlockVector.size() == 0 && parser.dataVector.size() == 1) {
            t = new RuleBasedTransliterator(ID, parser.dataVector.get(0), parser.compoundFilter);
        } else if (parser.idBlockVector.size() == 1 && parser.dataVector.size() == 0) {
            t = parser.compoundFilter != null ? Transliterator.getInstance(parser.compoundFilter.toPattern(false) + ";" + parser.idBlockVector.get(0)) : Transliterator.getInstance(parser.idBlockVector.get(0));
            if (t != null) {
                t.setID(ID);
            }
        } else {
            ArrayList<Transliterator> transliterators = new ArrayList<Transliterator>();
            int passNumber = 1;
            int limit = Math.max(parser.idBlockVector.size(), parser.dataVector.size());
            for (int i = 0; i < limit; ++i) {
                Transliterator temp;
                String idBlock;
                if (i < parser.idBlockVector.size() && (idBlock = parser.idBlockVector.get(i)).length() > 0 && !((temp = Transliterator.getInstance(idBlock)) instanceof NullTransliterator)) {
                    transliterators.add(Transliterator.getInstance(idBlock));
                }
                if (i >= parser.dataVector.size()) continue;
                RuleBasedTransliterator.Data data2 = parser.dataVector.get(i);
                transliterators.add(new RuleBasedTransliterator("%Pass" + passNumber++, data2, null));
            }
            t = new CompoundTransliterator(transliterators, passNumber - 1);
            t.setID(ID);
            if (parser.compoundFilter != null) {
                t.setFilter(parser.compoundFilter);
            }
        }
        return t;
    }

    public String toRules(boolean escapeUnprintable) {
        return this.baseToRules(escapeUnprintable);
    }

    protected final String baseToRules(boolean escapeUnprintable) {
        if (escapeUnprintable) {
            int c;
            StringBuffer rulesSource = new StringBuffer();
            String id = this.getID();
            for (int i = 0; i < id.length(); i += UTF16.getCharCount(c)) {
                c = UTF16.charAt(id, i);
                if (Utility.escapeUnprintable(rulesSource, c)) continue;
                UTF16.append(rulesSource, c);
            }
            rulesSource.insert(0, "::");
            rulesSource.append(';');
            return rulesSource.toString();
        }
        return "::" + this.getID() + ';';
    }

    public Transliterator[] getElements() {
        Transliterator[] result2;
        if (this instanceof CompoundTransliterator) {
            CompoundTransliterator cpd = (CompoundTransliterator)this;
            result2 = new Transliterator[cpd.getCount()];
            for (int i = 0; i < result2.length; ++i) {
                result2[i] = cpd.getTransliterator(i);
            }
        } else {
            result2 = new Transliterator[]{this};
        }
        return result2;
    }

    public final UnicodeSet getSourceSet() {
        UnicodeSet result2 = new UnicodeSet();
        this.addSourceTargetSet(this.getFilterAsUnicodeSet(UnicodeSet.ALL_CODE_POINTS), result2, new UnicodeSet());
        return result2;
    }

    protected UnicodeSet handleGetSourceSet() {
        return new UnicodeSet();
    }

    public UnicodeSet getTargetSet() {
        UnicodeSet result2 = new UnicodeSet();
        this.addSourceTargetSet(this.getFilterAsUnicodeSet(UnicodeSet.ALL_CODE_POINTS), new UnicodeSet(), result2);
        return result2;
    }

    public void addSourceTargetSet(UnicodeSet inputFilter, UnicodeSet sourceSet, UnicodeSet targetSet) {
        UnicodeSet myFilter = this.getFilterAsUnicodeSet(inputFilter);
        UnicodeSet temp = new UnicodeSet(this.handleGetSourceSet()).retainAll(myFilter);
        sourceSet.addAll(temp);
        for (String s2 : temp) {
            String t;
            if (s2.equals(t = this.transliterate(s2))) continue;
            targetSet.addAll((CharSequence)t);
        }
    }

    public UnicodeSet getFilterAsUnicodeSet(UnicodeSet externalFilter) {
        UnicodeSet temp;
        if (this.filter == null) {
            return externalFilter;
        }
        UnicodeSet filterSet = new UnicodeSet(externalFilter);
        try {
            temp = this.filter;
        }
        catch (ClassCastException e) {
            temp = new UnicodeSet();
            this.filter.addMatchSetTo(temp);
        }
        return filterSet.retainAll(temp).freeze();
    }

    public final Transliterator getInverse() {
        return Transliterator.getInstance(this.ID, 1);
    }

    public static void registerClass(String ID, Class<? extends Transliterator> transClass, String displayName) {
        registry.put(ID, transClass, true);
        if (displayName != null) {
            displayNameCache.put(new CaseInsensitiveString(ID), displayName);
        }
    }

    public static void registerFactory(String ID, Factory factory) {
        registry.put(ID, factory, true);
    }

    public static void registerInstance(Transliterator trans) {
        registry.put(trans.getID(), trans, true);
    }

    static void registerInstance(Transliterator trans, boolean visible) {
        registry.put(trans.getID(), trans, visible);
    }

    public static void registerAlias(String aliasID, String realID) {
        registry.put(aliasID, realID, true);
    }

    static void registerSpecialInverse(String target, String inverseTarget, boolean bidirectional) {
        TransliteratorIDParser.registerSpecialInverse(target, inverseTarget, bidirectional);
    }

    public static void unregister(String ID) {
        displayNameCache.remove(new CaseInsensitiveString(ID));
        registry.remove(ID);
    }

    public static final Enumeration<String> getAvailableIDs() {
        return registry.getAvailableIDs();
    }

    public static final Enumeration<String> getAvailableSources() {
        return registry.getAvailableSources();
    }

    public static final Enumeration<String> getAvailableTargets(String source) {
        return registry.getAvailableTargets(source);
    }

    public static final Enumeration<String> getAvailableVariants(String source, String target) {
        return registry.getAvailableVariants(source, target);
    }

    public static void registerAny() {
        AnyTransliterator.register();
    }

    @Override
    public String transform(String source) {
        return this.transliterate(source);
    }

    static {
        UResourceBundle bundle = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt51b/translit", INDEX);
        UResourceBundle transIDs = bundle.get(RB_RULE_BASED_IDS);
        int maxRows = transIDs.getSize();
        for (int row = 0; row < maxRows; ++row) {
            String resString;
            UResourceBundle colBund = transIDs.get(row);
            String ID = colBund.getKey();
            UResourceBundle res = colBund.get(0);
            String type = res.getKey();
            if (type.equals("file") || type.equals("internal")) {
                int dir;
                resString = res.getString("resource");
                String direction = res.getString("direction");
                switch (direction.charAt(0)) {
                    case 'F': {
                        dir = 0;
                        break;
                    }
                    case 'R': {
                        dir = 1;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Can't parse direction: " + direction);
                    }
                }
                registry.put(ID, resString, "UTF-16", dir, !type.equals("internal"));
                continue;
            }
            if (type.equals("alias")) {
                resString = res.getString();
                registry.put(ID, resString, true);
                continue;
            }
            throw new RuntimeException("Unknow type: " + type);
        }
        Transliterator.registerSpecialInverse(NullTransliterator.SHORT_ID, NullTransliterator.SHORT_ID, false);
        Transliterator.registerClass(NullTransliterator._ID, NullTransliterator.class, null);
        RemoveTransliterator.register();
        EscapeTransliterator.register();
        UnescapeTransliterator.register();
        LowercaseTransliterator.register();
        UppercaseTransliterator.register();
        TitlecaseTransliterator.register();
        CaseFoldTransliterator.register();
        UnicodeNameTransliterator.register();
        NameUnicodeTransliterator.register();
        NormalizationTransliterator.register();
        BreakTransliterator.register();
        AnyTransliterator.register();
    }

    public static interface Factory {
        public Transliterator getInstance(String var1);
    }

    public static class Position {
        public int contextStart;
        public int contextLimit;
        public int start;
        public int limit;

        public Position() {
            this(0, 0, 0, 0);
        }

        public Position(int contextStart, int contextLimit, int start) {
            this(contextStart, contextLimit, start, contextLimit);
        }

        public Position(int contextStart, int contextLimit, int start, int limit) {
            this.contextStart = contextStart;
            this.contextLimit = contextLimit;
            this.start = start;
            this.limit = limit;
        }

        public Position(Position pos) {
            this.set(pos);
        }

        public void set(Position pos) {
            this.contextStart = pos.contextStart;
            this.contextLimit = pos.contextLimit;
            this.start = pos.start;
            this.limit = pos.limit;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Position) {
                Position pos = (Position)obj;
                return this.contextStart == pos.contextStart && this.contextLimit == pos.contextLimit && this.start == pos.start && this.limit == pos.limit;
            }
            return false;
        }

        public int hashCode() {
            assert (false) : "hashCode not designed";
            return 42;
        }

        public String toString() {
            return "[cs=" + this.contextStart + ", s=" + this.start + ", l=" + this.limit + ", cl=" + this.contextLimit + "]";
        }

        public final void validate(int length) {
            if (this.contextStart < 0 || this.start < this.contextStart || this.limit < this.start || this.contextLimit < this.limit || length < this.contextLimit) {
                throw new IllegalArgumentException("Invalid Position {cs=" + this.contextStart + ", s=" + this.start + ", l=" + this.limit + ", cl=" + this.contextLimit + "}, len=" + length);
            }
        }
    }
}

