/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import java.text.CharacterIterator;

public final class StringCharacterIterator
implements CharacterIterator {
    private String text;
    private int begin;
    private int end;
    private int pos;

    public StringCharacterIterator(String text2) {
        this(text2, 0);
    }

    public StringCharacterIterator(String text2, int pos) {
        this(text2, 0, text2.length(), pos);
    }

    public StringCharacterIterator(String text2, int begin, int end, int pos) {
        if (text2 == null) {
            throw new NullPointerException();
        }
        this.text = text2;
        if (begin < 0 || begin > end || end > text2.length()) {
            throw new IllegalArgumentException("Invalid substring range");
        }
        if (pos < begin || pos > end) {
            throw new IllegalArgumentException("Invalid position");
        }
        this.begin = begin;
        this.end = end;
        this.pos = pos;
    }

    public void setText(String text2) {
        if (text2 == null) {
            throw new NullPointerException();
        }
        this.text = text2;
        this.begin = 0;
        this.end = text2.length();
        this.pos = 0;
    }

    public char first() {
        this.pos = this.begin;
        return this.current();
    }

    public char last() {
        this.pos = this.end != this.begin ? this.end - 1 : this.end;
        return this.current();
    }

    public char setIndex(int p) {
        if (p < this.begin || p > this.end) {
            throw new IllegalArgumentException("Invalid index");
        }
        this.pos = p;
        return this.current();
    }

    public char current() {
        if (this.pos >= this.begin && this.pos < this.end) {
            return this.text.charAt(this.pos);
        }
        return '\uffff';
    }

    public char next() {
        if (this.pos < this.end - 1) {
            ++this.pos;
            return this.text.charAt(this.pos);
        }
        this.pos = this.end;
        return '\uffff';
    }

    public char previous() {
        if (this.pos > this.begin) {
            --this.pos;
            return this.text.charAt(this.pos);
        }
        return '\uffff';
    }

    public int getBeginIndex() {
        return this.begin;
    }

    public int getEndIndex() {
        return this.end;
    }

    public int getIndex() {
        return this.pos;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StringCharacterIterator)) {
            return false;
        }
        StringCharacterIterator that = (StringCharacterIterator)obj;
        if (this.hashCode() != that.hashCode()) {
            return false;
        }
        if (!this.text.equals(that.text)) {
            return false;
        }
        return this.pos == that.pos && this.begin == that.begin && this.end == that.end;
    }

    public int hashCode() {
        return this.text.hashCode() ^ this.pos ^ this.begin ^ this.end;
    }

    public Object clone() {
        try {
            StringCharacterIterator other = (StringCharacterIterator)super.clone();
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }
}

