/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.text.CurrencyMetaInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICUCurrencyMetaInfo
extends CurrencyMetaInfo {
    private ICUResourceBundle regionInfo;
    private ICUResourceBundle digitInfo;
    private static final long MASK = 0xFFFFFFFFL;
    private static final int Region = 1;
    private static final int Currency = 2;
    private static final int Date = 4;
    private static final int Tender = 8;
    private static final int Everything = Integer.MAX_VALUE;

    public ICUCurrencyMetaInfo() {
        ICUResourceBundle bundle = (ICUResourceBundle)ICUResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt51b/curr", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        this.regionInfo = bundle.findTopLevel("CurrencyMap");
        this.digitInfo = bundle.findTopLevel("CurrencyMeta");
    }

    @Override
    public List<CurrencyMetaInfo.CurrencyInfo> currencyInfo(CurrencyMetaInfo.CurrencyFilter filter2) {
        return this.collect(new InfoCollector(), filter2);
    }

    @Override
    public List<String> currencies(CurrencyMetaInfo.CurrencyFilter filter2) {
        return this.collect(new CurrencyCollector(), filter2);
    }

    @Override
    public List<String> regions(CurrencyMetaInfo.CurrencyFilter filter2) {
        return this.collect(new RegionCollector(), filter2);
    }

    @Override
    public CurrencyMetaInfo.CurrencyDigits currencyDigits(String isoCode) {
        ICUResourceBundle b = this.digitInfo.findWithFallback(isoCode);
        if (b == null) {
            b = this.digitInfo.findWithFallback("DEFAULT");
        }
        int[] data2 = b.getIntVector();
        return new CurrencyMetaInfo.CurrencyDigits(data2[0], data2[1]);
    }

    private <T> List<T> collect(Collector<T> collector, CurrencyMetaInfo.CurrencyFilter filter2) {
        if (filter2 == null) {
            filter2 = CurrencyMetaInfo.CurrencyFilter.all();
        }
        int needed = collector.collects();
        if (filter2.region != null) {
            needed |= 1;
        }
        if (filter2.currency != null) {
            needed |= 2;
        }
        if (filter2.from != Long.MIN_VALUE || filter2.to != Long.MAX_VALUE) {
            needed |= 4;
        }
        if (filter2.tenderOnly) {
            needed |= 8;
        }
        if (needed != 0) {
            if (filter2.region != null) {
                ICUResourceBundle b = this.regionInfo.findWithFallback(filter2.region);
                if (b != null) {
                    this.collectRegion(collector, filter2, needed, b);
                }
            } else {
                for (int i = 0; i < this.regionInfo.getSize(); ++i) {
                    this.collectRegion(collector, filter2, needed, this.regionInfo.at(i));
                }
            }
        }
        return collector.getList();
    }

    private <T> void collectRegion(Collector<T> collector, CurrencyMetaInfo.CurrencyFilter filter2, int needed, ICUResourceBundle b) {
        String region = b.getKey();
        if (needed == 1) {
            collector.collect(b.getKey(), null, 0L, 0L, -1, false);
            return;
        }
        for (int i = 0; i < b.getSize(); ++i) {
            ICUResourceBundle r = b.at(i);
            if (r.getSize() == 0) continue;
            String currency = null;
            long from2 = Long.MIN_VALUE;
            long to2 = Long.MAX_VALUE;
            boolean tender = true;
            if ((needed & 2) != 0) {
                ICUResourceBundle currBundle = r.at("id");
                currency = currBundle.getString();
                if (filter2.currency != null && !filter2.currency.equals(currency)) continue;
            }
            if ((needed & 4) != 0) {
                from2 = this.getDate(r.at("from"), Long.MIN_VALUE, false);
                to2 = this.getDate(r.at("to"), Long.MAX_VALUE, true);
                if (filter2.from > to2 || filter2.to < from2) continue;
            }
            if ((needed & 8) != 0) {
                ICUResourceBundle tenderBundle = r.at("tender");
                boolean bl = tender = tenderBundle == null || "true".equals(tenderBundle.getString());
                if (filter2.tenderOnly && !tender) continue;
            }
            collector.collect(region, currency, from2, to2, i, tender);
        }
    }

    private long getDate(ICUResourceBundle b, long defaultValue, boolean endOfDay) {
        if (b == null) {
            return defaultValue;
        }
        int[] values = b.getIntVector();
        return (long)values[0] << 32 | (long)values[1] & 0xFFFFFFFFL;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Collector<T> {
        public int collects();

        public void collect(String var1, String var2, long var3, long var5, int var7, boolean var8);

        public List<T> getList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CurrencyCollector
    implements Collector<String> {
        private final UniqueList<String> result = UniqueList.access$300();

        private CurrencyCollector() {
        }

        @Override
        public void collect(String region, String currency, long from2, long to2, int priority, boolean tender) {
            this.result.add(currency);
        }

        @Override
        public int collects() {
            return 2;
        }

        @Override
        public List<String> getList() {
            return this.result.list();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RegionCollector
    implements Collector<String> {
        private final UniqueList<String> result = UniqueList.access$300();

        private RegionCollector() {
        }

        @Override
        public void collect(String region, String currency, long from2, long to2, int priority, boolean tender) {
            this.result.add(region);
        }

        @Override
        public int collects() {
            return 1;
        }

        @Override
        public List<String> getList() {
            return this.result.list();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InfoCollector
    implements Collector<CurrencyMetaInfo.CurrencyInfo> {
        private List<CurrencyMetaInfo.CurrencyInfo> result = new ArrayList<CurrencyMetaInfo.CurrencyInfo>();

        private InfoCollector() {
        }

        @Override
        public void collect(String region, String currency, long from2, long to2, int priority, boolean tender) {
            this.result.add(new CurrencyMetaInfo.CurrencyInfo(region, currency, from2, to2, priority, tender));
        }

        @Override
        public List<CurrencyMetaInfo.CurrencyInfo> getList() {
            return Collections.unmodifiableList(this.result);
        }

        @Override
        public int collects() {
            return Integer.MAX_VALUE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UniqueList<T> {
        private Set<T> seen = new HashSet<T>();
        private List<T> list = new ArrayList<T>();

        private UniqueList() {
        }

        private static <T> UniqueList<T> create() {
            return new UniqueList<T>();
        }

        void add(T value2) {
            if (!this.seen.contains(value2)) {
                this.list.add(value2);
                this.seen.add(value2);
            }
        }

        List<T> list() {
            return Collections.unmodifiableList(this.list);
        }

        static /* synthetic */ UniqueList access$300() {
            return UniqueList.create();
        }
    }
}

