/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.jta;

import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.springframework.transaction.jta.ManagedTransactionAdapter;
import org.springframework.transaction.jta.TransactionFactory;
import org.springframework.util.Assert;

public class SimpleTransactionFactory
implements TransactionFactory {
    private final TransactionManager transactionManager;

    public SimpleTransactionFactory(TransactionManager transactionManager) {
        Assert.notNull((Object)transactionManager, "TransactionManager must not be null");
        this.transactionManager = transactionManager;
    }

    public Transaction createTransaction(String name, int timeout) throws NotSupportedException, SystemException {
        if (timeout >= 0) {
            this.transactionManager.setTransactionTimeout(timeout);
        }
        this.transactionManager.begin();
        return new ManagedTransactionAdapter(this.transactionManager);
    }

    public boolean supportsResourceAdapterManagedTransactions() {
        return false;
    }
}

