/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.header.writers;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class DelegatingRequestMatcherHeaderWriter
implements HeaderWriter {
    private final RequestMatcher requestMatcher;
    private final HeaderWriter delegateHeaderWriter;

    public DelegatingRequestMatcherHeaderWriter(RequestMatcher requestMatcher, HeaderWriter delegateHeaderWriter) {
        Assert.notNull((Object)requestMatcher, "requestMatcher cannot be null");
        Assert.notNull((Object)delegateHeaderWriter, "delegateHeaderWriter cannot be null");
        this.requestMatcher = requestMatcher;
        this.delegateHeaderWriter = delegateHeaderWriter;
    }

    public void writeHeaders(HttpServletRequest request, HttpServletResponse response) {
        if (this.requestMatcher.matches(request)) {
            this.delegateHeaderWriter.writeHeaders(request, response);
        }
    }

    public String toString() {
        return this.getClass().getName() + " [requestMatcher=" + this.requestMatcher + ", delegateHeaderWriter=" + this.delegateHeaderWriter + "]";
    }
}

