/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.csrf;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.util.Assert;

public final class CsrfAuthenticationStrategy
implements SessionAuthenticationStrategy {
    private final CsrfTokenRepository csrfTokenRepository;

    public CsrfAuthenticationStrategy(CsrfTokenRepository csrfTokenRepository) {
        Assert.notNull((Object)csrfTokenRepository, "csrfTokenRepository cannot be null");
        this.csrfTokenRepository = csrfTokenRepository;
    }

    public void onAuthentication(Authentication authentication, HttpServletRequest request, HttpServletResponse response) throws SessionAuthenticationException {
        boolean containsToken;
        boolean bl = containsToken = this.csrfTokenRepository.loadToken(request) != null;
        if (containsToken) {
            CsrfToken newToken = this.csrfTokenRepository.generateToken(request);
            this.csrfTokenRepository.saveToken(null, request, response);
            this.csrfTokenRepository.saveToken(newToken, request, response);
        }
    }
}

