/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.preauth.j2ee;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.security.core.authority.mapping.MappableAttributesRetriever;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebXmlMappableAttributesRetriever
implements ResourceLoaderAware,
MappableAttributesRetriever,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ResourceLoader resourceLoader;
    private Set<String> mappableAttributes;

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Override
    public Set<String> getMappableAttributes() {
        return this.mappableAttributes;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Resource webXml = this.resourceLoader.getResource("/WEB-INF/web.xml");
        Document doc = this.getDocument(webXml.getInputStream());
        NodeList webApp = doc.getElementsByTagName("web-app");
        if (webApp.getLength() != 1) {
            throw new IllegalArgumentException("Failed to find 'web-app' element in resource" + webXml);
        }
        NodeList securityRoles = ((Element)webApp.item(0)).getElementsByTagName("security-role");
        ArrayList<String> roleNames = new ArrayList<String>();
        for (int i = 0; i < securityRoles.getLength(); ++i) {
            Element secRoleElt = (Element)securityRoles.item(i);
            NodeList roles = secRoleElt.getElementsByTagName("role-name");
            if (roles.getLength() > 0) {
                String roleName = ((Element)roles.item(0)).getTextContent().trim();
                roleNames.add(roleName);
                this.logger.info("Retrieved role-name '" + roleName + "' from web.xml");
                continue;
            }
            this.logger.info("No security-role elements found in " + webXml);
        }
        this.mappableAttributes = Collections.unmodifiableSet(new HashSet(roleNames));
    }

    private Document getDocument(InputStream aStream) {
        try {
            Document doc;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder db = factory.newDocumentBuilder();
            db.setEntityResolver(new MyEntityResolver());
            Document document = doc = db.parse(aStream);
            return document;
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException("Unable to parse document object", e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Unable to parse document object", e);
        }
        catch (SAXException e) {
            throw new RuntimeException("Unable to parse document object", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to parse document object", e);
        }
        finally {
            try {
                aStream.close();
            }
            catch (IOException e) {
                this.logger.warn("Failed to close input stream for web.xml", e);
            }
        }
    }

    private static final class MyEntityResolver
    implements EntityResolver {
        private MyEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new StringReader(""));
        }
    }
}

