/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.intercept.AbstractSecurityInterceptor;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.WebInvocationPrivilegeEvaluator;
import org.springframework.util.Assert;

public class DefaultWebInvocationPrivilegeEvaluator
implements WebInvocationPrivilegeEvaluator {
    protected static final Log logger = LogFactory.getLog(DefaultWebInvocationPrivilegeEvaluator.class);
    private final AbstractSecurityInterceptor securityInterceptor;

    public DefaultWebInvocationPrivilegeEvaluator(AbstractSecurityInterceptor securityInterceptor) {
        Assert.notNull((Object)securityInterceptor, "SecurityInterceptor cannot be null");
        Assert.isTrue(FilterInvocation.class.equals(securityInterceptor.getSecureObjectClass()), "AbstractSecurityInterceptor does not support FilterInvocations");
        Assert.notNull((Object)securityInterceptor.getAccessDecisionManager(), "AbstractSecurityInterceptor must provide a non-null AccessDecisionManager");
        this.securityInterceptor = securityInterceptor;
    }

    public boolean isAllowed(String uri, Authentication authentication) {
        return this.isAllowed(null, uri, null, authentication);
    }

    public boolean isAllowed(String contextPath, String uri, String method, Authentication authentication) {
        Assert.notNull((Object)uri, "uri parameter is required");
        FilterInvocation fi = new FilterInvocation(contextPath, uri, method);
        Collection<ConfigAttribute> attrs = this.securityInterceptor.obtainSecurityMetadataSource().getAttributes(fi);
        if (attrs == null) {
            return !this.securityInterceptor.isRejectPublicInvocations();
        }
        if (authentication == null) {
            return false;
        }
        try {
            this.securityInterceptor.getAccessDecisionManager().decide(authentication, fi, attrs);
        }
        catch (AccessDeniedException unauthorized) {
            if (logger.isDebugEnabled()) {
                logger.debug(fi.toString() + " denied for " + authentication.toString(), unauthorized);
            }
            return false;
        }
        return true;
    }
}

