/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import java.util.ArrayList;
import java.util.List;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.header.HeaderWriterFilter;
import org.springframework.security.web.header.writers.CacheControlHeadersWriter;
import org.springframework.security.web.header.writers.HstsHeaderWriter;
import org.springframework.security.web.header.writers.XContentTypeOptionsHeaderWriter;
import org.springframework.security.web.header.writers.XXssProtectionHeaderWriter;
import org.springframework.security.web.header.writers.frameoptions.XFrameOptionsHeaderWriter;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HeadersConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<HeadersConfigurer<H>, H> {
    private List<HeaderWriter> headerWriters = new ArrayList<HeaderWriter>();

    public HeadersConfigurer<H> addHeaderWriter(HeaderWriter headerWriter) {
        Assert.notNull((Object)headerWriter, "headerWriter cannot be null");
        this.headerWriters.add(headerWriter);
        return this;
    }

    public HeadersConfigurer<H> contentTypeOptions() {
        return this.addHeaderWriter(new XContentTypeOptionsHeaderWriter());
    }

    public HeadersConfigurer<H> xssProtection() {
        return this.addHeaderWriter(new XXssProtectionHeaderWriter());
    }

    public HeadersConfigurer<H> cacheControl() {
        return this.addHeaderWriter(new CacheControlHeadersWriter());
    }

    public HeadersConfigurer<H> httpStrictTransportSecurity() {
        return this.addHeaderWriter(new HstsHeaderWriter());
    }

    public HeadersConfigurer<H> frameOptions() {
        return this.addHeaderWriter(new XFrameOptionsHeaderWriter());
    }

    @Override
    public void configure(H http) throws Exception {
        HeaderWriterFilter headersFilter = this.createHeaderWriterFilter();
        http.addFilter(headersFilter);
    }

    private HeaderWriterFilter createHeaderWriterFilter() {
        HeaderWriterFilter headersFilter = new HeaderWriterFilter(this.getHeaderWriters());
        headersFilter = this.postProcess(headersFilter);
        return headersFilter;
    }

    private List<HeaderWriter> getHeaderWriters() {
        if (this.headerWriters.isEmpty()) {
            this.addDefaultHeaderWriters();
        }
        return this.headerWriters;
    }

    private void addDefaultHeaderWriters() {
        this.contentTypeOptions();
        this.xssProtection();
        this.cacheControl();
        this.httpStrictTransportSecurity();
        this.frameOptions();
    }
}

