/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.domain;

import java.io.Serializable;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.springframework.security.acls.domain.AclAuthorizationStrategy;
import org.springframework.security.acls.domain.AclImpl;
import org.springframework.security.acls.model.AclCache;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.PermissionGrantingStrategy;
import org.springframework.security.util.FieldUtils;
import org.springframework.util.Assert;

public class EhCacheBasedAclCache
implements AclCache {
    private final Ehcache cache;
    private PermissionGrantingStrategy permissionGrantingStrategy;
    private AclAuthorizationStrategy aclAuthorizationStrategy;

    @Deprecated
    public EhCacheBasedAclCache(Ehcache cache) {
        Assert.notNull((Object)cache, "Cache required");
        this.cache = cache;
    }

    public EhCacheBasedAclCache(Ehcache cache, PermissionGrantingStrategy permissionGrantingStrategy, AclAuthorizationStrategy aclAuthorizationStrategy) {
        Assert.notNull((Object)cache, "Cache required");
        Assert.notNull((Object)permissionGrantingStrategy, "PermissionGrantingStrategy required");
        Assert.notNull((Object)aclAuthorizationStrategy, "AclAuthorizationStrategy required");
        this.cache = cache;
        this.permissionGrantingStrategy = permissionGrantingStrategy;
        this.aclAuthorizationStrategy = aclAuthorizationStrategy;
    }

    public void evictFromCache(Serializable pk) {
        Assert.notNull((Object)pk, "Primary key (identifier) required");
        MutableAcl acl = this.getFromCache(pk);
        if (acl != null) {
            this.cache.remove(acl.getId());
            this.cache.remove((Serializable)acl.getObjectIdentity());
        }
    }

    public void evictFromCache(ObjectIdentity objectIdentity) {
        Assert.notNull((Object)objectIdentity, "ObjectIdentity required");
        MutableAcl acl = this.getFromCache(objectIdentity);
        if (acl != null) {
            this.cache.remove(acl.getId());
            this.cache.remove((Serializable)acl.getObjectIdentity());
        }
    }

    public MutableAcl getFromCache(ObjectIdentity objectIdentity) {
        Assert.notNull((Object)objectIdentity, "ObjectIdentity required");
        Element element = null;
        try {
            element = this.cache.get((Serializable)objectIdentity);
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
        if (element == null) {
            return null;
        }
        return this.initializeTransientFields((MutableAcl)element.getValue());
    }

    public MutableAcl getFromCache(Serializable pk) {
        Assert.notNull((Object)pk, "Primary key (identifier) required");
        Element element = null;
        try {
            element = this.cache.get(pk);
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
        if (element == null) {
            return null;
        }
        return this.initializeTransientFields((MutableAcl)element.getValue());
    }

    public void putInCache(MutableAcl acl) {
        Assert.notNull((Object)acl, "Acl required");
        Assert.notNull((Object)acl.getObjectIdentity(), "ObjectIdentity required");
        Assert.notNull((Object)acl.getId(), "ID required");
        if (this.aclAuthorizationStrategy == null && acl instanceof AclImpl) {
            this.aclAuthorizationStrategy = (AclAuthorizationStrategy)FieldUtils.getProtectedFieldValue("aclAuthorizationStrategy", acl);
            this.permissionGrantingStrategy = (PermissionGrantingStrategy)FieldUtils.getProtectedFieldValue("permissionGrantingStrategy", acl);
        }
        if (acl.getParentAcl() != null && acl.getParentAcl() instanceof MutableAcl) {
            this.putInCache((MutableAcl)acl.getParentAcl());
        }
        this.cache.put(new Element((Serializable)acl.getObjectIdentity(), (Serializable)acl));
        this.cache.put(new Element(acl.getId(), (Serializable)acl));
    }

    private MutableAcl initializeTransientFields(MutableAcl value) {
        if (value instanceof AclImpl) {
            FieldUtils.setProtectedFieldValue("aclAuthorizationStrategy", value, this.aclAuthorizationStrategy);
            FieldUtils.setProtectedFieldValue("permissionGrantingStrategy", value, this.permissionGrantingStrategy);
        }
        if (value.getParentAcl() != null) {
            this.initializeTransientFields((MutableAcl)value.getParentAcl());
        }
        return value;
    }

    public void clearCache() {
        this.cache.removeAll();
    }
}

