/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.domain;

import java.util.List;
import org.springframework.security.acls.domain.AuditLogger;
import org.springframework.security.acls.model.AccessControlEntry;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.PermissionGrantingStrategy;
import org.springframework.security.acls.model.Sid;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPermissionGrantingStrategy
implements PermissionGrantingStrategy {
    private final transient AuditLogger auditLogger;

    public DefaultPermissionGrantingStrategy(AuditLogger auditLogger) {
        Assert.notNull((Object)auditLogger, "auditLogger cannot be null");
        this.auditLogger = auditLogger;
    }

    @Override
    public boolean isGranted(Acl acl, List<Permission> permission, List<Sid> sids, boolean administrativeMode) throws NotFoundException {
        List<AccessControlEntry> aces = acl.getEntries();
        AccessControlEntry firstRejection = null;
        block0: for (Permission p : permission) {
            for (Sid sid : sids) {
                boolean scanNextSid = true;
                for (AccessControlEntry ace : aces) {
                    if (ace.getPermission().getMask() != p.getMask() || !ace.getSid().equals(sid)) continue;
                    if (ace.isGranting()) {
                        if (!administrativeMode) {
                            this.auditLogger.logIfNeeded(true, ace);
                        }
                        return true;
                    }
                    if (firstRejection == null) {
                        firstRejection = ace;
                    }
                    scanNextSid = false;
                    break;
                }
                if (scanNextSid) continue;
                continue block0;
            }
        }
        if (firstRejection != null) {
            if (!administrativeMode) {
                this.auditLogger.logIfNeeded(false, firstRejection);
            }
            return false;
        }
        if (acl.isEntriesInheriting() && acl.getParentAcl() != null) {
            return acl.getParentAcl().isGranted(permission, sids, false);
        }
        throw new NotFoundException("Unable to locate a matching ACE for passed permissions and SIDs");
    }
}

