/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.intercept;

import java.util.Collection;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.intercept.AbstractSecurityInterceptor;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;

public class MethodInvocationPrivilegeEvaluator
implements InitializingBean {
    protected static final Log logger = LogFactory.getLog(MethodInvocationPrivilegeEvaluator.class);
    private AbstractSecurityInterceptor securityInterceptor;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.securityInterceptor, "SecurityInterceptor required");
    }

    public boolean isAllowed(MethodInvocation mi, Authentication authentication) {
        Assert.notNull((Object)mi, "MethodInvocation required");
        Assert.notNull((Object)mi.getMethod(), "MethodInvocation must provide a non-null getMethod()");
        Collection<ConfigAttribute> attrs = this.securityInterceptor.obtainSecurityMetadataSource().getAttributes(mi);
        if (attrs == null) {
            return !this.securityInterceptor.isRejectPublicInvocations();
        }
        if (authentication == null || authentication.getAuthorities().isEmpty()) {
            return false;
        }
        try {
            this.securityInterceptor.getAccessDecisionManager().decide(authentication, mi, attrs);
        }
        catch (AccessDeniedException unauthorized) {
            if (logger.isDebugEnabled()) {
                logger.debug(mi.toString() + " denied for " + authentication.toString(), unauthorized);
            }
            return false;
        }
        return true;
    }

    public void setSecurityInterceptor(AbstractSecurityInterceptor securityInterceptor) {
        Assert.notNull((Object)securityInterceptor, "AbstractSecurityInterceptor cannot be null");
        Assert.isTrue(MethodInvocation.class.equals(securityInterceptor.getSecureObjectClass()), "AbstractSecurityInterceptor does not support MethodInvocations");
        Assert.notNull((Object)securityInterceptor.getAccessDecisionManager(), "AbstractSecurityInterceptor must provide a non-null AccessDecisionManager");
        this.securityInterceptor = securityInterceptor;
    }
}

