/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scripting.bsh;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.Primitive;
import bsh.XThis;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.springframework.core.NestedRuntimeException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public abstract class BshScriptUtils {
    public static Object createBshObject(String scriptSource) throws EvalError {
        return BshScriptUtils.createBshObject(scriptSource, null, null);
    }

    public static Object createBshObject(String scriptSource, Class<?> ... scriptInterfaces) throws EvalError {
        return BshScriptUtils.createBshObject(scriptSource, scriptInterfaces, ClassUtils.getDefaultClassLoader());
    }

    public static Object createBshObject(String scriptSource, @Nullable Class<?>[] scriptInterfaces, @Nullable ClassLoader classLoader) throws EvalError {
        Object result2 = BshScriptUtils.evaluateBshScript(scriptSource, scriptInterfaces, classLoader);
        if (result2 instanceof Class) {
            Class clazz = (Class)result2;
            try {
                return ReflectionUtils.accessibleConstructor(clazz, new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Could not instantiate script class: " + clazz.getName(), ex);
            }
        }
        return result2;
    }

    @Nullable
    static Class<?> determineBshObjectType(String scriptSource, @Nullable ClassLoader classLoader) throws EvalError {
        Object result2;
        Assert.hasText(scriptSource, "Script source must not be empty");
        Interpreter interpreter = new Interpreter();
        if (classLoader != null) {
            interpreter.setClassLoader(classLoader);
        }
        if ((result2 = interpreter.eval(scriptSource)) instanceof Class) {
            return (Class)result2;
        }
        if (result2 != null) {
            return result2.getClass();
        }
        return null;
    }

    static Object evaluateBshScript(String scriptSource, @Nullable Class<?>[] scriptInterfaces, @Nullable ClassLoader classLoader) throws EvalError {
        Assert.hasText(scriptSource, "Script source must not be empty");
        Interpreter interpreter = new Interpreter();
        interpreter.setClassLoader(classLoader);
        Object result2 = interpreter.eval(scriptSource);
        if (result2 != null) {
            return result2;
        }
        if (ObjectUtils.isEmpty(scriptInterfaces)) {
            throw new IllegalArgumentException("Given script requires a script proxy: At least one script interface is required.\nScript: " + scriptSource);
        }
        XThis xt = (XThis)interpreter.eval("return this");
        return Proxy.newProxyInstance(classLoader, scriptInterfaces, (InvocationHandler)new BshObjectInvocationHandler(xt));
    }

    public static final class BshExecutionException
    extends NestedRuntimeException {
        private BshExecutionException(EvalError ex) {
            super("BeanShell script execution failed", ex);
        }
    }

    private static class BshObjectInvocationHandler
    implements InvocationHandler {
        private final XThis xt;

        public BshObjectInvocationHandler(XThis xt) {
            this.xt = xt;
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (ReflectionUtils.isEqualsMethod(method)) {
                return this.isProxyForSameBshObject(args[0]);
            }
            if (ReflectionUtils.isHashCodeMethod(method)) {
                return this.xt.hashCode();
            }
            if (ReflectionUtils.isToStringMethod(method)) {
                return "BeanShell object [" + this.xt + "]";
            }
            try {
                Object result2 = this.xt.invokeMethod(method.getName(), args);
                if (result2 == Primitive.NULL || result2 == Primitive.VOID) {
                    return null;
                }
                if (result2 instanceof Primitive) {
                    return ((Primitive)result2).getValue();
                }
                return result2;
            }
            catch (EvalError ex) {
                throw new BshExecutionException(ex);
            }
        }

        private boolean isProxyForSameBshObject(Object other) {
            if (!Proxy.isProxyClass(other.getClass())) {
                return false;
            }
            InvocationHandler ih = Proxy.getInvocationHandler(other);
            return ih instanceof BshObjectInvocationHandler && this.xt.equals(((BshObjectInvocationHandler)ih).xt);
        }
    }
}

