/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.export.assembler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import org.springframework.jmx.export.assembler.AbstractReflectiveMBeanInfoAssembler;
import org.springframework.jmx.export.metadata.JmxMetadataUtils;
import org.springframework.jmx.export.metadata.ManagedNotification;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public abstract class AbstractConfigurableMBeanInfoAssembler
extends AbstractReflectiveMBeanInfoAssembler {
    @Nullable
    private ModelMBeanNotificationInfo[] notificationInfos;
    private final Map<String, ModelMBeanNotificationInfo[]> notificationInfoMappings = new HashMap<String, ModelMBeanNotificationInfo[]>();

    public void setNotificationInfos(ManagedNotification[] notificationInfos) {
        ModelMBeanNotificationInfo[] infos = new ModelMBeanNotificationInfo[notificationInfos.length];
        for (int i = 0; i < notificationInfos.length; ++i) {
            ManagedNotification notificationInfo = notificationInfos[i];
            infos[i] = JmxMetadataUtils.convertToModelMBeanNotificationInfo(notificationInfo);
        }
        this.notificationInfos = infos;
    }

    public void setNotificationInfoMappings(Map<String, Object> notificationInfoMappings) {
        notificationInfoMappings.forEach((beanKey, result2) -> this.notificationInfoMappings.put((String)beanKey, this.extractNotificationMetadata(result2)));
    }

    @Override
    protected ModelMBeanNotificationInfo[] getNotificationInfo(Object managedBean, String beanKey) {
        ModelMBeanNotificationInfo[] result2 = null;
        if (StringUtils.hasText(beanKey)) {
            result2 = this.notificationInfoMappings.get(beanKey);
        }
        if (result2 == null) {
            result2 = this.notificationInfos;
        }
        return result2 != null ? result2 : new ModelMBeanNotificationInfo[]{};
    }

    private ModelMBeanNotificationInfo[] extractNotificationMetadata(Object mapValue) {
        if (mapValue instanceof ManagedNotification) {
            ManagedNotification mn = (ManagedNotification)mapValue;
            return new ModelMBeanNotificationInfo[]{JmxMetadataUtils.convertToModelMBeanNotificationInfo(mn)};
        }
        if (mapValue instanceof Collection) {
            Collection col = (Collection)mapValue;
            ArrayList<ModelMBeanNotificationInfo> result2 = new ArrayList<ModelMBeanNotificationInfo>();
            for (Object colValue : col) {
                if (!(colValue instanceof ManagedNotification)) {
                    throw new IllegalArgumentException("Property 'notificationInfoMappings' only accepts ManagedNotifications for Map values");
                }
                ManagedNotification mn = (ManagedNotification)colValue;
                result2.add(JmxMetadataUtils.convertToModelMBeanNotificationInfo(mn));
            }
            return result2.toArray(new ModelMBeanNotificationInfo[0]);
        }
        throw new IllegalArgumentException("Property 'notificationInfoMappings' only accepts ManagedNotifications for Map values");
    }
}

