/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ParameterMapper;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.object.SqlCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StoredProcedure
extends SqlCall {
    protected StoredProcedure() {
    }

    protected StoredProcedure(DataSource ds, String name) {
        this.setDataSource(ds);
        this.setSql(name);
    }

    protected StoredProcedure(JdbcTemplate jdbcTemplate, String name) {
        this.setJdbcTemplate(jdbcTemplate);
        this.setSql(name);
    }

    @Override
    protected boolean allowsUnusedParameters() {
        return true;
    }

    @Override
    public void declareParameter(SqlParameter param2) throws InvalidDataAccessApiUsageException {
        if (param2.getName() == null) {
            throw new InvalidDataAccessApiUsageException("Parameters to stored procedures must have names as well as types");
        }
        super.declareParameter(param2);
    }

    public Map<String, Object> execute(Object ... inParams) {
        HashMap<String, Object> paramsToUse = new HashMap<String, Object>();
        this.validateParameters(inParams);
        int i = 0;
        for (SqlParameter sqlParameter : this.getDeclaredParameters()) {
            if (!sqlParameter.isInputValueProvided() || i >= inParams.length) continue;
            paramsToUse.put(sqlParameter.getName(), inParams[i++]);
        }
        return this.getJdbcTemplate().call(this.newCallableStatementCreator(paramsToUse), this.getDeclaredParameters());
    }

    public Map<String, Object> execute(Map<String, ?> inParams) throws DataAccessException {
        this.validateParameters(inParams.values().toArray());
        return this.getJdbcTemplate().call(this.newCallableStatementCreator(inParams), this.getDeclaredParameters());
    }

    public Map<String, Object> execute(ParameterMapper inParamMapper) throws DataAccessException {
        this.checkCompiled();
        return this.getJdbcTemplate().call(this.newCallableStatementCreator(inParamMapper), this.getDeclaredParameters());
    }
}

