/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import org.springframework.beans.factory.config.BeanReference;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RuntimeBeanReference
implements BeanReference {
    private final String beanName;
    private final boolean toParent;
    @Nullable
    private Object source;

    public RuntimeBeanReference(String beanName) {
        this(beanName, false);
    }

    public RuntimeBeanReference(String beanName, boolean toParent) {
        Assert.hasText(beanName, "'beanName' must not be empty");
        this.beanName = beanName;
        this.toParent = toParent;
    }

    @Override
    public String getBeanName() {
        return this.beanName;
    }

    public boolean isToParent() {
        return this.toParent;
    }

    public void setSource(@Nullable Object source) {
        this.source = source;
    }

    @Override
    @Nullable
    public Object getSource() {
        return this.source;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RuntimeBeanReference)) {
            return false;
        }
        RuntimeBeanReference that = (RuntimeBeanReference)other;
        return this.beanName.equals(that.beanName) && this.toParent == that.toParent;
    }

    public int hashCode() {
        int result2 = this.beanName.hashCode();
        result2 = 29 * result2 + (this.toParent ? 1 : 0);
        return result2;
    }

    public String toString() {
        return '<' + this.getBeanName() + '>';
    }
}

