/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.factories;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.codegen.ClassDefinition;
import org.eclipse.persistence.internal.codegen.CodeGenerator;
import org.eclipse.persistence.internal.codegen.NonreflectiveMethodDefinition;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.ForeignKeyConstraint;
import org.eclipse.persistence.tools.schemaframework.TableCreator;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class TableCreatorClassGenerator {
    protected String className = "TableCreator";
    protected String packageName = "";
    protected String outputPath = "";
    protected String outputFileName = "TableCreator.java";
    protected Writer outputWriter;
    protected TableCreator tableCreator;

    public TableCreatorClassGenerator() {
    }

    public TableCreatorClassGenerator(TableCreator tableCreator) {
        this();
        this.tableCreator = tableCreator;
    }

    public TableCreatorClassGenerator(TableCreator tableCreator, String projectClassName, Writer outputWriter) {
        this(tableCreator);
        this.outputWriter = outputWriter;
        this.setClassName(projectClassName);
    }

    public TableCreatorClassGenerator(TableCreator tableCreator, String projectClassName, String fileName) {
        this(tableCreator);
        this.setClassName(projectClassName);
        this.setOutputFileName(fileName);
    }

    protected void addFieldLines(FieldDefinition field2, NonreflectiveMethodDefinition method) {
        String fieldName = "field" + field2.getName();
        method.addLine("FieldDefinition " + fieldName + " = new FieldDefinition();");
        method.addLine(String.valueOf(fieldName) + ".setName(\"" + field2.getName() + "\");");
        String fieldTypeName = field2.getTypeName();
        if (fieldTypeName != null) {
            method.addLine(String.valueOf(fieldName) + ".setTypeName(\"" + field2.getTypeName() + "\");");
        } else {
            method.addLine(String.valueOf(fieldName) + ".setType(" + field2.getType().getName() + ".class);");
        }
        method.addLine(String.valueOf(fieldName) + ".setSize(" + field2.getSize() + ");");
        method.addLine(String.valueOf(fieldName) + ".setSubSize(" + field2.getSubSize() + ");");
        method.addLine(String.valueOf(fieldName) + ".setIsPrimaryKey(" + field2.isPrimaryKey() + ");");
        method.addLine(String.valueOf(fieldName) + ".setIsIdentity(" + field2.isIdentity() + ");");
        method.addLine(String.valueOf(fieldName) + ".setUnique(" + field2.isUnique() + ");");
        method.addLine(String.valueOf(fieldName) + ".setShouldAllowNull(" + field2.shouldAllowNull() + ");");
        method.addLine("table.addField(" + fieldName + ");");
    }

    protected void addForeignKeyLines(ForeignKeyConstraint foreignKey, NonreflectiveMethodDefinition method) {
        String foreignKeyName = "foreignKey" + foreignKey.getName();
        method.addLine("ForeignKeyConstraint " + foreignKeyName + " = new ForeignKeyConstraint();");
        method.addLine(String.valueOf(foreignKeyName) + ".setName(\"" + foreignKey.getName() + "\");");
        method.addLine(String.valueOf(foreignKeyName) + ".setTargetTable(\"" + foreignKey.getTargetTable() + "\");");
        for (String sourceField : foreignKey.getSourceFields()) {
            method.addLine(String.valueOf(foreignKeyName) + ".addSourceField(\"" + sourceField + "\");");
        }
        for (String targetField : foreignKey.getTargetFields()) {
            method.addLine(String.valueOf(foreignKeyName) + ".addTargetField(\"" + targetField + "\");");
        }
        method.addLine("table.addForeignKeyConstraint(" + foreignKeyName + ");");
    }

    protected NonreflectiveMethodDefinition buildConstructor() {
        NonreflectiveMethodDefinition methodDefinition = new NonreflectiveMethodDefinition();
        methodDefinition.setName(this.getClassName());
        methodDefinition.setIsConstructor(true);
        methodDefinition.addLine("setName(\"" + this.getTableCreator().getName() + "\");");
        methodDefinition.addLine("");
        for (TableDefinition table : this.getTableCreator().getTableDefinitions()) {
            methodDefinition.addLine("addTableDefinition(build" + table.getName() + "Table());");
        }
        return methodDefinition;
    }

    protected NonreflectiveMethodDefinition buildLoginMethod(DatabaseLogin login) {
        NonreflectiveMethodDefinition method = new NonreflectiveMethodDefinition();
        method.setName("applyLogin");
        String loginClassName = login.getClass().getName();
        if (login.getClass().equals(DatabaseLogin.class)) {
            loginClassName = Helper.getShortClassName(login);
        }
        method.addLine(String.valueOf(loginClassName) + " login = new " + loginClassName + "();");
        method.addLine("login.usePlatform(new " + login.getPlatformClassName() + "());");
        method.addLine("login.setDriverClass(" + login.getDriverClassName() + ".class);");
        method.addLine("login.setConnectionString(\"" + login.getConnectionString() + "\");");
        if (login.getUserName() != null) {
            method.addLine("login.setUserName(\"" + login.getUserName() + "\");");
        }
        if (login.getPassword() != null) {
            method.addLine("login.setPassword(\"" + login.getPassword() + "\");");
        }
        method.addLine("");
        method.addLine("// Configuration properties.");
        method.addLine("login.setUsesNativeSequencing(" + login.shouldUseNativeSequencing() + ");");
        if (!login.shouldUseNativeSequencing()) {
            method.addLine("login.setSequenceTableName(\"" + ((TableSequence)login.getDefaultSequence()).getTableName() + "\");");
            method.addLine("login.setSequenceNameFieldName(\"" + ((TableSequence)login.getDefaultSequence()).getNameFieldName() + "\");");
            method.addLine("login.setSequenceCounterFieldName(\"" + ((TableSequence)login.getDefaultSequence()).getCounterFieldName() + "\");");
        }
        method.addLine("login.setShouldBindAllParameters(" + login.shouldBindAllParameters() + ");");
        method.addLine("login.setShouldCacheAllStatements(" + login.shouldCacheAllStatements() + ");");
        method.addLine("login.setUsesByteArrayBinding(" + login.shouldUseByteArrayBinding() + ");");
        method.addLine("login.setUsesStringBinding(" + login.shouldUseStringBinding() + ");");
        method.addLine("if (login.shouldUseByteArrayBinding()) { // Can only be used with binding.");
        method.addLine("\tlogin.setUsesStreamsForBinding(" + login.shouldUseStreamsForBinding() + ");");
        method.addLine("}");
        method.addLine("login.setShouldForceFieldNamesToUpperCase(" + login.shouldForceFieldNamesToUpperCase() + ");");
        method.addLine("login.setShouldOptimizeDataConversion(" + login.shouldOptimizeDataConversion() + ");");
        method.addLine("login.setShouldTrimStrings(" + login.shouldTrimStrings() + ");");
        method.addLine("login.setUsesBatchWriting(" + login.shouldUseBatchWriting() + ");");
        method.addLine("if (login.shouldUseBatchWriting()) { // Can only be used with batch writing.");
        method.addLine("\tlogin.setUsesJDBCBatchWriting(" + login.shouldUseJDBCBatchWriting() + ");");
        method.addLine("}");
        method.addLine("login.setUsesExternalConnectionPooling(" + login.shouldUseExternalConnectionPooling() + ");");
        method.addLine("login.setUsesExternalTransactionController(" + login.shouldUseExternalTransactionController() + ");");
        method.addLine("setLogin(login);");
        return method;
    }

    protected NonreflectiveMethodDefinition buildTableMethod(TableDefinition table) {
        NonreflectiveMethodDefinition method = new NonreflectiveMethodDefinition();
        method.setName("build" + table.getName() + "Table");
        method.setReturnType("TableDefinition");
        method.addLine("TableDefinition table = new TableDefinition();");
        method.addLine("table.setName(\"" + table.getName() + "\");");
        for (FieldDefinition field2 : table.getFields()) {
            method.addLine("");
            this.addFieldLines(field2, method);
        }
        for (ForeignKeyConstraint foreignKey : table.getForeignKeys()) {
            method.addLine("");
            this.addForeignKeyLines(foreignKey, method);
        }
        method.addLine("");
        method.addLine("return table;");
        return method;
    }

    public void generate(boolean useUnicode) throws ValidationException {
        if (this.getOutputWriter() == null) {
            try {
                this.setOutputWriter(new OutputStreamWriter(new FileOutputStream(String.valueOf(this.getOutputPath()) + this.getOutputFileName())));
            }
            catch (IOException exception) {
                throw ValidationException.fileError(exception);
            }
        }
        CodeGenerator generator = new CodeGenerator(useUnicode);
        generator.setOutput(this.getOutputWriter());
        this.generateCreatorClass().write(generator);
        try {
            this.getOutputWriter().flush();
            this.getOutputWriter().close();
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public void generate() throws ValidationException {
        this.generate(true);
    }

    protected ClassDefinition generateCreatorClass() {
        ClassDefinition classDefinition = new ClassDefinition();
        classDefinition.setName(this.getClassName());
        classDefinition.setSuperClass("org.eclipse.persistence.tools.schemaframework.TableCreator");
        classDefinition.setPackageName(this.getPackageName());
        classDefinition.addImport("org.eclipse.persistence.sessions.*");
        classDefinition.addImport("org.eclipse.persistence.tools.schemaframework.*");
        classDefinition.setComment("This class was generated by the TopLink table creator generator." + Helper.cr() + "It stores the meta-data (tables) that define the database schema." + Helper.cr() + "@see org.eclipse.persistence.sessions.factories.TableCreatorClassGenerator");
        classDefinition.addMethod(this.buildConstructor());
        for (TableDefinition table : this.getTableCreator().getTableDefinitions()) {
            classDefinition.addMethod(this.buildTableMethod(table));
        }
        return classDefinition;
    }

    public String getClassName() {
        return this.className;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public Writer getOutputWriter() {
        return this.outputWriter;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public TableCreator getTableCreator() {
        return this.tableCreator;
    }

    protected String printString(Object value) {
        if (value == null || value == Helper.NULL_VALUE) {
            return "null";
        }
        if (value instanceof String) {
            return "\"" + value + "\"";
        }
        return "new " + Helper.getShortClassName(value) + "(" + value + ")";
    }

    protected String removeDots(String packageName) {
        StringWriter writer = new StringWriter();
        int startIndex = 0;
        int dotIndex = packageName.indexOf(46, startIndex);
        while (dotIndex >= 0) {
            writer.write(packageName.substring(startIndex, dotIndex));
            startIndex = dotIndex + 1;
            dotIndex = packageName.indexOf(46, startIndex);
        }
        writer.write(packageName.substring(startIndex, packageName.length()));
        return writer.toString();
    }

    public void setClassName(String newClassName) {
        int lastDotIndex = newClassName.lastIndexOf(".");
        if (lastDotIndex >= 0) {
            this.className = newClassName.substring(lastDotIndex + 1, newClassName.length());
            this.setPackageName(newClassName.substring(0, lastDotIndex));
        } else {
            this.className = newClassName;
        }
        this.setOutputFileName(newClassName);
    }

    public void setOutputFileName(String newOutputFileName) {
        this.outputFileName = newOutputFileName.indexOf(".java") < 0 ? String.valueOf(newOutputFileName) + ".java" : newOutputFileName;
    }

    public void setOutputPath(String newOutputPath) {
        this.outputPath = newOutputPath;
    }

    public void setOutputWriter(Writer outputWriter) {
        this.outputWriter = outputWriter;
    }

    public void setPackageName(String newPackageName) {
        this.packageName = newPackageName;
    }

    public void setTableCreator(TableCreator tableCreator) {
        this.tableCreator = tableCreator;
    }

    public static void write(TableCreator tableCreator, String creatorClassName, Writer writer) {
        TableCreatorClassGenerator generator = new TableCreatorClassGenerator(tableCreator, creatorClassName, writer);
        generator.generate();
    }

    public static void write(TableCreator tableCreator, String creatorClassName, String fileName) {
        TableCreatorClassGenerator generator = new TableCreatorClassGenerator(tableCreator, creatorClassName, fileName);
        generator.generate();
    }
}

