/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.QueryStringCall;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;

public class SQLCall
extends DatabaseCall
implements QueryStringCall {
    protected boolean hasCustomSQLArguments = false;
    protected transient boolean isTranslatedCustomQuery = false;

    public SQLCall() {
    }

    public SQLCall(String sqlString) {
        this();
        this.setSQLString(sqlString);
    }

    protected void afterTranslateCustomQuery(List updatedParameters, List<Integer> updatedParameterTypes) {
        int size = this.getParameters().size();
        int i = 0;
        while (i < size) {
            DatabaseField field2;
            Integer parameterType = (Integer)this.parameterTypes.get(i);
            Object parameter = this.parameters.get(i);
            if (parameterType == MODIFY || parameterType == OUT || parameterType == OUT_CURSOR || parameterType == IN && parameter instanceof DatabaseField) {
                field2 = this.afterTranslateCustomQueryUpdateParameter((DatabaseField)parameter, i, parameterType, updatedParameters, updatedParameterTypes);
                if (field2 != null) {
                    this.parameters.set(i, field2);
                }
            } else if (parameterType == INOUT) {
                DatabaseField outField = this.afterTranslateCustomQueryUpdateParameter((DatabaseField)((Object[])parameter)[1], i, parameterType, updatedParameters, updatedParameterTypes);
                if (outField != null) {
                    if (((Object[])parameter)[0] instanceof DatabaseField) {
                        if (((Object[])parameter)[0] != ((Object[])parameter)[1]) {
                            DatabaseField inField = outField.clone();
                            inField.setName(((DatabaseField)((Object[])parameter)[0]).getName());
                            ((Object[])parameter)[0] = inField;
                        } else {
                            ((Object[])parameter)[0] = outField;
                        }
                    }
                    ((Object[])parameter)[1] = outField;
                }
            } else if (parameterType == IN && parameter instanceof DatabaseField && (field2 = this.afterTranslateCustomQueryUpdateParameter((DatabaseField)parameter, i, parameterType, updatedParameters, updatedParameterTypes)) != null) {
                this.parameters.set(i, field2);
            }
            ++i;
        }
    }

    protected DatabaseField afterTranslateCustomQueryUpdateParameter(DatabaseField field2, int index, Integer parameterType, List updatedParameters, List<Integer> updatedParameterTypes) {
        int size = updatedParameters.size();
        int j = 0;
        while (j < size) {
            DatabaseField updateField = (DatabaseField)updatedParameters.get(j);
            if (field2.equals(updateField)) {
                Integer updateParameterType = updatedParameterTypes.get(j);
                if (updateParameterType == null) {
                    return updateField;
                }
                if (updateParameterType != OUT_CURSOR) break;
                if (parameterType == OUT) {
                    this.parameterTypes.set(index, OUT_CURSOR);
                    return updateField;
                }
                throw ValidationException.cannotSetCursorForParameterTypeOtherThanOut(field2.getName(), this.toString());
            }
            ++j;
        }
        return null;
    }

    public boolean hasCustomSQLArguments() {
        return this.hasCustomSQLArguments;
    }

    @Override
    public boolean isSQLCall() {
        return true;
    }

    @Override
    public boolean isQueryStringCall() {
        return true;
    }

    @Override
    protected void prepareInternal(AbstractSession session) {
        if (this.hasCustomSQLArguments()) {
            List updatedParameters = null;
            List<Integer> updatedParameterTypes = null;
            if (this.getParameters().size() > 0) {
                updatedParameters = this.getParameters();
                this.setParameters(NonSynchronizedVector.newInstance());
                updatedParameterTypes = this.getParameterTypes();
                this.setParameterTypes(NonSynchronizedVector.newInstance());
            }
            this.translateCustomQuery();
            if (updatedParameters != null) {
                this.afterTranslateCustomQuery(updatedParameters, updatedParameterTypes);
            }
        }
        super.prepareInternal(session);
    }

    public void setHasCustomSQLArguments(boolean hasCustomSQLArguments) {
        this.hasCustomSQLArguments = hasCustomSQLArguments;
    }

    public void setCustomSQLArgumentType(String customParameterName, Class type) {
        DatabaseField field2 = new DatabaseField(customParameterName);
        field2.setType(type);
        this.getParameters().add(field2);
        this.getParameterTypes().add(null);
    }

    public void setCustomSQLArgumentType(String argumentFieldName, int type) {
        DatabaseField field2 = new DatabaseField(argumentFieldName);
        field2.setSqlType(type);
        this.getParameters().add(field2);
        this.getParameterTypes().add(null);
    }

    public void setCustomSQLArgumentType(String argumentFieldName, int type, String typeName) {
        ObjectRelationalDatabaseField field2 = new ObjectRelationalDatabaseField(argumentFieldName);
        field2.setSqlType(type);
        field2.setSqlTypeName(typeName);
        this.getParameters().add(field2);
        this.getParameterTypes().add(null);
    }

    public void setCustomSQLArgumentType(String argumentFieldName, int type, String typeName, Class javaType) {
        ObjectRelationalDatabaseField field2 = new ObjectRelationalDatabaseField(argumentFieldName);
        field2.setSqlType(type);
        field2.setSqlTypeName(typeName);
        field2.setType(javaType);
        this.getParameters().add(field2);
        this.getParameterTypes().add(null);
    }

    public void setCustomSQLArgumentType(String argumentFieldName, int type, String typeName, DatabaseField nestedType) {
        ObjectRelationalDatabaseField field2 = new ObjectRelationalDatabaseField(argumentFieldName);
        field2.setSqlType(type);
        field2.setSqlTypeName(typeName);
        field2.setNestedTypeField(nestedType);
        this.getParameters().add(field2);
        this.getParameterTypes().add(null);
    }

    public void setCustomSQLArgumentType(String argumentFieldName, int type, String typeName, Class javaType, DatabaseField nestedType) {
        ObjectRelationalDatabaseField field2 = new ObjectRelationalDatabaseField(argumentFieldName);
        field2.setSqlType(type);
        field2.setSqlTypeName(typeName);
        field2.setType(javaType);
        field2.setNestedTypeField(nestedType);
        this.getParameters().add(field2);
        this.getParameterTypes().add(null);
    }

    public void setSQLString(String sqlString) {
        this.setSQLStringInternal(sqlString);
    }

    @Override
    public void translateCustomQuery() {
        super.translateCustomQuery();
        this.isTranslatedCustomQuery = true;
    }

    @Override
    public void translatePureSQLCustomQuery() {
        if (this.isTranslatedCustomQuery) {
            return;
        }
        super.translatePureSQLCustomQuery();
        this.isTranslatedCustomQuery = true;
    }

    public void appendTranslationParameter(Writer writer, ParameterExpression expression, DatabasePlatform platform, AbstractRecord record) throws IOException {
        try {
            platform.writeParameterMarker(writer, expression, record, this);
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.getParameters().add(expression);
        this.getParameterTypes().add(TRANSLATION);
    }

    public void useCustomSQLCursorOutputAsResultSet(String customParameterName) {
        DatabaseField field2 = new DatabaseField(customParameterName);
        this.getParameters().add(field2);
        this.getParameterTypes().add(OUT_CURSOR);
        this.setIsCursorOutputProcedure(true);
    }
}

