/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.JavaHasAnnotations;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.javamodel.JavaModel;

public class Helper {
    protected ClassLoader loader;
    protected JavaModel jModel;
    private HashMap xmlToJavaTypeMap = this.buildXMLToJavaTypeMap();
    private boolean facets;
    public static final String APBYTE = "byte[]";
    public static final String BIGDECIMAL = "java.math.BigDecimal";
    public static final String BIGINTEGER = "java.math.BigInteger";
    public static final String PBOOLEAN = "boolean";
    public static final String PBYTE = "byte";
    public static final String CALENDAR = "java.util.Calendar";
    public static final String CHARACTER = "java.lang.Character";
    public static final String CHAR = "char";
    public static final String OBJECT = "java.lang.Object";
    public static final String CLASS = "java.lang.Class";
    public static final String PDOUBLE = "double";
    public static final String PFLOAT = "float";
    public static final String PINT = "int";
    public static final String PLONG = "long";
    public static final String PSHORT = "short";
    public static final String QNAME_CLASS = "javax.xml.namespace.QName";
    public static final String STRING = "java.lang.String";
    public static final String ABYTE = "java.lang.Byte[]";
    public static final String BOOLEAN = "java.lang.Boolean";
    public static final String BYTE = "java.lang.Byte";
    public static final String GREGORIAN_CALENDAR = "java.util.GregorianCalendar";
    public static final String DOUBLE = "java.lang.Double";
    public static final String FLOAT = "java.lang.Float";
    public static final String INTEGER = "java.lang.Integer";
    public static final String UUID = "java.util.UUID";
    public static final String LONG = "java.lang.Long";
    public static final String SHORT = "java.lang.Short";
    public static final String UTIL_DATE = "java.util.Date";
    public static final String SQL_DATE = "java.sql.Date";
    public static final String SQL_TIME = "java.sql.Time";
    public static final String SQL_TIMESTAMP = "java.sql.Timestamp";
    public static final String DURATION = "javax.xml.datatype.Duration";
    public static final String XMLGREGORIANCALENDAR = "javax.xml.datatype.XMLGregorianCalendar";
    public static final String URI = "java.net.URI";
    public static final String URL = "java.net.URL";
    protected static final String JAVA_PKG = "java.";
    protected static final String JAVAX_PKG = "javax.";
    protected static final String JAVAX_WS_PKG = "javax.xml.ws.";
    private static JavaClass COLLECTION_CLASS;
    private static JavaClass SET_CLASS;
    private static JavaClass LIST_CLASS;
    private static JavaClass MAP_CLASS;
    public static JavaClass JAXBELEMENT_CLASS;
    public static JavaClass OBJECT_CLASS;

    public Helper(JavaModel model) {
        this.setJavaModel(model);
        this.setClassLoader(model.getClassLoader());
        COLLECTION_CLASS = this.getJavaClass(CoreClassConstants.Collection_Class);
        LIST_CLASS = this.getJavaClass(CoreClassConstants.List_Class);
        SET_CLASS = this.getJavaClass(CoreClassConstants.Set_Class);
        MAP_CLASS = this.getJavaClass(CoreClassConstants.Map_Class);
        JAXBELEMENT_CLASS = this.getJavaClass(JAXBElement.class);
        OBJECT_CLASS = this.getJavaClass(CoreClassConstants.OBJECT);
    }

    private HashMap buildXMLToJavaTypeMap() {
        HashMap<String, QName> javaTypes = new HashMap<String, QName>();
        javaTypes.put(APBYTE, Constants.BASE_64_BINARY_QNAME);
        javaTypes.put(BIGDECIMAL, Constants.DECIMAL_QNAME);
        javaTypes.put(BIGINTEGER, Constants.INTEGER_QNAME);
        javaTypes.put(PBOOLEAN, Constants.BOOLEAN_QNAME);
        javaTypes.put(PBYTE, Constants.BYTE_QNAME);
        javaTypes.put(CALENDAR, Constants.DATE_TIME_QNAME);
        javaTypes.put(PDOUBLE, Constants.DOUBLE_QNAME);
        javaTypes.put(PFLOAT, Constants.FLOAT_QNAME);
        javaTypes.put(PINT, Constants.INT_QNAME);
        javaTypes.put(PLONG, Constants.LONG_QNAME);
        javaTypes.put(PSHORT, Constants.SHORT_QNAME);
        javaTypes.put(QNAME_CLASS, Constants.QNAME_QNAME);
        javaTypes.put(STRING, Constants.STRING_QNAME);
        javaTypes.put(CHAR, Constants.STRING_QNAME);
        javaTypes.put(CHARACTER, Constants.STRING_QNAME);
        javaTypes.put(ABYTE, Constants.BYTE_QNAME);
        javaTypes.put(BOOLEAN, Constants.BOOLEAN_QNAME);
        javaTypes.put(BYTE, Constants.BYTE_QNAME);
        javaTypes.put(CLASS, Constants.STRING_QNAME);
        javaTypes.put(GREGORIAN_CALENDAR, Constants.DATE_TIME_QNAME);
        javaTypes.put(DOUBLE, Constants.DOUBLE_QNAME);
        javaTypes.put(FLOAT, Constants.FLOAT_QNAME);
        javaTypes.put(INTEGER, Constants.INT_QNAME);
        javaTypes.put(LONG, Constants.LONG_QNAME);
        javaTypes.put(OBJECT, Constants.ANY_TYPE_QNAME);
        javaTypes.put(SHORT, Constants.SHORT_QNAME);
        javaTypes.put(UTIL_DATE, Constants.DATE_TIME_QNAME);
        javaTypes.put(SQL_DATE, Constants.DATE_QNAME);
        javaTypes.put(SQL_TIME, Constants.TIME_QNAME);
        javaTypes.put(SQL_TIMESTAMP, Constants.DATE_TIME_QNAME);
        javaTypes.put(DURATION, Constants.DURATION_QNAME);
        javaTypes.put(UUID, Constants.STRING_QNAME);
        javaTypes.put(URI, Constants.STRING_QNAME);
        javaTypes.put(URL, Constants.ANY_URI_QNAME);
        return javaTypes;
    }

    public JavaClass getGenericReturnType(JavaMethod meth) {
        JavaClass result2 = meth.getReturnType();
        JavaClass jClass = null;
        if (result2 == null) {
            return null;
        }
        Collection args = result2.getActualTypeArguments();
        if (args.size() > 0) {
            jClass = (JavaClass)args.iterator().next();
        }
        return jClass;
    }

    public JavaClass getJavaClass(Class javaClass) {
        return this.jModel.getClass(javaClass);
    }

    public JavaClass[] getJavaClassArray(Class ... classes) {
        if (classes.length == 0) {
            return new JavaClass[0];
        }
        JavaClass[] result2 = new JavaClass[classes.length];
        int i = 0;
        Class[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class clazz = classArray[n2];
            result2[i++] = this.getJavaClass(clazz);
            ++n2;
        }
        return result2;
    }

    public JavaClass getJavaClass(String javaClassName) {
        return this.jModel.getClass(javaClassName);
    }

    public HashMap getXMLToJavaTypeMap() {
        return this.xmlToJavaTypeMap;
    }

    public Annotation getAnnotation(JavaHasAnnotations element, Class annotationClass) {
        JavaAnnotation janno = element.getAnnotation(this.jModel.getClass(annotationClass));
        if (janno == null) {
            return null;
        }
        return this.jModel.getAnnotation(janno, annotationClass);
    }

    public JavaClass getType(JavaField field2) {
        JavaClass type = field2.getResolvedType();
        try {
            return this.jModel.getClass(type.getRawName());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isAnnotationPresent(JavaHasAnnotations element, Class annotationClass) {
        if (element == null || annotationClass == null) {
            return false;
        }
        return element.getAnnotation(this.jModel.getClass(annotationClass)) != null;
    }

    public boolean isBuiltInJavaType(JavaClass jClass) {
        String rawName = jClass.getRawName();
        if (rawName == null) {
            return true;
        }
        return this.getXMLToJavaTypeMap().containsKey(rawName) || rawName.startsWith(JAVA_PKG) || rawName.startsWith(JAVAX_PKG) && !rawName.startsWith(JAVAX_WS_PKG);
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public void setJavaModel(JavaModel model) {
        this.jModel = model;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public Class getClassForJavaClass(JavaClass javaClass) {
        String javaClassName = javaClass.getRawName();
        if (javaClass.isPrimitive() || javaClass.isArray() && javaClass.getComponentType().isPrimitive()) {
            if (CoreClassConstants.APBYTE.getCanonicalName().equals(javaClassName)) {
                return Byte[].class;
            }
            if (CoreClassConstants.PBYTE.getCanonicalName().equals(javaClassName)) {
                return Byte.class;
            }
            if (CoreClassConstants.PBOOLEAN.getCanonicalName().equals(javaClassName)) {
                return Boolean.class;
            }
            if (CoreClassConstants.PSHORT.getCanonicalName().equals(javaClassName)) {
                return Short.class;
            }
            if (CoreClassConstants.PFLOAT.getCanonicalName().equals(javaClassName)) {
                return Float.class;
            }
            if (CoreClassConstants.PCHAR.getCanonicalName().equals(javaClassName)) {
                return Character.class;
            }
            if (CoreClassConstants.PDOUBLE.getCanonicalName().equals(javaClassName)) {
                return Double.class;
            }
            if (CoreClassConstants.PINT.getCanonicalName().equals(javaClassName)) {
                return Integer.class;
            }
            if (CoreClassConstants.PLONG.getCanonicalName().equals(javaClassName)) {
                return Long.class;
            }
            return null;
        }
        return org.eclipse.persistence.internal.helper.Helper.getClassFromClasseName(javaClass.getQualifiedName(), this.loader);
    }

    public boolean classExistsInArray(JavaClass theClass, List<JavaClass> existingClasses) {
        for (JavaClass jClass : existingClasses) {
            if (!this.areClassesEqual(jClass, theClass)) continue;
            return true;
        }
        return false;
    }

    private boolean areClassesEqual(JavaClass classA, JavaClass classB) {
        if (classA == classB) {
            return true;
        }
        if (!classA.getQualifiedName().equals(classB.getQualifiedName())) {
            return false;
        }
        Collection classAargs = classA.getActualTypeArguments();
        Collection classBargs = classB.getActualTypeArguments();
        if (classAargs != null) {
            if (classBargs == null) {
                return false;
            }
            if (classAargs.size() != classBargs.size()) {
                return false;
            }
            Iterator classAargsIter = classAargs.iterator();
            Iterator classBargsIter = classBargs.iterator();
            while (classAargsIter.hasNext()) {
                JavaClass nestedClassB;
                JavaClass nestedClassA = (JavaClass)classAargsIter.next();
                if (this.areClassesEqual(nestedClassA, nestedClassB = (JavaClass)classBargsIter.next())) continue;
                return false;
            }
            return true;
        }
        return classBargs == null;
    }

    public static String getQualifiedJavaTypeName(String javaTypeName, String packageName) {
        if (packageName != null && packageName.length() > 0 && !packageName.equals("##default") && !javaTypeName.contains(".")) {
            return String.valueOf(packageName) + "." + javaTypeName;
        }
        return javaTypeName;
    }

    public boolean isCollectionType(JavaClass type) {
        return COLLECTION_CLASS.isAssignableFrom(type) || LIST_CLASS.isAssignableFrom(type) || SET_CLASS.isAssignableFrom(type);
    }

    public boolean isMapType(JavaClass type) {
        return MAP_CLASS.isAssignableFrom(type);
    }

    public boolean isFacets() {
        return this.facets;
    }

    public void setFacets(boolean facets) {
        this.facets = facets;
    }
}

