/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import java.rmi.server.ObjID;
import java.util.Map;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.indirection.BackupValueHolder;
import org.eclipse.persistence.internal.indirection.BatchValueHolder;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.QueryBasedValueHolder;
import org.eclipse.persistence.internal.indirection.TransformerBasedValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.indirection.WrappingValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.RemoteUnitOfWork;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.remote.DistributedSession;

public class BasicIndirectionPolicy
extends IndirectionPolicy {
    @Override
    public Object backupCloneAttribute(Object attributeValue, Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        ValueHolderInterface valueHolder = (ValueHolderInterface)attributeValue;
        WeavedAttributeValueHolderInterface result2 = null;
        if (!(valueHolder instanceof UnitOfWorkValueHolder) || valueHolder.isInstantiated()) {
            result2 = new ValueHolder();
            result2.setValue(super.backupCloneAttribute(valueHolder.getValue(), clone, backup, unitOfWork));
        } else {
            result2 = new BackupValueHolder(valueHolder);
            ((UnitOfWorkValueHolder)valueHolder).setBackupValueHolder(result2);
        }
        return result2;
    }

    @Override
    public Object buildIndirectObject(ValueHolderInterface valueHolder) {
        return valueHolder;
    }

    @Override
    public Object cloneAttribute(Object attributeValue, Object original, CacheKey cacheKey, Object clone, Integer refreshCascade, AbstractSession cloningSession, boolean buildDirectlyFromRow) {
        WeavedAttributeValueHolderInterface result2;
        ValueHolderInterface valueHolder = (ValueHolderInterface)attributeValue;
        if (!buildDirectlyFromRow && cloningSession.isUnitOfWork() && ((UnitOfWorkImpl)cloningSession).isOriginalNewObject(original)) {
            if (valueHolder instanceof DatabaseValueHolder && !((DatabaseValueHolder)valueHolder).isInstantiated() && ((DatabaseValueHolder)valueHolder).getSession() == null && !((DatabaseValueHolder)valueHolder).isSerializedRemoteUnitOfWorkValueHolder()) {
                throw DescriptorException.attemptToRegisterDeadIndirection(original, this.mapping);
            }
            if (this.mapping.getRelationshipPartner() == null) {
                result2 = new ValueHolder();
                result2.setValue(this.mapping.buildCloneForPartObject(valueHolder.getValue(), original, null, clone, cloningSession, refreshCascade, false, false));
            } else {
                AbstractRecord row = null;
                if (valueHolder instanceof DatabaseValueHolder) {
                    row = ((DatabaseValueHolder)valueHolder).getRow();
                }
                result2 = this.mapping.createCloneValueHolder(valueHolder, original, clone, row, cloningSession, buildDirectlyFromRow);
                Object newObject = this.mapping.buildCloneForPartObject(valueHolder.getValue(), original, cacheKey, clone, cloningSession, refreshCascade, false, false);
                ((UnitOfWorkValueHolder)result2).privilegedSetValue(newObject);
                ((UnitOfWorkValueHolder)result2).setInstantiated();
            }
        } else {
            AbstractRecord row = null;
            if (valueHolder instanceof DatabaseValueHolder) {
                row = ((DatabaseValueHolder)valueHolder).getRow();
            }
            result2 = this.mapping.createCloneValueHolder(valueHolder, original, clone, row, cloningSession, buildDirectlyFromRow);
        }
        return result2;
    }

    @Override
    public Object extractPrimaryKeyForReferenceObject(Object referenceObject, AbstractSession session) {
        if (this.objectIsEasilyInstantiated(referenceObject)) {
            return super.extractPrimaryKeyForReferenceObject(((ValueHolderInterface)referenceObject).getValue(), session);
        }
        return this.getOneToOneMapping().extractPrimaryKeysForReferenceObjectFromRow(this.extractReferenceRow(referenceObject));
    }

    @Override
    public AbstractRecord extractReferenceRow(Object referenceObject) {
        if (this.objectIsInstantiated(referenceObject)) {
            return null;
        }
        return ((DatabaseValueHolder)referenceObject).getRow();
    }

    @Override
    public void fixObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, DistributedSession session) {
        Object attributeValue = this.mapping.getAttributeValueFromObject(object);
        if (attributeValue instanceof RemoteValueHolder) {
            RemoteValueHolder rvh = (RemoteValueHolder)this.mapping.getAttributeValueFromObject(object);
            rvh.setSession(session);
            rvh.setMapping(this.mapping);
            if (!query.shouldMaintainCache() && (!query.shouldCascadeParts() || query.shouldCascadePrivateParts() && !this.mapping.isPrivateOwned())) {
                rvh.setQuery(null);
            } else {
                rvh.setQuery(query);
            }
            rvh.setUninstantiated();
        } else {
            this.mapping.fixRealObjectReferences(object, objectDescriptors, processedObjects, query, session);
        }
    }

    @Override
    public Object getOriginalIndirectionObject(Object unitOfWorkIndirectionObject, AbstractSession session) {
        return this.getOriginalValueHolder(unitOfWorkIndirectionObject, session);
    }

    @Override
    public Object getOriginalIndirectionObjectForMerge(Object unitOfWorkIndirectionObject, AbstractSession session) {
        DatabaseValueHolder holder = (DatabaseValueHolder)this.getOriginalIndirectionObject(unitOfWorkIndirectionObject, session);
        if (holder != null && holder.getSession() != null) {
            holder.setSession(session);
        }
        return holder;
    }

    @Override
    public Object getOriginalValueHolder(Object unitOfWorkIndirectionObject, AbstractSession session) {
        ValueHolderInterface valueHolder;
        if (unitOfWorkIndirectionObject instanceof UnitOfWorkValueHolder && ((UnitOfWorkValueHolder)unitOfWorkIndirectionObject).getRemoteUnitOfWork() != null && (valueHolder = ((UnitOfWorkValueHolder)unitOfWorkIndirectionObject).getWrappedValueHolder()) == null) {
            RemoteUnitOfWork remoteUnitOfWork = (RemoteUnitOfWork)((UnitOfWorkValueHolder)unitOfWorkIndirectionObject).getRemoteUnitOfWork();
            RemoteSessionController controller = remoteUnitOfWork.getParentSessionController();
            ObjID id = ((UnitOfWorkValueHolder)unitOfWorkIndirectionObject).getWrappedValueHolderRemoteID();
            if (id != null) {
                if (controller != null) {
                    valueHolder = controller.getRemoteValueHolders().get(id);
                } else if (session.isRemoteSession()) {
                    valueHolder = new RemoteValueHolder(id);
                    ((RemoteValueHolder)valueHolder).setSession(session);
                }
            }
            if (valueHolder == null) {
                Object object = ((UnitOfWorkValueHolder)unitOfWorkIndirectionObject).getSourceObject();
                AbstractRecord row = this.mapping.getDescriptor().getObjectBuilder().buildRow(object, session, DatabaseMapping.WriteType.UNDEFINED);
                ReadObjectQuery query = new ReadObjectQuery();
                query.setSession(session);
                valueHolder = (ValueHolderInterface)this.mapping.valueFromRow(row, null, query, true);
            }
            return valueHolder;
        }
        if (unitOfWorkIndirectionObject instanceof WrappingValueHolder) {
            valueHolder = ((WrappingValueHolder)unitOfWorkIndirectionObject).getWrappedValueHolder();
            if (!session.isProtectedSession()) {
                while (valueHolder instanceof WrappingValueHolder && ((WrappingValueHolder)((Object)valueHolder)).getWrappedValueHolder() != null) {
                    valueHolder = ((WrappingValueHolder)((Object)valueHolder)).getWrappedValueHolder();
                }
            }
            if (valueHolder != null && valueHolder instanceof DatabaseValueHolder) {
                ((DatabaseValueHolder)valueHolder).releaseWrappedValueHolder(session);
            }
            return valueHolder;
        }
        return unitOfWorkIndirectionObject;
    }

    @Override
    public void reset(Object target) {
        this.mapping.setAttributeValueInObject(target, new ValueHolder());
    }

    @Override
    public Object getRealAttributeValueFromObject(Object object, Object attribute) {
        if (attribute instanceof ValueHolderInterface) {
            return ((ValueHolderInterface)attribute).getValue();
        }
        return attribute;
    }

    @Override
    public Object getValueFromRemoteValueHolder(RemoteValueHolder remoteValueHolder) {
        return remoteValueHolder.getValue();
    }

    @Override
    public boolean isAttributeValueFullyBuilt(Object attributeValue) {
        return attributeValue != null && (!(attributeValue instanceof ValueHolder) || !((ValueHolder)attributeValue).isNewlyWeavedValueHolder());
    }

    @Override
    public void iterateOnAttributeValue(DescriptorIterator iterator, Object attributeValue) {
        iterator.iterateValueHolderForMapping((ValueHolderInterface)attributeValue, this.mapping);
    }

    @Override
    public void mergeRemoteValueHolder(Object clientSideDomainObject, Object serverSideDomainObject, MergeManager mergeManager) {
        RemoteValueHolder serverValueHolder = (RemoteValueHolder)this.mapping.getAttributeValueFromObject(serverSideDomainObject);
        this.mergeClientIntoServerValueHolder(serverValueHolder, mergeManager);
        this.mapping.setAttributeValueInObject(clientSideDomainObject, serverValueHolder);
    }

    @Override
    public Object nullValueFromRow() {
        return new ValueHolder();
    }

    @Override
    public boolean objectIsInstantiated(Object object) {
        return ((ValueHolderInterface)object).isInstantiated();
    }

    @Override
    public boolean objectIsEasilyInstantiated(Object object) {
        if (object instanceof DatabaseValueHolder) {
            return ((DatabaseValueHolder)object).isEasilyInstantiated();
        }
        return true;
    }

    @Override
    public void setRealAttributeValueInObject(Object target, Object attributeValue) {
        ValueHolderInterface holder = (ValueHolderInterface)this.mapping.getAttributeValueFromObject(target);
        if (holder == null) {
            holder = new ValueHolder(attributeValue);
        } else {
            holder.setValue(attributeValue);
        }
        super.setRealAttributeValueInObject(target, holder);
    }

    @Override
    public void setSourceObject(Object sourceObject, Object attributeValue) {
        if (attributeValue instanceof QueryBasedValueHolder) {
            ((QueryBasedValueHolder)attributeValue).setSourceObject(sourceObject);
        }
    }

    protected boolean typeIsValid(Class attributeType) {
        return attributeType == ClassConstants.ValueHolderInterface_Class || attributeType == ClassConstants.WeavedAttributeValueHolderInterface_Class;
    }

    @Override
    public Object validateAttributeOfInstantiatedObject(Object attributeValue) {
        if (attributeValue == null) {
            return new ValueHolder();
        }
        if (!(attributeValue instanceof ValueHolderInterface)) {
            throw DescriptorException.valueHolderInstantiationMismatch(attributeValue, this.mapping);
        }
        return attributeValue;
    }

    @Override
    public void validateDeclaredAttributeType(Class attributeType, IntegrityChecker checker) throws DescriptorException {
        super.validateDeclaredAttributeType(attributeType, checker);
        if (!this.typeIsValid(attributeType)) {
            checker.handleError(DescriptorException.attributeAndMappingWithIndirectionMismatch(this.mapping));
        }
    }

    @Override
    public void validateGetMethodReturnType(Class returnType2, IntegrityChecker checker) throws DescriptorException {
        super.validateGetMethodReturnType(returnType2, checker);
        if (!this.typeIsValid(returnType2)) {
            checker.handleError(DescriptorException.returnAndMappingWithIndirectionMismatch(this.mapping));
        }
    }

    @Override
    public void validateSetMethodParameterType(Class parameterType, IntegrityChecker checker) throws DescriptorException {
        super.validateSetMethodParameterType(parameterType, checker);
        if (!this.typeIsValid(parameterType)) {
            checker.handleError(DescriptorException.parameterAndMappingWithIndirectionMismatch(this.mapping));
        }
    }

    @Override
    public Object valueFromBatchQuery(ReadQuery batchQuery, AbstractRecord row, ObjectLevelReadQuery originalQuery, CacheKey parentCacheKey) {
        return new BatchValueHolder(batchQuery, row, this.getForeignReferenceMapping(), originalQuery, parentCacheKey);
    }

    @Override
    public Object valueFromMethod(Object object, AbstractRecord row, AbstractSession session) {
        return new TransformerBasedValueHolder(this.getTransformationMapping().getAttributeTransformer(), object, row, session);
    }

    @Override
    public Object valueFromQuery(ReadQuery query, AbstractRecord row, Object sourceObject, AbstractSession session) {
        return new QueryBasedValueHolder(query, sourceObject, row, session);
    }

    @Override
    public Object valueFromQuery(ReadQuery query, AbstractRecord row, AbstractSession session) {
        return new QueryBasedValueHolder(query, row, session);
    }

    @Override
    public Object valueFromRow(Object object) {
        return new ValueHolder(object);
    }
}

