/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.trident;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.lang.Validate;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.storm.kafka.trident.mapper.TridentTupleToKafkaMapper;
import org.apache.storm.kafka.trident.selector.KafkaTopicSelector;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.topology.FailedException;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.state.State;
import org.apache.storm.trident.tuple.TridentTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class TridentKafkaState
implements State {
    private static final Logger LOG = LoggerFactory.getLogger(TridentKafkaState.class);
    private KafkaProducer producer;
    private OutputCollector collector;
    private TridentTupleToKafkaMapper mapper;
    private KafkaTopicSelector topicSelector;

    public TridentKafkaState withTridentTupleToKafkaMapper(TridentTupleToKafkaMapper mapper) {
        this.mapper = mapper;
        return this;
    }

    public TridentKafkaState withKafkaTopicSelector(KafkaTopicSelector selector) {
        this.topicSelector = selector;
        return this;
    }

    public void beginCommit(Long txid) {
        LOG.debug("beginCommit is Noop.");
    }

    public void commit(Long txid) {
        LOG.debug("commit is Noop.");
    }

    public void prepare(Properties options) {
        Validate.notNull(this.mapper, "mapper can not be null");
        Validate.notNull(this.topicSelector, "topicSelector can not be null");
        this.producer = new KafkaProducer(options);
    }

    /*
     * WARNING - void declaration
     */
    public void updateState(List<TridentTuple> tuples, TridentCollector collector) {
        String topic = null;
        try {
            ArrayList<Future<RecordMetadata>> futures = new ArrayList<Future<RecordMetadata>>(tuples.size());
            for (TridentTuple tridentTuple : tuples) {
                topic = this.topicSelector.getTopic(tridentTuple);
                if (topic != null) {
                    Future<RecordMetadata> future = this.producer.send(new ProducerRecord(topic, this.mapper.getKeyFromTuple(tridentTuple), this.mapper.getMessageFromTuple(tridentTuple)));
                    futures.add(future);
                    continue;
                }
                LOG.warn("skipping key = " + this.mapper.getKeyFromTuple(tridentTuple) + ", topic selector returned null.");
            }
            ArrayList<ExecutionException> exceptions = new ArrayList<ExecutionException>(futures.size());
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    exceptions.add(e);
                }
            }
            if (exceptions.size() > 0) {
                void var6_11;
                String string = "Could not retrieve result for messages " + tuples + " from topic = " + topic + " because of the following exceptions: \n";
                for (ExecutionException exception : exceptions) {
                    String string2 = (String)var6_11 + exception.getMessage() + "\n";
                }
                LOG.error((String)var6_11);
                throw new FailedException((String)var6_11);
            }
        }
        catch (Exception ex) {
            String errorMsg = "Could not send messages " + tuples + " to topic = " + topic;
            LOG.warn(errorMsg, ex);
            throw new FailedException(errorMsg, (Throwable)ex);
        }
    }
}

