/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.retry.RetryNTimes;
import org.apache.storm.utils.Utils;
import org.apache.zookeeper.CreateMode;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkState {
    private static final Logger LOG = LoggerFactory.getLogger(ZkState.class);
    CuratorFramework _curator;

    private CuratorFramework newCurator(Map stateConf) throws Exception {
        Integer port = (Integer)stateConf.get("transactional.zookeeper.port");
        String serverPorts = "";
        for (String server : (List)stateConf.get("transactional.zookeeper.servers")) {
            serverPorts = serverPorts + server + ":" + port + ",";
        }
        return CuratorFrameworkFactory.newClient(serverPorts, Utils.getInt(stateConf.get("storm.zookeeper.session.timeout")), Utils.getInt(stateConf.get("storm.zookeeper.connection.timeout")), new RetryNTimes(Utils.getInt(stateConf.get("storm.zookeeper.retry.times")), Utils.getInt(stateConf.get("storm.zookeeper.retry.interval"))));
    }

    public CuratorFramework getCurator() {
        assert (this._curator != null);
        return this._curator;
    }

    public ZkState(Map stateConf) {
        stateConf = new HashMap(stateConf);
        try {
            this._curator = this.newCurator(stateConf);
            this._curator.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void writeJSON(String path, Map<Object, Object> data) {
        LOG.debug("Writing {} the data {}", (Object)path, (Object)data.toString());
        this.writeBytes(path, JSONValue.toJSONString(data).getBytes(Charset.forName("UTF-8")));
    }

    public void writeBytes(String path, byte[] bytes) {
        try {
            if (this._curator.checkExists().forPath(path) == null) {
                ((ACLBackgroundPathAndBytesable)this._curator.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(path, bytes);
            } else {
                this._curator.setData().forPath(path, bytes);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map<Object, Object> readJSON(String path) {
        try {
            byte[] b = this.readBytes(path);
            if (b == null) {
                return null;
            }
            return (Map)JSONValue.parseWithException(new String(b, "UTF-8"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] readBytes(String path) {
        try {
            if (this._curator.checkExists().forPath(path) != null) {
                return (byte[])this._curator.getData().forPath(path);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        this._curator.close();
        this._curator = null;
    }
}

