/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$any2stringadd$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Set;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Ordering;
import scala.math.Ordering$String$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;

public final class JmxTool$
implements Logging {
    public static JmxTool$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new JmxTool$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        JmxTool$ jmxTool$ = this;
        synchronized (jmxTool$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec<String> objectNameOpt = parser.accepts("object-name", "A JMX object name to use as a query. This can contain wild cards, and this option can be given multiple times to specify more than one query. If no objects are specified all objects will be queried.").withRequiredArg().describedAs("name").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> attributesOpt = parser.accepts("attributes", "The whitelist of attributes to query. This is a comma-separated list. If no attributes are specified all objects will be queried.").withRequiredArg().describedAs("name").ofType(String.class);
        ArgumentAcceptingOptionSpec<Integer> reportingIntervalOpt = parser.accepts("reporting-interval", "Interval in MS with which to poll jmx stats.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(2000), (Integer[])((Object[])new Integer[0]));
        OptionSpecBuilder helpOpt = parser.accepts("help", "Print usage information.");
        ArgumentAcceptingOptionSpec<String> dateFormatOpt = parser.accepts("date-format", "The date format to use for formatting the time field. See java.text.SimpleDateFormat for options.").withRequiredArg().describedAs("format").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> jmxServiceUrlOpt = parser.accepts("jmx-url", "The url to connect to poll JMX data. See Oracle javadoc for JMXServiceURL for details.").withRequiredArg().describedAs("service-url").ofType(String.class).defaultsTo("service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (String[])((Object[])new String[0]));
        OptionSpecBuilder waitOpt = parser.accepts("wait", "Wait for requested JMX objects to become available before starting output. Only supported when the list of objects is non-empty and contains no object name patterns.");
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Dump JMX values to standard output.");
        }
        OptionSet options = parser.parse(args);
        if (options.has(helpOpt)) {
            parser.printHelpOn(System.out);
            throw Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
        }
        JMXServiceURL url = new JMXServiceURL(options.valueOf(jmxServiceUrlOpt));
        int interval = options.valueOf(reportingIntervalOpt);
        boolean attributesWhitelistExists = options.has(attributesOpt);
        Option attributesWhitelist = attributesWhitelistExists ? new Some<String[]>(options.valueOf(attributesOpt).split(",")) : None$.MODULE$;
        boolean dateFormatExists = options.has(dateFormatOpt);
        Option dateFormat = dateFormatExists ? new Some<SimpleDateFormat>(new SimpleDateFormat(options.valueOf(dateFormatOpt))) : None$.MODULE$;
        boolean wait = options.has(waitOpt);
        JMXConnector jmxc = null;
        ObjectRef<Object> mbsc = ObjectRef.create(null);
        boolean connected = false;
        int connectTimeoutMs = 10000;
        long connectTestStarted = System.currentTimeMillis();
        do {
            try {
                System.err.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to connect to JMX url: ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{url})));
                jmxc = JMXConnectorFactory.connect(url, null);
                mbsc.elem = jmxc.getMBeanServerConnection();
                connected = true;
            }
            catch (Exception e) {
                System.err.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not connect to JMX url: ", ". Exception ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{url, e.getMessage()})));
                e.printStackTrace();
                Thread.sleep(100L);
            }
        } while (System.currentTimeMillis() - connectTestStarted < (long)connectTimeoutMs && !connected);
        if (!connected) {
            System.err.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not connect to JMX url ", " after ", " ms."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{url, BoxesRunTime.boxToInteger(connectTimeoutMs)})));
            System.err.println("Exiting.");
            throw scala.sys.package$.MODULE$.exit(1);
        }
        GenTraversable queries = options.has(objectNameOpt) ? (Iterable)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(options.valuesOf(objectNameOpt)).asScala()).map((Function1<String, ObjectName> & Serializable & scala.Serializable)x$1 -> new ObjectName((String)x$1), Buffer$.MODULE$.canBuildFrom()) : List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray(new Null$[]{null}));
        boolean hasPatternQueries = queries.exists((Function1<ObjectName, Object> & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean(name.isPattern()));
        ObjectRef<Object> names = ObjectRef.create(null);
        int waitTimeoutMs = 10000;
        if (!hasPatternQueries) {
            long start = System.currentTimeMillis();
            do {
                if ((Iterable)names.elem != null) {
                    System.err.println("Could not find all object names, retrying");
                    Thread.sleep(100L);
                }
                names.elem = queries.flatMap((Function1<ObjectName, Set> & Serializable & scala.Serializable)name -> JavaConverters$.MODULE$.asScalaSetConverter(((MBeanServerConnection)mbsc$1.elem).queryNames((ObjectName)name, null)).asScala(), Iterable$.MODULE$.canBuildFrom());
            } while (wait && System.currentTimeMillis() - start < (long)waitTimeoutMs && !JmxTool$.foundAllObjects$1((Iterable)queries, names));
        }
        if (wait && !JmxTool$.foundAllObjects$1((Iterable)queries, names)) {
            String missing = queries.toSet().$minus(JmxTool$.namesSet$1(names)).mkString(", ");
            System.err.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find all requested object names after ", " ms. Missing ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(waitTimeoutMs), missing})));
            System.err.println("Exiting.");
            throw scala.sys.package$.MODULE$.exit(1);
        }
        Map numExpectedAttributes = attributesWhitelistExists ? ((TraversableOnce)queries.map((Function1<ObjectName, Tuple2> & Serializable & scala.Serializable)x$2 -> new Tuple2<ObjectName, Integer>((ObjectName)x$2, BoxesRunTime.boxToInteger(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])attributesWhitelist.get())).size())), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()) : ((TraversableOnce)((Iterable)names.elem).map((Function1<ObjectName, Tuple2> & Serializable & scala.Serializable)name -> {
            MBeanInfo mbean = ((MBeanServerConnection)mbsc$1.elem).getMBeanInfo((ObjectName)name);
            return new Tuple2<ObjectName, Integer>((ObjectName)name, BoxesRunTime.boxToInteger(((MBeanServerConnection)mbsc$1.elem).getAttributes((ObjectName)name, (String[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])mbean.getAttributes())).map((Function1<MBeanAttributeInfo, String> & Serializable & scala.Serializable)x$3 -> x$3.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).size()));
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        List<?> keys = ((List)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"time"}))).$plus$plus(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])this.queryAttributes((MBeanServerConnection)mbsc.elem, (Iterable)names.elem, attributesWhitelist).keys().toArray(ClassTag$.MODULE$.apply(String.class)))).sorted((Ordering)Ordering$String$.MODULE$))), List$.MODULE$.canBuildFrom());
        if (keys.size() == BoxesRunTime.unboxToInt(numExpectedAttributes.values().sum(Numeric$IntIsIntegral$.MODULE$)) + 1) {
            Predef$.MODULE$.println(((TraversableOnce)keys.map((Function1<String, String> & Serializable & scala.Serializable)x$4 -> "\"" + x$4 + "\"", List$.MODULE$.canBuildFrom())).mkString(","));
        }
        while (true) {
            String string;
            long start = System.currentTimeMillis();
            HashMap<String, Object> attributes = this.queryAttributes((MBeanServerConnection)mbsc.elem, (Iterable)names.elem, attributesWhitelist);
            Option option = dateFormat;
            if (option instanceof Some) {
                Some some = (Some)option;
                SimpleDateFormat dFormat = (SimpleDateFormat)some.value();
                string = dFormat.format(new Date());
            } else if (None$.MODULE$.equals(option)) {
                string = ((Object)BoxesRunTime.boxToLong(System.currentTimeMillis())).toString();
            } else {
                throw new MatchError(option);
            }
            attributes.update("time", string);
            if (attributes.keySet().size() == BoxesRunTime.unboxToInt(numExpectedAttributes.values().sum(Numeric$IntIsIntegral$.MODULE$)) + 1) {
                Predef$.MODULE$.println(((TraversableOnce)keys.map((Function1<String, Object> & Serializable & scala.Serializable)x$5 -> attributes.apply((String)x$5), List$.MODULE$.canBuildFrom())).mkString(","));
            }
            long sleep = package$.MODULE$.max(0L, (long)interval - (System.currentTimeMillis() - start));
            Thread.sleep(sleep);
        }
    }

    public HashMap<String, Object> queryAttributes(MBeanServerConnection mbsc, Iterable<ObjectName> names, Option<String[]> attributesWhitelist) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        names.foreach((Function1<ObjectName, Object> & Serializable & scala.Serializable)name -> {
            JmxTool$.$anonfun$queryAttributes$1(mbsc, attributesWhitelist, attributes, name);
            return BoxedUnit.UNIT;
        });
        return attributes;
    }

    private static final scala.collection.immutable.Set namesSet$1(ObjectRef names$1) {
        return (scala.collection.immutable.Set)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Iterable)names$1.elem)).toSet().flatten(Predef$.MODULE$.$conforms());
    }

    private static final boolean foundAllObjects$1(Iterable queries$1, ObjectRef names$1) {
        scala.collection.immutable.Set set = queries$1.toSet();
        scala.collection.immutable.Set set2 = JmxTool$.namesSet$1(names$1);
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ void $anonfun$queryAttributes$3(Option attributesWhitelist$2, HashMap attributes$1, ObjectName name$1, Object attrObj) {
        Attribute attr = (Attribute)attrObj;
        Option option = attributesWhitelist$2;
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            String[] allowedAttributes = (String[])some.value();
            if (new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])allowedAttributes)).contains(attr.getName())) {
                attributes$1.update(Predef$any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(name$1), ":") + attr.getName(), attr.getValue());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            attributes$1.update(Predef$any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(name$1), ":") + attr.getName(), attr.getValue());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public static final /* synthetic */ void $anonfun$queryAttributes$1(MBeanServerConnection mbsc$2, Option attributesWhitelist$2, HashMap attributes$1, ObjectName name) {
        MBeanInfo mbean = mbsc$2.getMBeanInfo(name);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(mbsc$2.getAttributes(name, (String[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])mbean.getAttributes())).map((Function1<MBeanAttributeInfo, String> & Serializable & scala.Serializable)x$6 -> x$6.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).asScala()).foreach((Function1<Object, Object> & Serializable & scala.Serializable)attrObj -> {
            JmxTool$.$anonfun$queryAttributes$3(attributesWhitelist$2, attributes$1, name, attrObj);
            return BoxedUnit.UNIT;
        });
    }

    private JmxTool$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

