/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.log.AbortedTxn;
import kafka.log.BatchMetadata;
import kafka.log.CorruptSnapshotException;
import kafka.log.Log$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateManager$;
import kafka.log.TimeIndex;
import kafka.log.TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.log.TransactionIndex;
import kafka.serializer.Decoder;
import kafka.tools.DumpLogSegments;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.Record;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple2$mcJJ$sp;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.NonLocalReturnControl$mcV$sp;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1$mcVI$sp;

public final class DumpLogSegments$ {
    public static DumpLogSegments$ MODULE$;

    static {
        new DumpLogSegments$();
    }

    public void main(String[] args) {
        DumpLogSegments.MessageParser<String, String> messageParser;
        boolean isDeepIteration;
        OptionParser parser = new OptionParser(false);
        OptionSpecBuilder printOpt = parser.accepts("print-data-log", "if set, printing the messages content when dumping data logs. Automatically set if any decoder option is specified.");
        OptionSpecBuilder verifyOpt = parser.accepts("verify-index-only", "if set, just verify the index log without printing its content.");
        OptionSpecBuilder indexSanityOpt = parser.accepts("index-sanity-check", "if set, just checks the index sanity without printing its content. This is the same check that is executed on broker startup to determine if an index needs rebuilding or not.");
        ArgumentAcceptingOptionSpec<String> filesOpt = parser.accepts("files", "REQUIRED: The comma separated list of data and index log files to be dumped.").withRequiredArg().describedAs("file1, file2, ...").ofType(String.class);
        ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt = parser.accepts("max-message-size", "Size of largest message.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(0x500000), (Integer[])((Object[])new Integer[0]));
        OptionSpecBuilder deepIterationOpt = parser.accepts("deep-iteration", "if set, uses deep instead of shallow iteration. Automatically set if print-data-log is enabled.");
        ArgumentAcceptingOptionSpec<String> valueDecoderOpt = parser.accepts("value-decoder-class", "if set, used to deserialize the messages. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo("kafka.serializer.StringDecoder", (String[])((Object[])new String[0]));
        ArgumentAcceptingOptionSpec<String> keyDecoderOpt = parser.accepts("key-decoder-class", "if set, used to deserialize the keys. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo("kafka.serializer.StringDecoder", (String[])((Object[])new String[0]));
        OptionSpecBuilder offsetsOpt = parser.accepts("offsets-decoder", "if set, log data will be parsed as offset data from the __consumer_offsets topic.");
        OptionSpecBuilder transactionLogOpt = parser.accepts("transaction-log-decoder", "if set, log data will be parsed as transaction metadata from the __transaction_state topic.");
        OptionSpecBuilder helpOpt = parser.accepts("help", "Print usage information.");
        OptionSet options = parser.parse(args);
        if (args.length == 0 || options.has(helpOpt)) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Parse a log file and dump its contents to the console, useful for debugging a seemingly corrupt log segment.");
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{filesOpt}));
        boolean printDataLog = options.has(printOpt) || options.has(offsetsOpt) || options.has(transactionLogOpt) || options.has(valueDecoderOpt) || options.has(keyDecoderOpt);
        boolean verifyOnly = options.has(verifyOpt);
        boolean indexSanityOnly = options.has(indexSanityOpt);
        String[] files2 = options.valueOf(filesOpt).split(",");
        int maxMessageSize = options.valueOf(maxMessageSizeOpt);
        boolean bl = isDeepIteration = options.has(deepIterationOpt) || printDataLog;
        if (options.has(offsetsOpt)) {
            messageParser = new DumpLogSegments.OffsetsMessageParser();
        } else if (options.has(transactionLogOpt)) {
            messageParser = new DumpLogSegments.TransactionLogMessageParser();
        } else {
            Decoder valueDecoder = (Decoder)CoreUtils$.MODULE$.createObject(options.valueOf(valueDecoderOpt), Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
            Decoder keyDecoder = (Decoder)CoreUtils$.MODULE$.createObject(options.valueOf(keyDecoderOpt), Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
            messageParser = new DumpLogSegments.DecoderMessageParser(keyDecoder, valueDecoder);
        }
        DumpLogSegments.OffsetsMessageParser messageParser2 = messageParser;
        HashMap misMatchesForIndexFilesMap = new HashMap();
        DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors = new DumpLogSegments.TimeIndexDumpErrors();
        HashMap nonConsecutivePairsForLogFilesMap = new HashMap();
        new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])files2)).foreach((Function1<String, Object> & Serializable & scala.Serializable)arg -> {
            DumpLogSegments$.$anonfun$main$1(printDataLog, verifyOnly, indexSanityOnly, maxMessageSize, isDeepIteration, messageParser2, misMatchesForIndexFilesMap, timeIndexDumpErrors, nonConsecutivePairsForLogFilesMap, arg);
            return BoxedUnit.UNIT;
        });
        misMatchesForIndexFilesMap.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> {
            DumpLogSegments$.$anonfun$main$2(x0$1);
            return BoxedUnit.UNIT;
        });
        timeIndexDumpErrors.printErrors();
        nonConsecutivePairsForLogFilesMap.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$2 -> {
            DumpLogSegments$.$anonfun$main$4(x0$2);
            return BoxedUnit.UNIT;
        });
    }

    private void dumpTxnIndex(File file) {
        TransactionIndex index = new TransactionIndex(Log$.MODULE$.offsetFromFile(file), file);
        index.allAbortedTxns().foreach((Function1<AbortedTxn, Object> & Serializable & scala.Serializable)abortedTxn -> {
            Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"version: ", " producerId: ", " firstOffset: ", " "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToShort(abortedTxn.version()), BoxesRunTime.boxToLong(abortedTxn.producerId()), BoxesRunTime.boxToLong(abortedTxn.firstOffset())})) + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lastOffset: ", " lastStableOffset: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(abortedTxn.lastOffset()), BoxesRunTime.boxToLong(abortedTxn.lastStableOffset())})));
            return BoxedUnit.UNIT;
        });
    }

    private void dumpProducerIdSnapshot(File file) {
        try {
            ProducerStateManager$.MODULE$.readSnapshot(file).foreach((Function1<ProducerStateEntry, Object> & Serializable & scala.Serializable)entry -> {
                DumpLogSegments$.$anonfun$dumpProducerIdSnapshot$1(entry);
                return BoxedUnit.UNIT;
            });
        }
        catch (CorruptSnapshotException e) {
            System.err.println(e.getMessage());
        }
    }

    private void dumpIndex(File file, boolean indexSanityOnly, boolean verifyOnly, HashMap<String, List<Tuple2<Object, Object>>> misMatchesForIndexFilesMap, int maxMessageSize) {
        Object object = new Object();
        try {
            long startOffset = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
            File logFile = new File(file.getAbsoluteFile().getParent(), file.getName().split("\\.")[0] + Log$.MODULE$.LogFileSuffix());
            FileRecords fileRecords = FileRecords.open(logFile, false);
            File x$4 = file;
            long x$5 = startOffset;
            boolean x$6 = false;
            int x$7 = OffsetIndex$.MODULE$.$lessinit$greater$default$3();
            OffsetIndex index = new OffsetIndex(x$4, x$5, x$7, x$6);
            if (indexSanityOnly) {
                index.sanityCheck();
                Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " passed sanity check."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{file})));
                return;
            }
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), index.entries()).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)i -> {
                block3: {
                    Serializable serializable;
                    OffsetPosition entry = index.entry(i);
                    FileRecords slice = fileRecords.read(entry.position(), maxMessageSize);
                    Record firstRecord = slice.records().iterator().next();
                    if (firstRecord.offset() != entry.offset() + index.baseOffset()) {
                        List<Tuple2$mcJJ$sp> misMatchesSeq = (List<Tuple2$mcJJ$sp>)misMatchesForIndexFilesMap.getOrElse(file.getAbsolutePath(), (Function0<List> & Serializable & scala.Serializable)() -> Nil$.MODULE$);
                        misMatchesSeq = misMatchesSeq.$colon$colon(new Tuple2$mcJJ$sp(entry.offset() + index.baseOffset(), firstRecord.offset()));
                        serializable = misMatchesForIndexFilesMap.put(file.getAbsolutePath(), misMatchesSeq);
                    } else {
                        serializable = BoxedUnit.UNIT;
                    }
                    if (entry.offset() == 0L && i > 0) {
                        throw new NonLocalReturnControl$mcV$sp(object, BoxedUnit.UNIT);
                    }
                    if (verifyOnly) break block3;
                    Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("offset: %d position: %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(entry.offset() + index.baseOffset()), BoxesRunTime.boxToInteger(entry.position())})));
                }
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void dumpTimeIndex(File file, boolean indexSanityOnly, boolean verifyOnly, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors, int maxMessageSize) {
        Object object = new Object();
        try {
            File indexFile;
            long startOffset = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
            File logFile = new File(file.getAbsoluteFile().getParent(), file.getName().split("\\.")[0] + Log$.MODULE$.LogFileSuffix());
            FileRecords fileRecords = FileRecords.open(logFile, false);
            File x$8 = indexFile = new File(file.getAbsoluteFile().getParent(), file.getName().split("\\.")[0] + Log$.MODULE$.IndexFileSuffix());
            long x$9 = startOffset;
            boolean x$10 = false;
            int x$11 = OffsetIndex$.MODULE$.$lessinit$greater$default$3();
            OffsetIndex index = new OffsetIndex(x$8, x$9, x$11, x$10);
            File x$12 = file;
            long x$13 = startOffset;
            boolean x$14 = false;
            int x$15 = TimeIndex$.MODULE$.$lessinit$greater$default$3();
            TimeIndex timeIndex = new TimeIndex(x$12, x$13, x$15, x$14);
            if (indexSanityOnly) {
                timeIndex.sanityCheck();
                Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " passed sanity check."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{file})));
                return;
            }
            LongRef prevTimestamp = LongRef.create(-1L);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), timeIndex.entries()).foreach$mVc$sp(arg_0 -> DumpLogSegments$.$anonfun$dumpTimeIndex$1(file, verifyOnly, timeIndexDumpErrors, fileRecords, index, timeIndex, prevTimestamp, object, arg_0));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void dumpLog(File file, boolean printContents, HashMap<String, List<Tuple2<Object, Object>>> nonConsecutivePairsForLogFilesMap, boolean isDeepIteration, int maxMessageSize, DumpLogSegments.MessageParser<?, ?> parser) {
        block0: {
            long startOffset = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
            Predef$.MODULE$.println("Starting offset: " + startOffset);
            FileRecords messageSet = FileRecords.open(file, false);
            LongRef validBytes = LongRef.create(0L);
            LongRef lastOffset = LongRef.create(-1L);
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(messageSet.batches()).asScala()).foreach((Function1<FileLogInputStream.FileChannelRecordBatch, Object> & Serializable & scala.Serializable)batch -> {
                DumpLogSegments$.$anonfun$dumpLog$1(file, printContents, nonConsecutivePairsForLogFilesMap, isDeepIteration, parser, validBytes, lastOffset, batch);
                return BoxedUnit.UNIT;
            });
            long trailingBytes = (long)messageSet.sizeInBytes() - validBytes.elem;
            if (trailingBytes <= 0L) break block0;
            Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Found %d invalid bytes at the end of %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(trailingBytes), file.getName()})));
        }
    }

    public static final /* synthetic */ void $anonfun$main$1(boolean printDataLog$1, boolean verifyOnly$1, boolean indexSanityOnly$1, int maxMessageSize$1, boolean isDeepIteration$1, DumpLogSegments.MessageParser messageParser$1, HashMap misMatchesForIndexFilesMap$1, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors$1, HashMap nonConsecutivePairsForLogFilesMap$1, String arg) {
        String suffix;
        File file = new File(arg);
        Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dumping ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{file})));
        String filename = file.getName();
        String string = suffix = filename.substring(filename.lastIndexOf("."));
        String string2 = Log$.MODULE$.LogFileSuffix();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            MODULE$.dumpLog(file, printDataLog$1, nonConsecutivePairsForLogFilesMap$1, isDeepIteration$1, maxMessageSize$1, messageParser$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String string4 = Log$.MODULE$.IndexFileSuffix();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                MODULE$.dumpIndex(file, indexSanityOnly$1, verifyOnly$1, misMatchesForIndexFilesMap$1, maxMessageSize$1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                String string6 = Log$.MODULE$.TimeIndexFileSuffix();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    MODULE$.dumpTimeIndex(file, indexSanityOnly$1, verifyOnly$1, timeIndexDumpErrors$1, maxMessageSize$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    String string8 = Log$.MODULE$.ProducerSnapshotFileSuffix();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        MODULE$.dumpProducerIdSnapshot(file);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        String string10 = Log$.MODULE$.TxnIndexFileSuffix();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            MODULE$.dumpTxnIndex(file);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            System.err.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignoring unknown file ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{file})));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                }
            }
        }
    }

    public static final /* synthetic */ void $anonfun$main$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String fileName = (String)tuple2._1();
        List listOfMismatches = (List)tuple2._2();
        System.err.println("Mismatches in :" + fileName);
        listOfMismatches.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)m -> {
            System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index offset: %d, log offset: %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(m._1$mcJ$sp()), BoxesRunTime.boxToLong(m._2$mcJ$sp())})));
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$main$4(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String fileName = (String)tuple2._1();
        List listOfNonConsecutivePairs = (List)tuple2._2();
        System.err.println("Non-consecutive offsets in :" + fileName);
        listOfNonConsecutivePairs.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)m -> {
            System.err.println(new StringOps(Predef$.MODULE$.augmentString("  %d is followed by %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(m._1$mcJ$sp()), BoxesRunTime.boxToLong(m._2$mcJ$sp())})));
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$dumpProducerIdSnapshot$1(ProducerStateEntry entry) {
        Predef$.MODULE$.print(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerId: ", " producerEpoch: ", " "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(entry.producerId()), BoxesRunTime.boxToShort(entry.producerEpoch())})) + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coordinatorEpoch: ", " currentTxnFirstOffset: ", " "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(entry.coordinatorEpoch()), entry.currentTxnFirstOffset()})));
        entry.batchMetadata().headOption().foreach((Function1<BatchMetadata, Object> & Serializable & scala.Serializable)metadata -> {
            Predef$.MODULE$.print(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"firstSequence: ", " lastSequence: ", " "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(metadata.firstSeq()), BoxesRunTime.boxToInteger(metadata.lastSeq())})) + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lastOffset: ", " offsetDelta: ", " timestamp: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(metadata.lastOffset()), BoxesRunTime.boxToInteger(metadata.offsetDelta()), BoxesRunTime.boxToLong(metadata.timestamp())})));
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println();
    }

    public static final /* synthetic */ boolean $anonfun$dumpTimeIndex$2(TimeIndex timeIndex$1, TimestampOffset entry$1, FileLogInputStream.FileChannelRecordBatch x$1) {
        return x$1.lastOffset() >= entry$1.offset() + timeIndex$1.baseOffset();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$dumpTimeIndex$1(File file$3, boolean verifyOnly$3, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors$2, FileRecords fileRecords$2, OffsetIndex index$2, TimeIndex timeIndex$1, LongRef prevTimestamp$1, Object nonLocalReturnKey2$1, int i) {
        block9: {
            block8: {
                entry = timeIndex$1.entry(i);
                position = index$2.lookup(entry.offset() + timeIndex$1.baseOffset()).position();
                partialFileRecords = fileRecords$2.read(position, 0x7FFFFFFF);
                batches = JavaConverters$.MODULE$.iterableAsScalaIterableConverter(partialFileRecords.batches()).asScala();
                maxTimestamp = LongRef.create(-1L);
                var15_14 = false;
                var16_15 = null;
                var17_16 = batches.find((Function1<FileLogInputStream.FileChannelRecordBatch, Object> & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$dumpTimeIndex$2$adapted(kafka.log.TimeIndex kafka.log.TimestampOffset org.apache.kafka.common.record.FileLogInputStream$FileChannelRecordBatch ), (Lorg/apache/kafka/common/record/FileLogInputStream$FileChannelRecordBatch;)Ljava/lang/Object;)((TimeIndex)timeIndex$1, (TimestampOffset)entry));
                if (!None$.MODULE$.equals(var17_16)) break block8;
                timeIndexDumpErrors$2.recordShallowOffsetNotFound(file$3, entry.offset() + timeIndex$1.baseOffset(), -1);
                var9_17 = BoxedUnit.UNIT;
                break block9;
            }
            if (!(var17_16 instanceof Some)) ** GOTO lbl-1000
            var15_14 = true;
            var16_15 = (Some)var17_16;
            batch = (FileLogInputStream.FileChannelRecordBatch)var16_15.value();
            if (batch.lastOffset() != entry.offset() + timeIndex$1.baseOffset()) {
                timeIndexDumpErrors$2.recordShallowOffsetNotFound(file$3, entry.offset() + timeIndex$1.baseOffset(), batch.lastOffset());
                var9_18 = BoxedUnit.UNIT;
            } else if (var15_14) {
                batch = (FileLogInputStream.FileChannelRecordBatch)var16_15.value();
                ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(batch).asScala()).foreach((Function1<Record, Object> & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$dumpTimeIndex$3$adapted(scala.runtime.LongRef org.apache.kafka.common.record.Record ), (Lorg/apache/kafka/common/record/Record;)Ljava/lang/Object;)((LongRef)maxTimestamp));
                if (maxTimestamp.elem != entry.timestamp()) {
                    timeIndexDumpErrors$2.recordMismatchTimeIndex(file$3, entry.timestamp(), maxTimestamp.elem);
                }
                if (prevTimestamp$1.elem >= entry.timestamp()) {
                    timeIndexDumpErrors$2.recordOutOfOrderIndexTimestamp(file$3, entry.timestamp(), prevTimestamp$1.elem);
                }
                if (entry.offset() == 0L && i > 0) {
                    throw new NonLocalReturnControl$mcV$sp(nonLocalReturnKey2$1, BoxedUnit.UNIT);
                }
                var9_19 = BoxedUnit.UNIT;
            } else {
                throw new MatchError(var17_16);
            }
        }
        if (!verifyOnly$3) {
            Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("timestamp: %s offset: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(entry.timestamp()), BoxesRunTime.boxToLong(timeIndex$1.baseOffset() + entry.offset())})));
        }
        prevTimestamp$1.elem = entry.timestamp();
    }

    public static final /* synthetic */ void $anonfun$dumpLog$2(File file$1, boolean printContents$1, HashMap nonConsecutivePairsForLogFilesMap$2, DumpLogSegments.MessageParser parser$1, LongRef validBytes$1, LongRef lastOffset$1, FileLogInputStream.FileChannelRecordBatch batch$1, Record record) {
        Serializable serializable;
        if (lastOffset$1.elem == -1L) {
            lastOffset$1.elem = record.offset();
            serializable = BoxedUnit.UNIT;
        } else if (record.offset() != lastOffset$1.elem + 1L) {
            List<Tuple2$mcJJ$sp> nonConsecutivePairsSeq = (List<Tuple2$mcJJ$sp>)nonConsecutivePairsForLogFilesMap$2.getOrElse(file$1.getAbsolutePath(), (Function0<List> & Serializable & scala.Serializable)() -> Nil$.MODULE$);
            nonConsecutivePairsSeq = nonConsecutivePairsSeq.$colon$colon(new Tuple2$mcJJ$sp(lastOffset$1.elem, record.offset()));
            serializable = nonConsecutivePairsForLogFilesMap$2.put(file$1.getAbsolutePath(), nonConsecutivePairsSeq);
        } else {
            serializable = BoxedUnit.UNIT;
        }
        lastOffset$1.elem = record.offset();
        Predef$.MODULE$.print("offset: " + record.offset() + " position: " + validBytes$1.elem + " " + (Object)((Object)batch$1.timestampType()) + ": " + record.timestamp() + " isvalid: " + record.isValid() + " keysize: " + record.keySize() + " valuesize: " + record.valueSize() + " magic: " + batch$1.magic() + " compresscodec: " + (Object)((Object)batch$1.compressionType()));
        if (batch$1.magic() >= 2) {
            Predef$.MODULE$.print(" producerId: " + batch$1.producerId() + " producerEpoch: " + batch$1.producerEpoch() + " sequence: " + record.sequence() + " isTransactional: " + batch$1.isTransactional() + " headerKeys: " + new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])record.headers())).map((Function1<Header, String> & Serializable & scala.Serializable)x$2 -> x$2.key(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("[", ",", "]"));
        } else {
            Predef$.MODULE$.print(" crc: " + record.checksumOrNull());
        }
        if (batch$1.isControlBatch()) {
            short controlTypeId = ControlRecordType.parseTypeId(record.key());
            ControlRecordType controlRecordType = ControlRecordType.fromTypeId(controlTypeId);
            boolean bl = ((Object)((Object)ControlRecordType.ABORT)).equals((Object)controlRecordType) ? true : ((Object)((Object)ControlRecordType.COMMIT)).equals((Object)controlRecordType);
            if (bl) {
                EndTransactionMarker endTxnMarker = EndTransactionMarker.deserialize(record);
                Predef$.MODULE$.print(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{" endTxnMarker: ", " coordinatorEpoch: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{endTxnMarker.controlType(), BoxesRunTime.boxToInteger(endTxnMarker.coordinatorEpoch())})));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Predef$.MODULE$.print(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{" controlType: ", "(", ")"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{controlRecordType, BoxesRunTime.boxToShort(controlTypeId)})));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        } else if (printContents$1) {
            Tuple2 tuple2 = parser$1.parse(record);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option key2 = tuple2._1();
            Option payload2 = tuple2._2();
            Tuple2 tuple22 = new Tuple2(key2, payload2);
            Tuple2 tuple23 = tuple22;
            Option key3 = tuple23._1();
            Option payload3 = tuple23._2();
            key3.foreach((Function1<Object, Object> & Serializable & scala.Serializable)key -> {
                Predef$.MODULE$.print(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{" key: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{key})));
                return BoxedUnit.UNIT;
            });
            payload3.foreach((Function1<Object, Object> & Serializable & scala.Serializable)payload -> {
                Predef$.MODULE$.print(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{" payload: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{payload})));
                return BoxedUnit.UNIT;
            });
        }
        Predef$.MODULE$.println();
    }

    public static final /* synthetic */ void $anonfun$dumpLog$1(File file$1, boolean printContents$1, HashMap nonConsecutivePairsForLogFilesMap$2, boolean isDeepIteration$2, DumpLogSegments.MessageParser parser$1, LongRef validBytes$1, LongRef lastOffset$1, FileLogInputStream.FileChannelRecordBatch batch) {
        if (isDeepIteration$2) {
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(batch).asScala()).foreach((Function1<Record, Object> & Serializable & scala.Serializable)record -> {
                DumpLogSegments$.$anonfun$dumpLog$2(file$1, printContents$1, nonConsecutivePairsForLogFilesMap$2, parser$1, validBytes$1, lastOffset$1, batch, record);
                return BoxedUnit.UNIT;
            });
        } else {
            if (batch.magic() >= 2) {
                Predef$.MODULE$.print("baseOffset: " + batch.baseOffset() + " lastOffset: " + batch.lastOffset() + " baseSequence: " + batch.baseSequence() + " lastSequence: " + batch.lastSequence() + " producerId: " + batch.producerId() + " producerEpoch: " + batch.producerEpoch() + " partitionLeaderEpoch: " + batch.partitionLeaderEpoch() + " isTransactional: " + batch.isTransactional());
            } else {
                Predef$.MODULE$.print("offset: " + batch.lastOffset());
            }
            Predef$.MODULE$.println(" position: " + validBytes$1.elem + " " + (Object)((Object)batch.timestampType()) + ": " + batch.maxTimestamp() + " isvalid: " + batch.isValid() + " size: " + batch.sizeInBytes() + " magic: " + batch.magic() + " compresscodec: " + (Object)((Object)batch.compressionType()) + " crc: " + batch.checksum());
        }
        validBytes$1.elem += (long)batch.sizeInBytes();
    }

    private DumpLogSegments$() {
        MODULE$ = this;
    }

    public static final /* synthetic */ Object $anonfun$dumpTimeIndex$2$adapted(TimeIndex timeIndex$1, TimestampOffset entry$1, FileLogInputStream.FileChannelRecordBatch x$1) {
        return BoxesRunTime.boxToBoolean(DumpLogSegments$.$anonfun$dumpTimeIndex$2(timeIndex$1, entry$1, x$1));
    }

    public static final /* synthetic */ Object $anonfun$dumpTimeIndex$3$adapted(LongRef maxTimestamp$1, Record record) {
        maxTimestamp$1.elem = package$.MODULE$.max(maxTimestamp$1.elem, record.timestamp());
        return BoxedUnit.UNIT;
    }
}

