/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import kafka.api.Request$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchPartitionData;
import kafka.server.KafkaConfig;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory$UnboundedQuota$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.server.epoch.LeaderEpochCache;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import scala.Equals;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.SetLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0$mcJ$sp;

@ScalaSignature(bytes="\u0006\u0001\ted\u0001B\u0001\u0003\u0001\u001d\u0011\u0011DU3qY&\u001c\u0017-\u00117uKJdun\u001a#jeN$\u0006N]3bI*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e\u0011%i\u0001A!A!\u0002\u0013q1$\u0001\u0003oC6,\u0007CA\b\u0019\u001d\t\u0001b\u0003\u0005\u0002\u0012)5\t!C\u0003\u0002\u0014\r\u00051AH]8pizR\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\ta\u0001\u0015:fI\u00164\u0017BA\r\u001b\u0005\u0019\u0019FO]5oO*\u0011q\u0003F\u0005\u0003\u001bqI!!\b\u0010\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\u0006\u0003?\u0011\tQ!\u001e;jYND\u0011\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0015\u0002\u0019M|WO]2f\u0005J|7.\u001a:\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015\"\u0011aB2mkN$XM]\u0005\u0003O\u0011\u0012aB\u0011:pW\u0016\u0014XI\u001c3Q_&tG/\u0003\u0002\"\u0015!A!\u0006\u0001B\u0001B\u0003%1&\u0001\u0007ce>\\WM]\"p]\u001aLw\r\u0005\u0002\nY%\u0011QF\u0001\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0003)\u0011X\r\u001d7jG\u0006luM\u001d\t\u0003\u0013EJ!A\r\u0002\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\"AA\u0007\u0001B\u0001B\u0003%Q'A\u0003rk>$\u0018\r\u0005\u0002\nm%\u0011qG\u0001\u0002\u0018%\u0016\u0004H.[2bi&|g.U;pi\u0006l\u0015M\\1hKJD\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IAO\u0001\u0011EJ|7.\u001a:U_BL7m\u0015;biN\u0004\"!C\u001e\n\u0005q\u0012!\u0001\u0005\"s_.,'\u000fV8qS\u000e\u001cF/\u0019;t\u0011\u0015q\u0004\u0001\"\u0001@\u0003\u0019a\u0014N\\5u}Q9\u0001)\u0011\"D\t\u00163\u0005CA\u0005\u0001\u0011\u0015iQ\b1\u0001\u000f\u0011\u0015\tS\b1\u0001#\u0011\u0015QS\b1\u0001,\u0011\u0015yS\b1\u00011\u0011\u0015!T\b1\u00016\u0011\u0015IT\b1\u0001;\u000b\u0011A\u0005\u0001A%\u0003\u0007I+\u0015\u000b\u0005\u0002K-:\u0011\u0011bS\u0004\u0006\u0019\nA\t!T\u0001\u001a%\u0016\u0004H.[2b\u00032$XM\u001d'pO\u0012K'o\u001d+ie\u0016\fG\r\u0005\u0002\n\u001d\u001a)\u0011A\u0001E\u0001\u001fN\u0011a\n\u0015\t\u0003#Jk\u0011\u0001F\u0005\u0003'R\u0011a!\u00118z%\u00164\u0007\"\u0002 O\t\u0003)F#A'\u0007\u000b]s\u0005A\u0001-\u0003\u0019\u0019+Go\u00195SKF,Xm\u001d;\u0014\u0007Y\u0003\u0016\f\u0005\u0002[;:\u0011\u0011bW\u0005\u00039\n\tQ#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG-\u0003\u0002X=*\u0011AL\u0001\u0005\tAZ\u0013)\u0019!C\u0001C\u0006QQO\u001c3fe2L\u0018N\\4\u0016\u0003\t\u0004\"a\u00199\u000f\u0005\u0011tW\"A3\u000b\u0005\u0019<\u0017\u0001\u0003:fcV,7\u000f^:\u000b\u0005!L\u0017AB2p[6|gN\u0003\u0002\u0006U*\u00111\u000e\\\u0001\u0007CB\f7\r[3\u000b\u00035\f1a\u001c:h\u0013\tyW-\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH/\u0003\u0002re\n9!)^5mI\u0016\u0014(BA8f\u0011!!hK!A!\u0002\u0013\u0011\u0017aC;oI\u0016\u0014H._5oO\u0002BQA\u0010,\u0005\u0002Y$\"a^=\u0011\u0005a4V\"\u0001(\t\u000b\u0001,\b\u0019\u00012\t\u000bm4F\u0011\u0001?\u0002\u000f%\u001cX)\u001c9usV\tQ\u0010\u0005\u0002R}&\u0011q\u0010\u0006\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0019A\u0016C\u0001\u0003\u000b\taa\u001c4gg\u0016$H\u0003BA\u0004\u0003\u001b\u00012!UA\u0005\u0013\r\tY\u0001\u0006\u0002\u0005\u0019>tw\r\u0003\u0005\u0002\u0010\u0005\u0005\u0001\u0019AA\t\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004B!a\u0005\u0002\u00165\tq-C\u0002\u0002\u0018\u001d\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002\u001cY#\t%!\b\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\b\u0011\t\u0005\u0005\u00121F\u0007\u0003\u0003GQA!!\n\u0002(\u0005!A.\u00198h\u0015\t\tI#\u0001\u0003kCZ\f\u0017bA\r\u0002$\u00199\u0011q\u0006(\u0001\u0005\u0005E\"!\u0004)beRLG/[8o\t\u0006$\u0018mE\u0003\u0002.A\u000b\u0019\u0004E\u0002[\u0003kI1!a\f_\u0011)\u0001\u0017Q\u0006BC\u0002\u0013\u0005\u0011\u0011H\u000b\u0003\u0003w\u0001B!!\u0010\u0002D9\u0019A-a\u0010\n\u0007\u0005\u0005S-A\u0007GKR\u001c\u0007NU3ta>t7/Z\u0005\u0005\u0003_\t)EC\u0002\u0002B\u0015D!\u0002^A\u0017\u0005\u0003\u0005\u000b\u0011BA\u001e\u0011\u001dq\u0014Q\u0006C\u0001\u0003\u0017\"B!!\u0014\u0002PA\u0019\u00010!\f\t\u000f\u0001\fI\u00051\u0001\u0002<!A\u00111KA\u0017\t\u0003\t)&A\u0003feJ|'/\u0006\u0002\u0002XA!\u0011\u0011LA0\u001b\t\tYFC\u0002\u0002^\u001d\f\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003C\nYF\u0001\u0004FeJ|'o\u001d\u0005\t\u0003K\ni\u0003\"\u0001\u0002h\u0005IAo\u001c*fG>\u0014Hm]\u000b\u0003\u0003S\u0002B!a\u001b\u0002r5\u0011\u0011Q\u000e\u0006\u0004\u0003_:\u0017A\u0002:fG>\u0014H-\u0003\u0003\u0002t\u00055$!D'f[>\u0014\u0018PU3d_J$7\u000f\u0003\u0005\u0002x\u00055B\u0011AA=\u00035A\u0017n\u001a5XCR,'/\\1sWV\u0011\u0011q\u0001\u0005\t\u0003{\ni\u0003\"\u0001\u0002z\u0005qAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$\b\u0002CAA\u0003[!\t!a!\u0002\u0013\u0015D8-\u001a9uS>tWCAAC!\u0015\t\u0016qQAF\u0013\r\tI\t\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u00055\u0015q\u0013\b\u0005\u0003\u001f\u000b\u0019JD\u0002\u0012\u0003#K\u0011!F\u0005\u0004\u0003+#\u0012a\u00029bG.\fw-Z\u0005\u0005\u00033\u000bYJA\u0005UQJ|w/\u00192mK*\u0019\u0011Q\u0013\u000b\t\u0011\u0005m\u0011Q\u0006C!\u0003;)a!!)\u0001\u0001\u0005\r&A\u0001)E!\rQ\u0015Q\u0006\u0005\n\u0003O\u0003!\u0019!C\u0005\u0003S\u000b\u0011B]3qY&\u001c\u0017-\u00133\u0016\u0005\u0005-\u0006cA)\u0002.&\u0019\u0011q\u0016\u000b\u0003\u0007%sG\u000f\u0003\u0005\u00024\u0002\u0001\u000b\u0011BAV\u0003)\u0011X\r\u001d7jG\u0006LE\r\t\u0005\n\u0003o\u0003!\u0019!C\u0005\u0003s\u000b\u0001\"\\1y\u0005f$Xm]\u000b\u0003\u0003w\u0003B!!\t\u0002>&!\u0011qXA\u0012\u0005\u001dIe\u000e^3hKJD\u0001\"a1\u0001A\u0003%\u00111X\u0001\n[\u0006D()\u001f;fg\u0002B\u0011\"a2\u0001\u0005\u0004%I!!/\u0002\u0013\u0019,Go\u00195TSj,\u0007\u0002CAf\u0001\u0001\u0006I!a/\u0002\u0015\u0019,Go\u00195TSj,\u0007\u0005C\u0004\u0002P\u0002!I!!5\u0002\u001b\u0015\u0004xn\u00195DC\u000eDWm\u00149u)\u0011\t\u0019.!9\u0011\u000bE\u000b9)!6\u0011\t\u0005]\u0017Q\\\u0007\u0003\u00033T1!a7\u0003\u0003\u0015)\u0007o\\2i\u0013\u0011\ty.!7\u0003!1+\u0017\rZ3s\u000bB|7\r[\"bG\",\u0007\u0002CAr\u0003\u001b\u0004\r!!\u0005\u0002\u0005Q\u0004\bbBAt\u0001\u0011\u0005\u0011\u0011^\u0001\u0006M\u0016$8\r\u001b\u000b\u0005\u0003W\fi\u0010\u0005\u0004\u0002n\u0006M\u0018q_\u0007\u0003\u0003_T1!!=\u0015\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003k\fyOA\u0002TKF\u0004r!UA}\u0003#\t\u0019+C\u0002\u0002|R\u0011a\u0001V;qY\u0016\u0014\u0004bBA\u0000\u0003K\u0004\r!S\u0001\rM\u0016$8\r\u001b*fcV,7\u000f\u001e\u0005\b\u0005\u0007\u0001A\u0011\u0001B\u0003\u0003Q\u0001(o\\2fgN\u0004\u0016M\u001d;ji&|g\u000eR1uCRA!q\u0001B\u0007\u0005\u001f\u0011\u0019\u0002E\u0002R\u0005\u0013I1Aa\u0003\u0015\u0005\u0011)f.\u001b;\t\u0011\u0005=!\u0011\u0001a\u0001\u0003#A\u0001B!\u0005\u0003\u0002\u0001\u0007\u0011qA\u0001\fM\u0016$8\r[(gMN,G\u000f\u0003\u0005\u0003\u0016\t\u0005\u0001\u0019AAR\u00035\u0001\u0018M\u001d;ji&|g\u000eR1uC\"9!\u0011\u0004\u0001\u0005\u0002\tm\u0011A\u00065b]\u0012dWm\u00144gg\u0016$x*\u001e;PMJ\u000bgnZ3\u0015\t\u0005\u001d!Q\u0004\u0005\t\u0003\u001f\u00119\u00021\u0001\u0002\u0012!9!\u0011\u0005\u0001\u0005\u0002\t\r\u0012A\u00075b]\u0012dW\rU1si&$\u0018n\u001c8t/&$\b.\u0012:s_J\u001cH\u0003\u0002B\u0004\u0005KA\u0001Ba\n\u0003 \u0001\u0007!\u0011F\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bCBAG\u0005W\t\t\"\u0003\u0003\u0003.\u0005m%\u0001C%uKJ\f'\r\\3\t\u000f\tE\u0002\u0001\"\u0001\u00034\u00059\"-^5mI2+\u0017\rZ3s\u000bB|7\r\u001b*fcV,7\u000f\u001e\u000b\u0005\u0005k\u0011\t\u0005E\u0003[\u0005o\u0011Y$C\u0002\u0003:y\u0013ACU3tk2$x+\u001b;i!\u0006\u0014H/\u001b;j_:\u001c\b\u0003CAw\u0005{\t\t\"a+\n\t\t}\u0012q\u001e\u0002\u0004\u001b\u0006\u0004\b\u0002\u0003B\"\u0005_\u0001\rA!\u0012\u0002\u001b\u0005dG\u000eU1si&$\u0018n\u001c8t!\u0019\ti/a=\u0003HA9\u0011+!?\u0002\u0012\t%\u0003cA\u0005\u0003L%\u0019!Q\n\u0002\u0003'A\u000b'\u000f^5uS>tg)\u001a;dQN#\u0018\r^3\t\u000f\tE\u0003\u0001\"\u0001\u0003T\u0005)b-\u001a;dQ\u0016\u0003xn\u00195t\rJ|W\u000eT3bI\u0016\u0014H\u0003\u0002B+\u0005;\u0002\u0002\"!<\u0003>\u0005E!q\u000b\t\u0004I\ne\u0013b\u0001B.K\nqQ\t]8dQ\u0016sGm\u00144gg\u0016$\b\u0002\u0003B\u0014\u0005\u001f\u0002\rAa\u000f\t\u000f\t\u0005\u0004\u0001\"\u0001\u0003d\u0005iQ.Y=cKR\u0013XO\\2bi\u0016$BA!\u001a\u0003jA)!La\u000e\u0003hAA\u0011Q\u001eB\u001f\u0003#\t9\u0001\u0003\u0005\u0003l\t}\u0003\u0019\u0001B+\u000351W\r^2iK\u0012,\u0005o\\2ig\"9!q\u000e\u0001\u0005\u0002\tE\u0014!\u00052vS2$g)\u001a;dQJ+\u0017/^3tiR!!1\u000fB;!\u0011Q&qG%\t\u0011\t]$Q\u000ea\u0001\u0005\u000b\nA\u0002]1si&$\u0018n\u001c8NCB\u0004")
public class ReplicaAlterLogDirsThread
extends AbstractFetcherThread {
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaMgr;
    private final ReplicationQuotaManager quota;
    private final int replicaId;
    private final Integer maxBytes;
    private final Integer fetchSize;

    private int replicaId() {
        return this.replicaId;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    private Option<LeaderEpochCache> epochCacheOpt(TopicPartition tp) {
        return this.replicaMgr.getReplica(tp).map((Function1<Replica, LeaderEpochCache> & Serializable & scala.Serializable)x$1 -> x$1.epochs().get());
    }

    public Seq<Tuple2<TopicPartition, PartitionData>> fetch(FetchRequest fetchRequest) {
        ObjectRef<Object> partitionData = ObjectRef.create(null);
        org.apache.kafka.common.requests.FetchRequest request = (org.apache.kafka.common.requests.FetchRequest)fetchRequest.underlying().build();
        this.replicaMgr.fetchMessages(0L, Request$.MODULE$.FutureLocalReplicaId(), request.minBytes(), request.maxBytes(), request.version() <= 2, ((scala.collection.mutable.MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.fetchData()).asScala()).toSeq(), QuotaFactory$UnboundedQuota$.MODULE$, (Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>)(Function1<Seq, Object> & Serializable & scala.Serializable)responsePartitionData -> {
            ReplicaAlterLogDirsThread.processResponseCallback$1(responsePartitionData, partitionData);
            return BoxedUnit.UNIT;
        }, request.isolationLevel());
        if ((Seq)partitionData.elem == null) {
            throw new IllegalStateException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to fetch data for partitions ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps(request.fetchData().keySet().toArray())).mkString(",")})));
        }
        return ((Seq)partitionData.elem).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TopicPartition key = (TopicPartition)tuple2._1();
            FetchResponse.PartitionData value = (FetchResponse.PartitionData)tuple2._2();
            Tuple2<TopicPartition, PartitionData> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), new PartitionData(value));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public void processPartitionData(TopicPartition topicPartition, long fetchOffset, PartitionData partitionData) {
        Replica futureReplica = this.replicaMgr.getReplicaOrException(topicPartition, Request$.MODULE$.FutureLocalReplicaId());
        Partition partition = this.replicaMgr.getPartition(topicPartition).get();
        MemoryRecords records = partitionData.toRecords();
        if (fetchOffset != futureReplica.logEndOffset().messageOffset()) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch for the future replica %s: fetched offset = %d, log end offset = %d.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topicPartition, BoxesRunTime.boxToLong(fetchOffset), BoxesRunTime.boxToLong(futureReplica.logEndOffset().messageOffset())})));
        }
        partition.appendRecordsToFollowerOrFutureReplica(records, true);
        futureReplica.highWatermark_$eq(new LogOffsetMetadata(partitionData.highWatermark(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
        futureReplica.maybeIncrementLogStartOffset(partitionData.logStartOffset());
        if (partition.maybeReplaceCurrentWithFutureReplica()) {
            this.removePartitions((Set)Set$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition})));
        }
        this.quota.record(records.sizeInBytes());
    }

    @Override
    public long handleOffsetOutOfRange(TopicPartition topicPartition) {
        long l;
        Replica futureReplica = this.replicaMgr.getReplicaOrException(topicPartition, Request$.MODULE$.FutureLocalReplicaId());
        Replica currentReplica = this.replicaMgr.getReplicaOrException(topicPartition);
        Partition partition = this.replicaMgr.getPartition(topicPartition).get();
        long logEndOffset = currentReplica.logEndOffset().messageOffset();
        if (logEndOffset < futureReplica.logEndOffset().messageOffset()) {
            this.warn((Function0<String> & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Future replica for partition %s reset its fetch offset from %d to current replica's latest offset %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topicPartition, BoxesRunTime.boxToLong(futureReplica.logEndOffset().messageOffset()), BoxesRunTime.boxToLong(logEndOffset)})));
            partition.truncateTo(logEndOffset, true);
            l = logEndOffset;
        } else {
            long currentReplicaStartOffset = currentReplica.logStartOffset();
            this.warn((Function0<String> & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Future replica for partition %s reset its fetch offset from %d to current replica's start offset %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topicPartition, BoxesRunTime.boxToLong(futureReplica.logEndOffset().messageOffset()), BoxesRunTime.boxToLong(currentReplicaStartOffset)})));
            long offsetToFetch = Math.max(currentReplicaStartOffset, futureReplica.logEndOffset().messageOffset());
            if (currentReplicaStartOffset > futureReplica.logEndOffset().messageOffset()) {
                partition.truncateFullyAndStartAt(currentReplicaStartOffset, true);
            }
            l = offsetToFetch;
        }
        return l;
    }

    @Override
    public void handlePartitionsWithErrors(Iterable<TopicPartition> partitions) {
        block0: {
            if (!partitions.nonEmpty()) break block0;
            this.delayPartitions(partitions, Predef$.MODULE$.Integer2int(this.brokerConfig.replicaFetchBackoffMs()));
        }
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Map<TopicPartition, Object>> buildLeaderEpochRequest(Seq<Tuple2<TopicPartition, PartitionFetchState>> allPartitions) {
        scala.collection.immutable.Map partitionEpochOpts = ((TraversableOnce)((TraversableLike)allPartitions.filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean(ReplicaAlterLogDirsThread.$anonfun$buildLeaderEpochRequest$1(x0$3)))).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Tuple2<TopicPartition, Option<LeaderEpochCache>> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), this.epochCacheOpt(tp));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Tuple2 tuple2 = partitionEpochOpts.partition((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean(ReplicaAlterLogDirsThread.$anonfun$buildLeaderEpochRequest$3(x0$5)));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        scala.collection.immutable.Map partitionsWithEpoch = (scala.collection.immutable.Map)tuple2._1();
        scala.collection.immutable.Map partitionsWithoutEpoch = (scala.collection.immutable.Map)tuple2._2();
        Tuple2<scala.collection.immutable.Map, scala.collection.immutable.Map> tuple22 = new Tuple2<scala.collection.immutable.Map, scala.collection.immutable.Map>(partitionsWithEpoch, partitionsWithoutEpoch);
        Tuple2<scala.collection.immutable.Map, scala.collection.immutable.Map> tuple23 = tuple22;
        scala.collection.immutable.Map partitionsWithEpoch2 = tuple23._1();
        scala.collection.immutable.Map partitionsWithoutEpoch2 = tuple23._2();
        scala.collection.immutable.Map result2 = partitionsWithEpoch2.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Option epochCacheOpt = (Option)tuple2._2();
            Tuple2<TopicPartition, Integer> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), BoxesRunTime.boxToInteger(((LeaderEpochCache)epochCacheOpt.get()).latestEpoch()));
            return tuple22;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        return new AbstractFetcherThread.ResultWithPartitions<Map<TopicPartition, Object>>(result2, partitionsWithoutEpoch2.keys().toSet());
    }

    @Override
    public Map<TopicPartition, EpochEndOffset> fetchEpochsFromLeader(Map<TopicPartition, Object> partitions) {
        return partitions.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$7 -> {
            Tuple2<TopicPartition, EpochEndOffset> tuple2;
            Tuple2 tuple22 = x0$7;
            if (tuple22 != null) {
                TopicPartition tp = (TopicPartition)tuple22._1();
                int epoch = tuple22._2$mcI$sp();
                try {
                    tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), new EpochEndOffset(Errors.NONE, $this.replicaMgr.getReplicaOrException(tp).epochs().get().endOffsetFor(epoch)));
                }
                catch (Throwable t) {
                    this.warn((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error when getting EpochEndOffset for ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{tp})), (Function0<Throwable> & Serializable & scala.Serializable)() -> t);
                    tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), new EpochEndOffset(Errors.forException(t), -1L));
                }
            } else {
                throw new MatchError(tuple22);
            }
            Tuple2<TopicPartition, EpochEndOffset> tuple23 = tuple2;
            return tuple23;
        }, Map$.MODULE$.canBuildFrom());
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Map<TopicPartition, Object>> maybeTruncate(Map<TopicPartition, EpochEndOffset> fetchedEpochs) {
        GenMap fetchOffsets = HashMap$.MODULE$.empty();
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply(Nil$.MODULE$);
        fetchedEpochs.foreach(arg_0 -> ReplicaAlterLogDirsThread.$anonfun$maybeTruncate$1(this, (HashMap)fetchOffsets, partitionsWithError, arg_0));
        return new AbstractFetcherThread.ResultWithPartitions<GenMap>(fetchOffsets, partitionsWithError);
    }

    public AbstractFetcherThread.ResultWithPartitions<FetchRequest> buildFetchRequest(Seq<Tuple2<TopicPartition, PartitionFetchState>> partitionMap) {
        Object object;
        Option maxPartitionOpt = ((TraversableOnce)partitionMap.filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$9 -> BoxesRunTime.boxToBoolean(ReplicaAlterLogDirsThread.$anonfun$buildFetchRequest$1(this, x0$9)))).reduceLeftOption((Function2<Tuple2, Tuple2, Tuple2> & Serializable & scala.Serializable)(left, right) -> {
            Tuple2 tuple2;
            block3: {
                block2: {
                    if (new StringOps(Predef$.MODULE$.augmentString(((TopicPartition)left._1()).topic())).$greater(((TopicPartition)right._1()).topic())) break block2;
                    String string = ((TopicPartition)left._1()).topic();
                    String string2 = ((TopicPartition)right._1()).topic();
                    if ((string != null ? !string.equals(string2) : string2 != null) || ((TopicPartition)left._1()).partition() < ((TopicPartition)right._1()).partition()) break block3;
                }
                tuple2 = left;
                return tuple2;
            }
            tuple2 = right;
            return tuple2;
        });
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply(Nil$.MODULE$);
        if (maxPartitionOpt.nonEmpty()) {
            Tuple2 tuple2 = (Tuple2)maxPartitionOpt.get();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            PartitionFetchState partitionFetchState = (PartitionFetchState)tuple2._2();
            Tuple2<TopicPartition, PartitionFetchState> tuple22 = new Tuple2<TopicPartition, PartitionFetchState>(topicPartition, partitionFetchState);
            Tuple2<TopicPartition, PartitionFetchState> tuple23 = tuple22;
            TopicPartition topicPartition2 = tuple23._1();
            PartitionFetchState partitionFetchState2 = tuple23._2();
            try {
                long logStartOffset = this.replicaMgr.getReplicaOrException(topicPartition2, Request$.MODULE$.FutureLocalReplicaId()).logStartOffset();
                object = requestMap.put(topicPartition2, new FetchRequest.PartitionData(partitionFetchState2.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize())));
            }
            catch (KafkaStorageException e) {
                object = partitionsWithError.$plus$eq(topicPartition2);
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        FetchRequest.Builder requestBuilder = FetchRequest.Builder.forReplica(ApiKeys.FETCH.latestVersion(), this.replicaId(), 0, 0, requestMap).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes()));
        return new AbstractFetcherThread.ResultWithPartitions<FetchRequest>(new FetchRequest(requestBuilder), partitionsWithError);
    }

    private static final void processResponseCallback$1(Seq responsePartitionData, ObjectRef partitionData$1) {
        partitionData$1.elem = responsePartitionData.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            FetchPartitionData data = (FetchPartitionData)tuple2._2();
            java.util.List abortedTransactions = (java.util.List)data.abortedTransactions().map((Function1<List, java.util.List> & Serializable & scala.Serializable)x$2 -> JavaConverters$.MODULE$.seqAsJavaListConverter(x$2).asJava()).orNull(Predef$.MODULE$.$conforms());
            long lastStableOffset = BoxesRunTime.unboxToLong(data.lastStableOffset().getOrElse((JFunction0$mcJ$sp & scala.Serializable)() -> -1L));
            Tuple2<TopicPartition, FetchResponse.PartitionData> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), new FetchResponse.PartitionData(data.error(), data.highWatermark(), lastStableOffset, data.logStartOffset(), abortedTransactions, data.records()));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$buildLeaderEpochRequest$1(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        PartitionFetchState state = (PartitionFetchState)tuple2._2();
        boolean bl = state.isTruncatingLog();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$buildLeaderEpochRequest$3(Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option epochCacheOpt = (Option)tuple2._2();
        boolean bl = epochCacheOpt.nonEmpty();
        return bl;
    }

    public static final /* synthetic */ Object $anonfun$maybeTruncate$1(ReplicaAlterLogDirsThread $this, HashMap fetchOffsets$1, scala.collection.mutable.Set partitionsWithError$1, Tuple2 x0$8) {
        Equals equals;
        Tuple2 tuple2 = x0$8;
        if (tuple2 != null) {
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            EpochEndOffset epochOffset = (EpochEndOffset)tuple2._2();
            try {
                Replica futureReplica = $this.replicaMgr.getReplicaOrException(topicPartition, Request$.MODULE$.FutureLocalReplicaId());
                Partition partition = $this.replicaMgr.getPartition(topicPartition).get();
                if (epochOffset.hasError()) {
                    $this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retrying leaderEpoch request for partition ", " as the current replica reported an error: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topicPartition, epochOffset.error()})));
                    equals = partitionsWithError$1.$plus$eq(topicPartition);
                } else {
                    long fetchOffset = epochOffset.endOffset() == -1L ? $this.partitionStates().stateValue(topicPartition).fetchOffset() : (epochOffset.endOffset() >= futureReplica.logEndOffset().messageOffset() ? futureReplica.logEndOffset().messageOffset() : epochOffset.endOffset());
                    partition.truncateTo(fetchOffset, true);
                    equals = fetchOffsets$1.put(topicPartition, BoxesRunTime.boxToLong(fetchOffset));
                }
            }
            catch (KafkaStorageException e) {
                $this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to truncate ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topicPartition})), (Function0<Throwable>)(Function0<KafkaStorageException> & Serializable & scala.Serializable)() -> e);
                equals = partitionsWithError$1.$plus$eq(topicPartition);
            }
        } else {
            throw new MatchError(tuple2);
        }
        SetLike setLike = equals;
        return setLike;
    }

    public static final /* synthetic */ boolean $anonfun$buildFetchRequest$1(ReplicaAlterLogDirsThread $this, Tuple2 x0$9) {
        Tuple2 tuple2 = x0$9;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        PartitionFetchState partitionFetchState = (PartitionFetchState)tuple2._2();
        boolean bl = partitionFetchState.isReadyForFetch() && !$this.quota.isQuotaExceeded();
        return bl;
    }

    public ReplicaAlterLogDirsThread(String name, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, ReplicaManager replicaMgr, ReplicationQuotaManager quota, BrokerTopicStats brokerTopicStats) {
        this.brokerConfig = brokerConfig;
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        super(name, name, sourceBroker, Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), false, true);
        this.replicaId = brokerConfig.brokerId();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
    }

    public static class FetchRequest
    implements AbstractFetcherThread.FetchRequest {
        private final FetchRequest.Builder underlying;

        public FetchRequest.Builder underlying() {
            return this.underlying;
        }

        @Override
        public boolean isEmpty() {
            return this.underlying().fetchData().isEmpty();
        }

        @Override
        public long offset(TopicPartition topicPartition) {
            return ((FetchRequest.PartitionData)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.underlying().fetchData()).asScala()).apply(topicPartition)).fetchOffset;
        }

        public String toString() {
            return this.underlying().toString();
        }

        public FetchRequest(FetchRequest.Builder underlying) {
            this.underlying = underlying;
        }
    }

    public static class PartitionData
    implements AbstractFetcherThread.PartitionData {
        private final FetchResponse.PartitionData underlying;

        public FetchResponse.PartitionData underlying() {
            return this.underlying;
        }

        @Override
        public Errors error() {
            return this.underlying().error;
        }

        @Override
        public MemoryRecords toRecords() {
            MemoryRecords memoryRecords;
            Records records = this.underlying().records;
            MemoryRecords memoryRecords2 = MemoryRecords.EMPTY;
            if (!(records != null ? !records.equals(memoryRecords2) : memoryRecords2 != null)) {
                memoryRecords = (MemoryRecords)this.underlying().records;
            } else {
                ByteBuffer buffer = ByteBuffer.allocate(this.underlying().records.sizeInBytes());
                ((FileRecords)this.underlying().records).readInto(buffer, 0);
                memoryRecords = MemoryRecords.readableRecords(buffer);
            }
            return memoryRecords;
        }

        @Override
        public long highWatermark() {
            return this.underlying().highWatermark;
        }

        public long logStartOffset() {
            return this.underlying().logStartOffset;
        }

        @Override
        public Option<Throwable> exception() {
            Errors errors = this.error();
            Option option = ((Object)((Object)Errors.NONE)).equals((Object)errors) ? None$.MODULE$ : new Some<ApiException>(errors.exception());
            return option;
        }

        public String toString() {
            return this.underlying().toString();
        }

        public PartitionData(FetchResponse.PartitionData underlying) {
            this.underlying = underlying;
        }
    }
}

