/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.cluster.BrokerEndPoint;
import kafka.common.ClientIdAndBroker;
import kafka.common.KafkaException;
import kafka.server.AbstractFetcherThread$;
import kafka.server.BrokerAndInitialOffset;
import kafka.server.FetcherLagStats;
import kafka.server.FetcherStats;
import kafka.server.PartitionFetchState;
import kafka.utils.CoreUtils$;
import kafka.utils.DelayedItem;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.internals.PartitionStates;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.requests.EpochEndOffset;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0$mcJ$sp;
import scala.runtime.java8.JFunction0$mcV$sp;
import scala.runtime.java8.JFunction0$mcZ$sp;

@ScalaSignature(bytes="\u0006\u0001\rug!B\u0001\u0003\u0003\u00039!!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\tQ!\u001e;jYNL!!\u0004\u0006\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\u0005\n\u001f\u0001\u0011\t\u0011)A\u0005!u\tAA\\1nKB\u0011\u0011C\u0007\b\u0003%a\u0001\"a\u0005\f\u000e\u0003QQ!!\u0006\u0004\u0002\rq\u0012xn\u001c;?\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0003\u0019\u0001&/\u001a3fM&\u00111\u0004\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005e1\u0012BA\b\r\u0011!y\u0002A!A!\u0002\u0013\u0001\u0012\u0001C2mS\u0016tG/\u00133\t\u0011\u0005\u0002!Q1A\u0005\u0002\t\nAb]8ve\u000e,'I]8lKJ,\u0012a\t\t\u0003I\u001dj\u0011!\n\u0006\u0003M\u0011\tqa\u00197vgR,'/\u0003\u0002)K\tq!I]8lKJ,e\u000e\u001a)pS:$\b\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002\u001bM|WO]2f\u0005J|7.\u001a:!\u0011!a\u0003A!A!\u0002\u0013i\u0013A\u00044fi\u000eD')Y2l\u001f\u001a4Wj\u001d\t\u0003]=j\u0011AF\u0005\u0003aY\u00111!\u00138u\u0011%\u0011\u0004A!A!\u0002\u0013\u0019d'A\bjg&sG/\u001a:skB$\u0018N\u00197f!\tqC'\u0003\u00026-\t9!i\\8mK\u0006t\u0017B\u0001\u001a\r\u0011!A\u0004A!A!\u0002\u0013\u0019\u0014\u0001F5oG2,H-\u001a'pOR\u0013XO\\2bi&|g\u000eC\u0003;\u0001\u0011\u00051(\u0001\u0004=S:LGO\u0010\u000b\byyz\u0004)\u0011\"D!\ti\u0004!D\u0001\u0003\u0011\u0015y\u0011\b1\u0001\u0011\u0011\u0015y\u0012\b1\u0001\u0011\u0011\u0015\t\u0013\b1\u0001$\u0011\u001da\u0013\b%AA\u00025BqAM\u001d\u0011\u0002\u0003\u00071\u0007C\u00039s\u0001\u00071\u0007B\u0003F\u0001\t\u0005aIA\u0002S\u000bF\u000b\"a\u0012&\u0011\u00059B\u0015BA%\u0017\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aSAt\u001d\tiDjB\u0003N\u0005!\u0005a*A\u000bBEN$(/Y2u\r\u0016$8\r[3s)\"\u0014X-\u00193\u0011\u0005uze!B\u0001\u0003\u0011\u0003\u00016CA(R!\tq#+\u0003\u0002T-\t1\u0011I\\=SK\u001aDQAO(\u0005\u0002U#\u0012A\u0014\u0004\u0005/>\u0003\u0005L\u0001\u000bSKN,H\u000e^,ji\"\u0004\u0016M\u001d;ji&|gn]\u000b\u00033\u0016\u001cBAV)[;B\u0011afW\u0005\u00039Z\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002/=&\u0011qL\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tCZ\u0013)\u001a!C\u0001E\u00061!/Z:vYR,\u0012a\u0019\t\u0003I\u0016d\u0001\u0001B\u0003g-\n\u0007qMA\u0001S#\t9\u0005\u000e\u0005\u0002/S&\u0011!N\u0006\u0002\u0004\u0003:L\b\u0002\u00037W\u0005#\u0005\u000b\u0011B2\u0002\u000fI,7/\u001e7uA!AaN\u0016BK\u0002\u0013\u0005q.A\nqCJ$\u0018\u000e^5p]N<\u0016\u000e\u001e5FeJ|'/F\u0001q!\r\tHO^\u0007\u0002e*\u00111OF\u0001\u000bG>dG.Z2uS>t\u0017BA;s\u0005\r\u0019V\r\u001e\t\u0003o~l\u0011\u0001\u001f\u0006\u0003sj\faaY8n[>t'BA\u0003|\u0015\taX0\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002}\u0006\u0019qN]4\n\u0007\u0005\u0005\u0001P\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u0013\u0005\u0015aK!E!\u0002\u0013\u0001\u0018\u0001\u00069beRLG/[8og^KG\u000f[#se>\u0014\b\u0005\u0003\u0004;-\u0012\u0005\u0011\u0011\u0002\u000b\u0007\u0003\u0017\ty!!\u0005\u0011\t\u00055akY\u0007\u0002\u001f\"1\u0011-a\u0002A\u0002\rDaA\\A\u0004\u0001\u0004\u0001\b\"CA\u000b-\u0006\u0005I\u0011AA\f\u0003\u0011\u0019w\u000e]=\u0016\t\u0005e\u0011q\u0004\u000b\u0007\u00037\t\t#a\t\u0011\u000b\u00055a+!\b\u0011\u0007\u0011\fy\u0002\u0002\u0004g\u0003'\u0011\ra\u001a\u0005\nC\u0006M\u0001\u0013!a\u0001\u0003;A\u0001B\\A\n!\u0003\u0005\r\u0001\u001d\u0005\n\u0003O1\u0016\u0013!C\u0001\u0003S\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0003\u0002,\u0005\u0005SCAA\u0017U\r\u0019\u0017qF\u0016\u0003\u0003c\u0001B!a\r\u0002>5\u0011\u0011Q\u0007\u0006\u0005\u0003o\tI$A\u0005v]\u000eDWmY6fI*\u0019\u00111\b\f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002@\u0005U\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00121a-!\nC\u0002\u001dD\u0011\"!\u0012W#\u0003%\t!a\u0012\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU!\u0011\u0011JA'+\t\tYEK\u0002q\u0003_!aAZA\"\u0005\u00049\u0007\"CA)-\u0006\u0005I\u0011IA*\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u000b\t\u0005\u0003/\n\t'\u0004\u0002\u0002Z)!\u00111LA/\u0003\u0011a\u0017M\\4\u000b\u0005\u0005}\u0013\u0001\u00026bm\u0006L1aGA-\u0011%\t)GVA\u0001\n\u0003\t9'\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001.\u0011%\tYGVA\u0001\n\u0003\ti'\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007!\fy\u0007C\u0005\u0002r\u0005%\u0014\u0011!a\u0001[\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005Ud+!A\u0005B\u0005]\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005e\u0004\u0003B9\u0002|!L1!! s\u0005!IE/\u001a:bi>\u0014\b\"CAA-\u0006\u0005I\u0011AAB\u0003!\u0019\u0017M\\#rk\u0006dGcA\u001a\u0002\u0006\"I\u0011\u0011OA@\u0003\u0003\u0005\r\u0001\u001b\u0005\n\u0003\u00133\u0016\u0011!C!\u0003\u0017\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002[!I\u0011q\u0012,\u0002\u0002\u0013\u0005\u0013\u0011S\u0001\ti>\u001cFO]5oOR\u0011\u0011Q\u000b\u0005\n\u0003+3\u0016\u0011!C!\u0003/\u000ba!Z9vC2\u001cHcA\u001a\u0002\u001a\"I\u0011\u0011OAJ\u0003\u0003\u0005\r\u0001[\u0004\n\u0003;{\u0015\u0011!E\u0001\u0003?\u000bACU3tk2$x+\u001b;i!\u0006\u0014H/\u001b;j_:\u001c\b\u0003BA\u0007\u0003C3\u0001bV(\u0002\u0002#\u0005\u00111U\n\u0005\u0003C\u000bV\fC\u0004;\u0003C#\t!a*\u0015\u0005\u0005}\u0005BCAH\u0003C\u000b\t\u0011\"\u0012\u0002\u0012\"Q\u0011QVAQ\u0003\u0003%\t)a,\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\t\u0005E\u0016q\u0017\u000b\u0007\u0003g\u000bI,a/\u0011\u000b\u00055a+!.\u0011\u0007\u0011\f9\f\u0002\u0004g\u0003W\u0013\ra\u001a\u0005\bC\u0006-\u0006\u0019AA[\u0011\u0019q\u00171\u0016a\u0001a\"Q\u0011qXAQ\u0003\u0003%\t)!1\u0002\u000fUt\u0017\r\u001d9msV!\u00111YAj)\u0011\t)-!6\u0011\u000b9\n9-a3\n\u0007\u0005%gC\u0001\u0004PaRLwN\u001c\t\u0007]\u00055\u0017\u0011\u001b9\n\u0007\u0005=gC\u0001\u0004UkBdWM\r\t\u0004I\u0006MGA\u00024\u0002>\n\u0007q\r\u0003\u0006\u0002X\u0006u\u0016\u0011!a\u0001\u00033\f1\u0001\u001f\u00131!\u0015\tiAVAi\u0011)\ti.!)\u0002\u0002\u0013%\u0011q\\\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002bB!\u0011qKAr\u0013\u0011\t)/!\u0017\u0003\r=\u0013'.Z2u\r%\tIo\u0014I\u0001$\u0003\tYO\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cHoE\u0002\u0002hFC\u0001\"a<\u0002h\u001a\u0005\u0011\u0011_\u0001\bSN,U\u000e\u001d;z+\u0005\u0019\u0004\u0002CA{\u0003O4\t!a>\u0002\r=4gm]3u)\u0011\tI0a@\u0011\u00079\nY0C\u0002\u0002~Z\u0011A\u0001T8oO\"9!\u0011AAz\u0001\u00041\u0018A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0004\n\u0005\u000by\u0005\u0013aI\u0001\u0005\u000f\u0011Q\u0002U1si&$\u0018n\u001c8ECR\f7c\u0001B\u0002#\"A!1\u0002B\u0002\r\u0003\u0011i!A\u0003feJ|'/\u0006\u0002\u0003\u0010A!!\u0011\u0003B\f\u001b\t\u0011\u0019BC\u0002\u0003\u0016a\f\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u00053\u0011\u0019B\u0001\u0004FeJ|'o\u001d\u0005\t\u0005;\u0011\u0019A\"\u0001\u0003 \u0005IQ\r_2faRLwN\\\u000b\u0003\u0005C\u0001RALAd\u0005G\u0001BA!\n\u000309!!q\u0005B\u0016\u001d\r\u0019\"\u0011F\u0005\u0002/%\u0019!Q\u0006\f\u0002\u000fA\f7m[1hK&!!\u0011\u0007B\u001a\u0005%!\u0006N]8xC\ndWMC\u0002\u0003.YA\u0001Ba\u000e\u0003\u0004\u0019\u0005!\u0011H\u0001\ni>\u0014VmY8sIN,\"Aa\u000f\u0011\t\tu\"1I\u0007\u0003\u0005\u007fQ1A!\u0011y\u0003\u0019\u0011XmY8sI&!!Q\tB \u00055iU-\\8ssJ+7m\u001c:eg\"A!\u0011\nB\u0002\r\u0003\u0011Y%A\u0007iS\u001eDw+\u0019;fe6\f'o[\u000b\u0003\u0003sD\u0011Ba\u0014P#\u0003%\tA!\u0015\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011\u0019FK\u0002.\u0003_A\u0011Ba\u0016P#\u0003%\tA!\u0017\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\u0011YFK\u00024\u0003_!qAa\u0018\u0001\u0005\u0003\u0011\tG\u0001\u0002Q\tF\u0019qIa\u0019\u0011\u0007-\u0013\u0019\u0001\u0003\u0006\u0003h\u0001\u0011\r\u0011\"\u0001\u0003\u0005S\nq\u0002]1si&$\u0018n\u001c8Ti\u0006$Xm]\u000b\u0003\u0005W\u0002bA!\u001c\u0003t\t]TB\u0001B8\u0015\r\u0011\t\b_\u0001\nS:$XM\u001d8bYNLAA!\u001e\u0003p\ty\u0001+\u0019:uSRLwN\\*uCR,7\u000fE\u0002>\u0005sJ1Aa\u001f\u0003\u0005M\u0001\u0016M\u001d;ji&|gNR3uG\"\u001cF/\u0019;f\u0011!\u0011y\b\u0001Q\u0001\n\t-\u0014\u0001\u00059beRLG/[8o'R\fG/Z:!\u0011%\u0011\u0019\t\u0001b\u0001\n\u0013\u0011))\u0001\tqCJ$\u0018\u000e^5p]6\u000b\u0007\u000fT8dWV\u0011!q\u0011\t\u0005\u0005\u0013\u00139*\u0004\u0002\u0003\f*!!Q\u0012BH\u0003\u0015awnY6t\u0015\u0011\u0011\tJa%\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0003\u0016\u0006u\u0013\u0001B;uS2LAA!'\u0003\f\ni!+Z3oiJ\fg\u000e\u001e'pG.D\u0001B!(\u0001A\u0003%!qQ\u0001\u0012a\u0006\u0014H/\u001b;j_:l\u0015\r\u001d'pG.\u0004\u0003\"\u0003BQ\u0001\t\u0007I\u0011\u0002BR\u0003A\u0001\u0018M\u001d;ji&|g.T1q\u0007>tG-\u0006\u0002\u0003&B!!\u0011\u0012BT\u0013\u0011\u0011IKa#\u0003\u0013\r{g\u000eZ5uS>t\u0007\u0002\u0003BW\u0001\u0001\u0006IA!*\u0002#A\f'\u000f^5uS>tW*\u00199D_:$\u0007\u0005C\u0005\u00032\u0002\u0011\r\u0011\"\u0003\u00034\u0006AQ.\u001a;sS\u000eLE-\u0006\u0002\u00036B!!q\u0017B^\u001b\t\u0011IL\u0003\u0002z\t%!!Q\u0018B]\u0005E\u0019E.[3oi&#\u0017I\u001c3Ce>\\WM\u001d\u0005\t\u0005\u0003\u0004\u0001\u0015!\u0003\u00036\u0006IQ.\u001a;sS\u000eLE\r\t\u0005\n\u0005\u000b\u0004!\u0019!C\u0001\u0005\u000f\fABZ3uG\",'o\u0015;biN,\"A!3\u0011\u0007u\u0012Y-C\u0002\u0003N\n\u0011ABR3uG\",'o\u0015;biND\u0001B!5\u0001A\u0003%!\u0011Z\u0001\u000eM\u0016$8\r[3s'R\fGo\u001d\u0011\t\u0013\tU\u0007A1A\u0005\u0002\t]\u0017a\u00044fi\u000eDWM\u001d'bON#\u0018\r^:\u0016\u0005\te\u0007cA\u001f\u0003\\&\u0019!Q\u001c\u0002\u0003\u001f\u0019+Go\u00195fe2\u000bwm\u0015;biND\u0001B!9\u0001A\u0003%!\u0011\\\u0001\u0011M\u0016$8\r[3s\u0019\u0006<7\u000b^1ug\u0002BqA!:\u0001\r#\u00119/\u0001\u000bqe>\u001cWm]:QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u000b\t\u0005S\u0014yO!=\u0003vB\u0019aFa;\n\u0007\t5hC\u0001\u0003V]&$\bb\u0002B\u0001\u0005G\u0004\rA\u001e\u0005\t\u0005g\u0014\u0019\u000f1\u0001\u0002z\u0006Ya-\u001a;dQ>3gm]3u\u0011!\u00119Pa9A\u0002\te\u0018!\u00049beRLG/[8o\t\u0006$\u0018\r\u0005\u0003\u0003|\nuS\"\u0001\u0001\t\u000f\t}\bA\"\u0005\u0004\u0002\u00051\u0002.\u00198eY\u0016|eMZ:fi>+Ho\u00144SC:<W\r\u0006\u0003\u0002z\u000e\r\u0001b\u0002B\u0001\u0005{\u0004\rA\u001e\u0005\b\u0007\u000f\u0001a\u0011CB\u0005\u0003iA\u0017M\u001c3mKB\u000b'\u000f^5uS>t7oV5uQ\u0016\u0013(o\u001c:t)\u0011\u0011Ioa\u0003\t\u0011\r51Q\u0001a\u0001\u0007\u001f\t!\u0002]1si&$\u0018n\u001c8t!\u0015\u0011)c!\u0005w\u0013\u0011\u0019\u0019Ba\r\u0003\u0011%#XM]1cY\u0016Dqaa\u0006\u0001\r#\u0019I\"A\fck&dG\rT3bI\u0016\u0014X\t]8dQJ+\u0017/^3tiR!11DB\u0012!\u0011Yek!\b\u0011\u000bE\u001cyB^\u0017\n\u0007\r\u0005\"OA\u0002NCBD\u0001b!\n\u0004\u0016\u0001\u00071qE\u0001\u000eC2d\u0007+\u0019:uSRLwN\\:\u0011\r\t\u00152\u0011FB\u0017\u0013\u0011\u0019YCa\r\u0003\u0007M+\u0017\u000f\u0005\u0004/\u0003\u001b4(q\u000f\u0005\b\u0007c\u0001a\u0011CB\u001a\u0003U1W\r^2i\u000bB|7\r[:Ge>lG*Z1eKJ$Ba!\u000e\u0004DA1\u0011oa\bw\u0007o\u0001Ba!\u000f\u0004@5\u001111\b\u0006\u0004\u0007{A\u0018\u0001\u0003:fcV,7\u000f^:\n\t\r\u000531\b\u0002\u000f\u000bB|7\r[#oI>3gm]3u\u0011!\u0019iaa\fA\u0002\ru\u0001bBB$\u0001\u0019E1\u0011J\u0001\u000e[\u0006L(-\u001a+sk:\u001c\u0017\r^3\u0015\t\r-3q\n\t\u0005\u0017Z\u001bi\u0005\u0005\u0004r\u0007?1\u0018\u0011 \u0005\t\u0007#\u001a)\u00051\u0001\u00046\u0005ia-\u001a;dQ\u0016$W\t]8dQNDqa!\u0016\u0001\r#\u00199&A\tck&dGMR3uG\"\u0014V-];fgR$Ba!\u0017\u0004^A!1JVB.!\r\u0011Y\u0010\u0012\u0005\t\u0007?\u001a\u0019\u00061\u0001\u0004(\u0005a\u0001/\u0019:uSRLwN\\'ba\"911\r\u0001\u0007\u0012\r\u0015\u0014!\u00024fi\u000eDG\u0003BB4\u0007W\u0002bA!\n\u0004*\r%\u0004C\u0002\u0018\u0002NZ\u0014I\u0010\u0003\u0005\u0004n\r\u0005\u0004\u0019AB.\u000311W\r^2i%\u0016\fX/Z:u\u0011\u001d\u0019\t\b\u0001C!\u0007g\n\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0003\u0005SDqaa\u001e\u0001\t\u0013\u0019I(\u0001\u0004ti\u0006$Xm\u001d\u000b\u0003\u0007w\u0002ba! \u0004\u0004\u000e5RBAB@\u0015\r\u0019\tI]\u0001\b[V$\u0018M\u00197f\u0013\u0011\u0019)ia \u0003\r\t+hMZ3s\u0011\u001d\u0019I\t\u0001C!\u0007g\na\u0001Z8X_J\\\u0007bBB$\u0001\u0011\u000511\u000f\u0005\b\u0007\u001f\u0003A\u0011BBI\u0003M\u0001(o\\2fgN4U\r^2i%\u0016\fX/Z:u)\u0011\u0011Ioa%\t\u0011\r54Q\u0012a\u0001\u00077Bqaa&\u0001\t\u0003\u0019I*A\u000enCJ\\\u0007+\u0019:uSRLwN\\:G_J$&/\u001e8dCRLwN\u001c\u000b\u0007\u0005S\u001cYj!(\t\u000f\t\u00051Q\u0013a\u0001m\"A1qTBK\u0001\u0004\tI0\u0001\tueVt7-\u0019;j_:|eMZ:fi\"911\u0015\u0001\u0005\u0002\r\u0015\u0016!D1eIB\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u0003j\u000e\u001d\u0006\u0002CBU\u0007C\u0003\ra!\u0014\u0002'%t\u0017\u000e^5bY\u001a+Go\u00195PM\u001a\u001cX\r^:\t\u000f\r5\u0006\u0001\"\u0003\u00040\u0006QS.\u0019:l)J,hnY1uS>t7i\\7qY\u0016$X-\u00118e+B$\u0017\r^3GKR\u001c\u0007n\u00144gg\u0016$H\u0003\u0002Bu\u0007cC\u0001ba-\u0004,\u0002\u00071QJ\u0001\rM\u0016$8\r[(gMN,Go\u001d\u0005\b\u0007o\u0003A\u0011AB]\u0003=!W\r\\1z!\u0006\u0014H/\u001b;j_:\u001cHC\u0002Bu\u0007w\u001bi\f\u0003\u0005\u0004\u000e\rU\u0006\u0019AB\b\u0011!\u0019yl!.A\u0002\u0005e\u0018!\u00023fY\u0006L\bbBBb\u0001\u0011\u00051QY\u0001\u0011e\u0016lwN^3QCJ$\u0018\u000e^5p]N$BA!;\u0004H\"91\u0011ZBa\u0001\u0004\u0001\u0018a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\t\u000f\r5\u0007\u0001\"\u0001\u0002\f\u0006q\u0001/\u0019:uSRLwN\\\"pk:$\b\u0002CBi\u0001\u0011\u0005!aa5\u0002)A\f'\u000f^5uS>t7/\u00118e\u001f\u001a47/\u001a;t+\t\u0019)\u000e\u0005\u0004r\u0007?18q\u001b\t\u0004{\re\u0017bABn\u0005\t1\"I]8lKJ\fe\u000eZ%oSRL\u0017\r\\(gMN,G\u000f")
public abstract class AbstractFetcherThread
extends ShutdownableThread {
    private final BrokerEndPoint sourceBroker;
    private final int fetchBackOffMs;
    private final boolean includeLogTruncation;
    private final PartitionStates<PartitionFetchState> partitionStates;
    private final ReentrantLock partitionMapLock;
    private final Condition partitionMapCond;
    private final ClientIdAndBroker metricId;
    private final FetcherStats fetcherStats;
    private final FetcherLagStats fetcherLagStats;

    public static boolean $lessinit$greater$default$5() {
        return AbstractFetcherThread$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return AbstractFetcherThread$.MODULE$.$lessinit$greater$default$4();
    }

    public BrokerEndPoint sourceBroker() {
        return this.sourceBroker;
    }

    public PartitionStates<PartitionFetchState> partitionStates() {
        return this.partitionStates;
    }

    private ReentrantLock partitionMapLock() {
        return this.partitionMapLock;
    }

    private Condition partitionMapCond() {
        return this.partitionMapCond;
    }

    private ClientIdAndBroker metricId() {
        return this.metricId;
    }

    public FetcherStats fetcherStats() {
        return this.fetcherStats;
    }

    public FetcherLagStats fetcherLagStats() {
        return this.fetcherLagStats;
    }

    public abstract void processPartitionData(TopicPartition var1, long var2, PartitionData var4);

    public abstract long handleOffsetOutOfRange(TopicPartition var1);

    public abstract void handlePartitionsWithErrors(Iterable<TopicPartition> var1);

    public abstract ResultWithPartitions<Map<TopicPartition, Object>> buildLeaderEpochRequest(Seq<Tuple2<TopicPartition, PartitionFetchState>> var1);

    public abstract Map<TopicPartition, EpochEndOffset> fetchEpochsFromLeader(Map<TopicPartition, Object> var1);

    public abstract ResultWithPartitions<Map<TopicPartition, Object>> maybeTruncate(Map<TopicPartition, EpochEndOffset> var1);

    public abstract ResultWithPartitions<FetchRequest> buildFetchRequest(Seq<Tuple2<TopicPartition, PartitionFetchState>> var1);

    public abstract Seq<Tuple2<TopicPartition, PartitionData>> fetch(FetchRequest var1);

    @Override
    public void shutdown() {
        this.initiateShutdown();
        CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (JFunction0$mcV$sp & scala.Serializable)() -> this.partitionMapCond().signalAll());
        this.awaitShutdown();
        this.fetcherStats().unregister();
        this.fetcherLagStats().unregister();
    }

    private Buffer<Tuple2<TopicPartition, PartitionFetchState>> states() {
        return ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.partitionStates().partitionStates()).asScala()).map((Function1<PartitionStates.PartitionState, Tuple2> & Serializable & scala.Serializable)state -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(state.topicPartition()), state.value()), Buffer$.MODULE$.canBuildFrom());
    }

    @Override
    public void doWork() {
        block0: {
            this.maybeTruncate();
            FetchRequest fetchRequest = (FetchRequest)CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (Function0<FetchRequest> & Serializable & scala.Serializable)() -> {
                Serializable serializable;
                ResultWithPartitions<FetchRequest> resultWithPartitions = this.buildFetchRequest(this.states());
                if (resultWithPartitions == null) {
                    throw new MatchError(resultWithPartitions);
                }
                FetchRequest fetchRequest = resultWithPartitions.result();
                Set<TopicPartition> partitionsWithError = resultWithPartitions.partitionsWithError();
                Tuple2<FetchRequest, Set<TopicPartition>> tuple2 = new Tuple2<FetchRequest, Set<TopicPartition>>(fetchRequest, partitionsWithError);
                Tuple2<FetchRequest, Set<TopicPartition>> tuple22 = tuple2;
                FetchRequest fetchRequest2 = tuple22._1();
                Set<TopicPartition> partitionsWithError2 = tuple22._2();
                if (fetchRequest2.isEmpty()) {
                    this.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There are no active partitions. Back off for ", " ms before sending a fetch request"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger($this.fetchBackOffMs)})));
                    serializable = BoxesRunTime.boxToBoolean(this.partitionMapCond().await($this.fetchBackOffMs, TimeUnit.MILLISECONDS));
                } else {
                    serializable = BoxedUnit.UNIT;
                }
                this.handlePartitionsWithErrors(partitionsWithError2);
                return fetchRequest2;
            });
            if (fetchRequest.isEmpty()) break block0;
            this.processFetchRequest(fetchRequest);
        }
    }

    public void maybeTruncate() {
        block1: {
            ResultWithPartitions resultWithPartitions = (ResultWithPartitions)CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (Function0<ResultWithPartitions> & Serializable & scala.Serializable)() -> this.buildLeaderEpochRequest(this.states()));
            if (resultWithPartitions == null) {
                throw new MatchError(resultWithPartitions);
            }
            Map epochRequests = (Map)resultWithPartitions.result();
            Set<TopicPartition> partitionsWithError = resultWithPartitions.partitionsWithError();
            Tuple2<Map, Set<TopicPartition>> tuple2 = new Tuple2<Map, Set<TopicPartition>>(epochRequests, partitionsWithError);
            Tuple2<Map, Set<TopicPartition>> tuple22 = tuple2;
            Map epochRequests2 = tuple22._1();
            Set<TopicPartition> partitionsWithError2 = tuple22._2();
            this.handlePartitionsWithErrors(partitionsWithError2);
            if (!epochRequests2.nonEmpty()) break block1;
            Map<TopicPartition, EpochEndOffset> fetchedEpochs = this.fetchEpochsFromLeader(epochRequests2);
            CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (JFunction0$mcV$sp & scala.Serializable)() -> {
                Map leaderEpochs = (Map)fetchedEpochs.filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean(AbstractFetcherThread.$anonfun$maybeTruncate$3(this, x0$1)));
                ResultWithPartitions<Map<TopicPartition, Object>> resultWithPartitions = this.maybeTruncate(leaderEpochs);
                if (resultWithPartitions == null) {
                    throw new MatchError(resultWithPartitions);
                }
                Map<TopicPartition, Object> fetchOffsets = resultWithPartitions.result();
                Set<TopicPartition> partitionsWithError = resultWithPartitions.partitionsWithError();
                Tuple2<Map<TopicPartition, Object>, Set<TopicPartition>> tuple2 = new Tuple2<Map<TopicPartition, Object>, Set<TopicPartition>>(fetchOffsets, partitionsWithError);
                Tuple2<Map<TopicPartition, Object>, Set<TopicPartition>> tuple22 = tuple2;
                Map<TopicPartition, Object> fetchOffsets2 = tuple22._1();
                Set<TopicPartition> partitionsWithError2 = tuple22._2();
                this.handlePartitionsWithErrors(partitionsWithError2);
                this.markTruncationCompleteAndUpdateFetchOffset(fetchOffsets2);
            });
        }
    }

    private void processFetchRequest(FetchRequest fetchRequest) {
        block3: {
            BoxedUnit boxedUnit;
            scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)Set$.MODULE$.apply(Nil$.MODULE$);
            ObjectRef<Seq> responseData = ObjectRef.create((Seq)Seq$.MODULE$.empty());
            try {
                this.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending fetch request ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{fetchRequest})));
                responseData.elem = this.fetch(fetchRequest);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable t) {
                if (this.isRunning()) {
                    this.warn((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error in response for fetch request ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{fetchRequest})), (Function0<Throwable> & Serializable & scala.Serializable)() -> t);
                    boxedUnit = CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (JFunction0$mcZ$sp & scala.Serializable)() -> {
                        partitionsWithError.$plus$plus$eq(JavaConverters$.MODULE$.asScalaSetConverter(this.partitionStates().partitionSet()).asScala());
                        return this.partitionMapCond().await($this.fetchBackOffMs, TimeUnit.MILLISECONDS);
                    });
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            this.fetcherStats().requestRate().mark();
            BoxedUnit boxedUnit2 = ((Seq)responseData.elem).nonEmpty() ? CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (JFunction0$mcV$sp & scala.Serializable)() -> ((Seq)responseData$1.elem).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$2 -> {
                AbstractFetcherThread.$anonfun$processFetchRequest$6(this, fetchRequest, partitionsWithError, x0$2);
                return BoxedUnit.UNIT;
            })) : BoxedUnit.UNIT;
            if (!partitionsWithError.nonEmpty()) break block3;
            this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Handling errors for partitions ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{partitionsWithError})));
            this.handlePartitionsWithErrors(partitionsWithError);
        }
    }

    public void markPartitionsForTruncation(TopicPartition topicPartition, long truncationOffset) {
        if (!this.includeLogTruncation) {
            throw new IllegalStateException("Truncation should not be requested if includeLogTruncation is disabled");
        }
        this.partitionMapLock().lockInterruptibly();
        try {
            Option$.MODULE$.apply(this.partitionStates().stateValue(topicPartition)).foreach((Function1<PartitionFetchState, Object> & Serializable & scala.Serializable)state -> {
                AbstractFetcherThread.$anonfun$markPartitionsForTruncation$1(this, topicPartition, truncationOffset, state);
                return BoxedUnit.UNIT;
            });
            this.partitionMapCond().signalAll();
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    public void addPartitions(Map<TopicPartition, Object> initialFetchOffsets) {
        this.partitionMapLock().lockInterruptibly();
        try {
            Map newPartitionToState = ((TraversableLike)initialFetchOffsets.filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean(AbstractFetcherThread.$anonfun$addPartitions$1(this, x0$3)))).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                long initialFetchOffset = tuple2._2$mcJ$sp();
                PartitionFetchState fetchState = initialFetchOffset < 0L ? new PartitionFetchState(this.handleOffsetOutOfRange(tp), $this.includeLogTruncation) : new PartitionFetchState(initialFetchOffset, $this.includeLogTruncation);
                Tuple2<TopicPartition, PartitionFetchState> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), fetchState);
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            scala.collection.immutable.Map existingPartitionToState = this.states().toMap(Predef$.MODULE$.$conforms());
            this.partitionStates().set(JavaConverters$.MODULE$.mapAsJavaMapConverter(existingPartitionToState.$plus$plus(newPartitionToState)).asJava());
            this.partitionMapCond().signalAll();
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    private void markTruncationCompleteAndUpdateFetchOffset(Map<TopicPartition, Object> fetchOffsets) {
        scala.collection.immutable.Map newStates = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.partitionStates().partitionStates()).asScala()).map((Function1<PartitionStates.PartitionState, Tuple2> & Serializable & scala.Serializable)state -> {
            PartitionFetchState partitionFetchState;
            Option option = fetchOffsets.get(state.topicPartition());
            if (option instanceof Some) {
                Some some = (Some)option;
                long offset = BoxesRunTime.unboxToLong(some.value());
                partitionFetchState = new PartitionFetchState(offset, ((PartitionFetchState)state.value()).delay(), false);
            } else if (None$.MODULE$.equals(option)) {
                partitionFetchState = (PartitionFetchState)state.value();
            } else {
                throw new MatchError(option);
            }
            PartitionFetchState maybeTruncationComplete = partitionFetchState;
            return new Tuple2<TopicPartition, PartitionFetchState>(state.topicPartition(), maybeTruncationComplete);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.partitionStates().set(JavaConverters$.MODULE$.mapAsJavaMapConverter(newStates).asJava());
    }

    public void delayPartitions(Iterable<TopicPartition> partitions, long delay) {
        this.partitionMapLock().lockInterruptibly();
        try {
            partitions.foreach((Function1<TopicPartition, Object> & Serializable & scala.Serializable)partition -> {
                AbstractFetcherThread.$anonfun$delayPartitions$1(this, delay, partition);
                return BoxedUnit.UNIT;
            });
            this.partitionMapCond().signalAll();
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    public void removePartitions(Set<TopicPartition> topicPartitions) {
        this.partitionMapLock().lockInterruptibly();
        try {
            topicPartitions.foreach((Function1<TopicPartition, Object> & Serializable & scala.Serializable)topicPartition -> {
                AbstractFetcherThread.$anonfun$removePartitions$1(this, topicPartition);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    public int partitionCount() {
        int n;
        this.partitionMapLock().lockInterruptibly();
        try {
            n = this.partitionStates().size();
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return n;
    }

    public Map<TopicPartition, BrokerAndInitialOffset> partitionsAndOffsets() {
        return (Map)CoreUtils$.MODULE$.inLock(this.partitionMapLock(), (Function0<scala.collection.immutable.Map> & Serializable & scala.Serializable)() -> ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.partitionStates().partitionStates()).asScala()).map((Function1<PartitionStates.PartitionState, Tuple2> & Serializable & scala.Serializable)x0$5 -> {
            PartitionStates.PartitionState partitionState = x0$5;
            Tuple2<TopicPartition, BrokerAndInitialOffset> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partitionState.topicPartition()), new BrokerAndInitialOffset(this.sourceBroker(), ((PartitionFetchState)partitionState.value()).fetchOffset()));
            return tuple2;
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    public static final /* synthetic */ boolean $anonfun$maybeTruncate$3(AbstractFetcherThread $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        boolean bl = $this.partitionStates().contains(tp);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$processFetchRequest$6(AbstractFetcherThread $this, FetchRequest fetchRequest$1, scala.collection.mutable.Set partitionsWithError$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        PartitionData partitionData = (PartitionData)tuple2._2();
        String topic = topicPartition.topic();
        int partitionId = topicPartition.partition();
        Option$.MODULE$.apply($this.partitionStates().stateValue(topicPartition)).foreach((Function1<PartitionFetchState, Object> & Serializable & scala.Serializable)currentPartitionFetchState -> {
            Object object;
            if (fetchRequest$1.offset(topicPartition) == currentPartitionFetchState.fetchOffset() && currentPartitionFetchState.isReadyForFetch()) {
                SetLike setLike;
                Errors errors = partitionData.error();
                if (((Object)((Object)Errors.NONE)).equals((Object)errors)) {
                    Object object2;
                    try {
                        MemoryRecords records = partitionData.toRecords();
                        long newOffset = BoxesRunTime.unboxToLong(((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).lastOption().map((Function1<MutableRecordBatch, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong(x$4.nextOffset())).getOrElse((JFunction0$mcJ$sp & scala.Serializable)() -> currentPartitionFetchState.fetchOffset()));
                        $this.fetcherLagStats().getAndMaybePut(topic, partitionId).lag_$eq(Math.max(0L, partitionData.highWatermark() - newOffset));
                        $this.processPartitionData(topicPartition, currentPartitionFetchState.fetchOffset(), partitionData);
                        int validBytes = records.validBytes();
                        if (validBytes > 0 && $this.partitionStates().contains(topicPartition)) {
                            $this.partitionStates().updateAndMoveToEnd(topicPartition, new PartitionFetchState(newOffset));
                            $this.fetcherStats().byteRate().mark(validBytes);
                            object2 = BoxedUnit.UNIT;
                        } else {
                            object2 = BoxedUnit.UNIT;
                        }
                    }
                    catch (CorruptRecordException ime) {
                        $this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found invalid messages during fetch for partition ", " offset ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topicPartition, BoxesRunTime.boxToLong(currentPartitionFetchState.fetchOffset())})), (Function0<Throwable>)(Function0<CorruptRecordException> & Serializable & scala.Serializable)() -> ime);
                        object2 = partitionsWithError$1.$plus$eq(topicPartition);
                    }
                    catch (KafkaStorageException e) {
                        $this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while processing data for partition ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topicPartition})), (Function0<Throwable>)(Function0<KafkaStorageException> & Serializable & scala.Serializable)() -> e);
                        object2 = partitionsWithError$1.$plus$eq(topicPartition);
                    }
                    catch (Throwable e) {
                        throw new KafkaException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing data for partition ", " "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topicPartition})) + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offset ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(currentPartitionFetchState.fetchOffset())})), e);
                    }
                    setLike = object2;
                } else if (((Object)((Object)Errors.OFFSET_OUT_OF_RANGE)).equals((Object)errors)) {
                    Object object3;
                    try {
                        long newOffset = $this.handleOffsetOutOfRange(topicPartition);
                        $this.partitionStates().updateAndMoveToEnd(topicPartition, new PartitionFetchState(newOffset));
                        $this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Current offset ", " for partition ", " is "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(currentPartitionFetchState.fetchOffset()), topicPartition})) + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"out of range, which typically implies a leader change. Reset fetch offset to ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(newOffset)})));
                        object3 = BoxedUnit.UNIT;
                    }
                    catch (FatalExitError e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        $this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error getting offset for partition ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topicPartition})), (Function0<Throwable> & Serializable & scala.Serializable)() -> e);
                        object3 = partitionsWithError$1.$plus$eq(topicPartition);
                    }
                    setLike = object3;
                } else if (((Object)((Object)Errors.NOT_LEADER_FOR_PARTITION)).equals((Object)errors)) {
                    $this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Remote broker is not the leader for partition ", ", which could indicate "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topicPartition})) + "that the partition is being moved");
                    setLike = partitionsWithError$1.$plus$eq(topicPartition);
                } else {
                    $this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error for partition ", " at offset ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topicPartition, BoxesRunTime.boxToLong(currentPartitionFetchState.fetchOffset())})), (Function0<Throwable> & Serializable & scala.Serializable)() -> partitionData.exception().get());
                    setLike = partitionsWithError$1.$plus$eq(topicPartition);
                }
                object = setLike;
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$markPartitionsForTruncation$1(AbstractFetcherThread $this, TopicPartition topicPartition$1, long truncationOffset$1, PartitionFetchState state) {
        PartitionFetchState newState = new PartitionFetchState(package$.MODULE$.min(truncationOffset$1, state.fetchOffset()), state.delay(), true);
        $this.partitionStates().updateAndMoveToEnd(topicPartition$1, newState);
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$1(AbstractFetcherThread $this, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        boolean bl = !$this.partitionStates().contains(tp);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$delayPartitions$2(AbstractFetcherThread $this, long delay$1, TopicPartition partition$1, PartitionFetchState currentPartitionFetchState) {
        block0: {
            if (currentPartitionFetchState.isDelayed()) break block0;
            $this.partitionStates().updateAndMoveToEnd(partition$1, new PartitionFetchState(currentPartitionFetchState.fetchOffset(), new DelayedItem(delay$1), currentPartitionFetchState.truncatingLog()));
        }
    }

    public static final /* synthetic */ void $anonfun$delayPartitions$1(AbstractFetcherThread $this, long delay$1, TopicPartition partition) {
        Option$.MODULE$.apply($this.partitionStates().stateValue(partition)).foreach((Function1<PartitionFetchState, Object> & Serializable & scala.Serializable)currentPartitionFetchState -> {
            AbstractFetcherThread.$anonfun$delayPartitions$2($this, delay$1, partition, currentPartitionFetchState);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removePartitions$1(AbstractFetcherThread $this, TopicPartition topicPartition) {
        $this.partitionStates().remove(topicPartition);
        $this.fetcherLagStats().unregister(topicPartition.topic(), topicPartition.partition());
    }

    public AbstractFetcherThread(String name, String clientId, BrokerEndPoint sourceBroker, int fetchBackOffMs, boolean isInterruptible, boolean includeLogTruncation) {
        this.sourceBroker = sourceBroker;
        this.fetchBackOffMs = fetchBackOffMs;
        this.includeLogTruncation = includeLogTruncation;
        super(name, isInterruptible);
        this.partitionStates = new PartitionStates();
        this.partitionMapLock = new ReentrantLock();
        this.partitionMapCond = this.partitionMapLock().newCondition();
        this.metricId = new ClientIdAndBroker(clientId, sourceBroker.host(), sourceBroker.port());
        this.fetcherStats = new FetcherStats(this.metricId());
        this.fetcherLagStats = new FetcherLagStats(this.metricId());
    }

    public static interface FetchRequest {
        public boolean isEmpty();

        public long offset(TopicPartition var1);
    }

    public static interface PartitionData {
        public Errors error();

        public Option<Throwable> exception();

        public MemoryRecords toRecords();

        public long highWatermark();
    }

    public static class ResultWithPartitions<R>
    implements Product,
    scala.Serializable {
        private final R result;
        private final Set<TopicPartition> partitionsWithError;

        public R result() {
            return this.result;
        }

        public Set<TopicPartition> partitionsWithError() {
            return this.partitionsWithError;
        }

        public <R> ResultWithPartitions<R> copy(R result2, Set<TopicPartition> partitionsWithError) {
            return new ResultWithPartitions<R>(result2, partitionsWithError);
        }

        public <R> R copy$default$1() {
            return this.result();
        }

        public <R> Set<TopicPartition> copy$default$2() {
            return this.partitionsWithError();
        }

        @Override
        public String productPrefix() {
            return "ResultWithPartitions";
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.result();
                    break;
                }
                case 1: {
                    object = this.partitionsWithError();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(x$1)).toString());
                }
            }
            return object;
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof ResultWithPartitions;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ResultWithPartitions)) return false;
            boolean bl = true;
            if (!bl) return false;
            ResultWithPartitions resultWithPartitions = (ResultWithPartitions)x$1;
            if (!BoxesRunTime.equals(this.result(), resultWithPartitions.result())) return false;
            Set<TopicPartition> set = this.partitionsWithError();
            Set<TopicPartition> set2 = resultWithPartitions.partitionsWithError();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            if (!resultWithPartitions.canEqual(this)) return false;
            return true;
        }

        public ResultWithPartitions(R result2, Set<TopicPartition> partitionsWithError) {
            this.result = result2;
            this.partitionsWithError = partitionsWithError;
            Product.$init$(this);
        }
    }
}

