/*
 * Decompiled with CFR 0.152.
 */
package kafka.security;

import java.io.Serializable;
import kafka.security.auth.Acl;
import kafka.security.auth.Operation;
import kafka.security.auth.Operation$;
import kafka.security.auth.PermissionType;
import kafka.security.auth.PermissionType$;
import kafka.security.auth.Resource;
import kafka.security.auth.ResourceType;
import kafka.security.auth.ResourceType$;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple3;
import scala.package$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class SecurityUtils$ {
    public static SecurityUtils$ MODULE$;

    static {
        new SecurityUtils$();
    }

    public Either<ApiError, Tuple2<Resource, Acl>> convertToResourceAndAcl(AclBindingFilter filter) {
        Left<ApiError, Tuple2<Resource, Acl>> left;
        Try try_ = Try$.MODULE$.apply((Function0<ResourceType> & Serializable & scala.Serializable)() -> ResourceType$.MODULE$.fromJava(filter.resourceFilter().resourceType())).flatMap((Function1<ResourceType, Try> & Serializable & scala.Serializable)resourceType -> Try$.MODULE$.apply((Function0<KafkaPrincipal> & Serializable & scala.Serializable)() -> KafkaPrincipal.fromString(filter.entryFilter().principal())).flatMap((Function1<KafkaPrincipal, Try> & Serializable & scala.Serializable)principal -> Try$.MODULE$.apply((Function0<Operation> & Serializable & scala.Serializable)() -> Operation$.MODULE$.fromJava(filter.entryFilter().operation())).flatMap((Function1<Operation, Try> & Serializable & scala.Serializable)operation -> Try$.MODULE$.apply((Function0<PermissionType> & Serializable & scala.Serializable)() -> PermissionType$.MODULE$.fromJava(filter.entryFilter().permissionType())).map((Function1<PermissionType, Tuple3> & Serializable & scala.Serializable)permissionType -> {
            Resource resource = new Resource((ResourceType)resourceType, filter.resourceFilter().name());
            Acl acl = new Acl((KafkaPrincipal)principal, (PermissionType)permissionType, filter.entryFilter().host(), (Operation)operation);
            return new Tuple3<PermissionType, Resource, Acl>((PermissionType)permissionType, resource, acl);
        }).map((Function1<Tuple3, Tuple2> & Serializable & scala.Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            Resource resource = (Resource)tuple3._2();
            Acl acl = (Acl)tuple3._3();
            Tuple2<Resource, Acl> tuple2 = new Tuple2<Resource, Acl>(resource, acl);
            return tuple2;
        }))));
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable throwable = failure.exception();
            left = package$.MODULE$.Left().apply(new ApiError(Errors.INVALID_REQUEST, throwable.getMessage()));
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            Tuple2 s = (Tuple2)success.value();
            left = package$.MODULE$.Right().apply(s);
        } else {
            throw new MatchError(try_);
        }
        return left;
    }

    public AclBinding convertToAclBinding(Resource resource, Acl acl) {
        org.apache.kafka.common.resource.Resource adminResource = new org.apache.kafka.common.resource.Resource(resource.resourceType().toJava(), resource.name());
        AccessControlEntry entry = new AccessControlEntry(acl.principal().toString(), acl.host().toString(), acl.operation().toJava(), acl.permissionType().toJava());
        return new AclBinding(adminResource, entry);
    }

    private SecurityUtils$() {
        MODULE$ = this;
    }
}

