/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.api.PartitionMetadata;
import kafka.api.TopicMetadata;
import kafka.api.TopicMetadataResponse;
import kafka.client.ClientUtils$;
import kafka.cluster.BrokerEndPoint;
import kafka.common.KafkaException;
import kafka.producer.PartitionAndLeader;
import kafka.producer.ProducerConfig;
import kafka.producer.ProducerPool;
import kafka.utils.Logging;
import org.apache.kafka.common.protocol.Errors;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001y4A!\u0001\u0002\u0001\u000f\t\u0019\"I]8lKJ\u0004\u0016M\u001d;ji&|g.\u00138g_*\u00111\u0001B\u0001\taJ|G-^2fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001Aa\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tQ!\u001e;jYNL!a\u0005\t\u0003\u000f1{wmZ5oO\"AQ\u0003\u0001B\u0001B\u0003%a#\u0001\bqe>$WoY3s\u0007>tg-[4\u0011\u0005]AR\"\u0001\u0002\n\u0005e\u0011!A\u0004)s_\u0012,8-\u001a:D_:4\u0017n\u001a\u0005\t7\u0001\u0011\t\u0011)A\u00059\u0005a\u0001O]8ek\u000e,'\u000fU8pYB\u0011q#H\u0005\u0003=\t\u0011A\u0002\u0015:pIV\u001cWM\u001d)p_2D\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!I\u0001\u0013i>\u0004\u0018n\u0019)beRLG/[8o\u0013:4w\u000e\u0005\u0003#O%\"T\"A\u0012\u000b\u0005\u0011*\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0003M)\t!bY8mY\u0016\u001cG/[8o\u0013\tA3EA\u0004ICNDW*\u00199\u0011\u0005)\ndBA\u00160!\ta#\"D\u0001.\u0015\tqc!\u0001\u0004=e>|GOP\u0005\u0003a)\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001a4\u0005\u0019\u0019FO]5oO*\u0011\u0001G\u0003\t\u0003kaj\u0011A\u000e\u0006\u0003o\u0011\t1!\u00199j\u0013\tIdGA\u0007U_BL7-T3uC\u0012\fG/\u0019\u0005\u0006w\u0001!\t\u0001P\u0001\u0007y%t\u0017\u000e\u001e \u0015\turt\b\u0011\t\u0003/\u0001AQ!\u0006\u001eA\u0002YAQa\u0007\u001eA\u0002qAQ\u0001\t\u001eA\u0002\u0005BqA\u0011\u0001C\u0002\u0013\u00051)\u0001\u0006ce>\\WM\u001d'jgR,\u0012!\u000b\u0005\u0007\u000b\u0002\u0001\u000b\u0011B\u0015\u0002\u0017\t\u0014xn[3s\u0019&\u001cH\u000f\t\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0003\u001d\u0011'o\\6feN,\u0012!\u0013\t\u0004\u0015.kU\"A\u0013\n\u00051+#aA*fcB\u0011a*U\u0007\u0002\u001f*\u0011\u0001\u000bB\u0001\bG2,8\u000f^3s\u0013\t\u0011vJ\u0001\bCe>\\WM]#oIB{\u0017N\u001c;\t\rQ\u0003\u0001\u0015!\u0003J\u0003!\u0011'o\\6feN\u0004\u0003\"\u0002,\u0001\t\u00039\u0016AF4fi\n\u0013xn[3s!\u0006\u0014H/\u001b;j_:LeNZ8\u0015\u0007a\u001bW\rE\u0002Z=\u0002t!A\u0017/\u000f\u00051Z\u0016\"A\u0006\n\u0005uS\u0011a\u00029bG.\fw-Z\u0005\u0003\u0019~S!!\u0018\u0006\u0011\u0005]\t\u0017B\u00012\u0003\u0005I\u0001\u0016M\u001d;ji&|g.\u00118e\u0019\u0016\fG-\u001a:\t\u000b\u0011,\u0006\u0019A\u0015\u0002\u000bQ|\u0007/[2\t\u000b\u0019,\u0006\u0019A4\u0002\u001b\r|'O]3mCRLwN\\%e!\tI\u0001.\u0003\u0002j\u0015\t\u0019\u0011J\u001c;\t\u000b-\u0004A\u0011\u00017\u0002\u0015U\u0004H-\u0019;f\u0013:4w\u000eF\u0002naV\u0004\"!\u00038\n\u0005=T!\u0001B+oSRDQ!\u001d6A\u0002I\fa\u0001^8qS\u000e\u001c\bc\u0001\u0016tS%\u0011Ao\r\u0002\u0004'\u0016$\b\"\u00024k\u0001\u00049\u0007\u0006\u0002\u0001xur\u0004\"!\u0003=\n\u0005eT!A\u00033faJ,7-\u0019;fI\u0006\n10A$UQ&\u001c\be\u00197bgN\u0004\u0003.Y:!E\u0016,g\u000e\t3faJ,7-\u0019;fI\u0002\ng\u000e\u001a\u0011xS2d\u0007EY3!e\u0016lwN^3eA%t\u0007%\u0019\u0011gkR,(/\u001a\u0011sK2,\u0017m]3/C\u0005i\u0018\u0001\u0003\u0019/cAr\u0003G\f\u0019")
public class BrokerPartitionInfo
implements Logging {
    private final ProducerConfig producerConfig;
    private final ProducerPool producerPool;
    private final HashMap<String, TopicMetadata> topicPartitionInfo;
    private final String brokerList;
    private final Seq<BrokerEndPoint> brokers;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        BrokerPartitionInfo brokerPartitionInfo = this;
        synchronized (brokerPartitionInfo) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String brokerList() {
        return this.brokerList;
    }

    public Seq<BrokerEndPoint> brokers() {
        return this.brokers;
    }

    public Seq<PartitionAndLeader> getBrokerPartitionInfo(String topic, int correlationId) {
        TopicMetadata topicMetadata;
        Option<TopicMetadata> topicMetadata2;
        this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Getting broker partition info for topic %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
        Option<TopicMetadata> option = topicMetadata2 = this.topicPartitionInfo.get(topic);
        if (option instanceof Some) {
            TopicMetadata m2;
            Some some = (Some)option;
            topicMetadata = m2 = (TopicMetadata)some.value();
        } else if (None$.MODULE$.equals(option)) {
            TopicMetadata m3;
            Option<TopicMetadata> topicMetadata3;
            this.updateInfo((Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), correlationId);
            Option<TopicMetadata> option2 = topicMetadata3 = this.topicPartitionInfo.get(topic);
            if (!(option2 instanceof Some)) {
                if (None$.MODULE$.equals(option2)) {
                    throw new KafkaException("Failed to fetch topic metadata for topic: " + topic);
                }
                throw new MatchError(option2);
            }
            Some some = (Some)option2;
            TopicMetadata topicMetadata4 = m3 = (TopicMetadata)some.value();
            topicMetadata = topicMetadata4;
        } else {
            throw new MatchError(option);
        }
        TopicMetadata metadata = topicMetadata;
        Seq<PartitionMetadata> partitionMetadata = metadata.partitionsMetadata();
        if (partitionMetadata.isEmpty()) {
            Errors errors = metadata.error();
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !((Object)((Object)errors)).equals((Object)errors2)) {
                throw new KafkaException(metadata.error().exception());
            }
            throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Topic metadata %s has empty partition metadata and no error code")).format(Predef$.MODULE$.genericWrapArray(new Object[]{metadata})));
        }
        return (Seq)((SeqLike)partitionMetadata.map((Function1<PartitionMetadata, PartitionAndLeader> & Serializable & scala.Serializable)m -> {
            PartitionAndLeader partitionAndLeader;
            Option<BrokerEndPoint> option = m.leader();
            if (option instanceof Some) {
                Some some = (Some)option;
                BrokerEndPoint leader = (BrokerEndPoint)some.value();
                this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Partition [%s,%d] has leader %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic, BoxesRunTime.boxToInteger(m.partitionId()), BoxesRunTime.boxToInteger(leader.id())})));
                partitionAndLeader = new PartitionAndLeader(topic, m.partitionId(), new Some<Object>(BoxesRunTime.boxToInteger(leader.id())));
            } else if (None$.MODULE$.equals(option)) {
                this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Partition [%s,%d] does not have a leader yet")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic, BoxesRunTime.boxToInteger(m.partitionId())})));
                partitionAndLeader = new PartitionAndLeader(topic, m.partitionId(), None$.MODULE$);
            } else {
                throw new MatchError(option);
            }
            return partitionAndLeader;
        }, Seq$.MODULE$.canBuildFrom())).sortWith((Function2<PartitionAndLeader, PartitionAndLeader, Object> & Serializable & scala.Serializable)(s, t) -> BoxesRunTime.boxToBoolean(BrokerPartitionInfo.$anonfun$getBrokerPartitionInfo$5(s, t)));
    }

    public void updateInfo(Set<String> topics, int correlationId) {
        Seq<Nothing$> topicsMetadata = Nil$.MODULE$;
        TopicMetadataResponse topicMetadataResponse = ClientUtils$.MODULE$.fetchTopicMetadata(topics, this.brokers(), this.producerConfig, correlationId);
        topicsMetadata = topicMetadataResponse.topicsMetadata();
        topicsMetadata.foreach((Function1<TopicMetadata, Object> & Serializable & scala.Serializable)tmd -> {
            BrokerPartitionInfo.$anonfun$updateInfo$1(this, tmd);
            return BoxedUnit.UNIT;
        });
        this.producerPool.updateProducer(topicsMetadata);
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerPartitionInfo$5(PartitionAndLeader s, PartitionAndLeader t) {
        return s.partitionId() < t.partitionId();
    }

    public static final /* synthetic */ void $anonfun$updateInfo$4(BrokerPartitionInfo $this, TopicMetadata tmd$1, PartitionMetadata pmd) {
        block1: {
            Errors errors = pmd.error();
            Errors errors2 = Errors.NONE;
            if (!(errors == null ? errors2 != null : !((Object)((Object)errors)).equals((Object)errors2))) break block1;
            Errors errors3 = pmd.error();
            Errors errors4 = Errors.LEADER_NOT_AVAILABLE;
            if (!(errors3 != null ? !((Object)((Object)errors3)).equals((Object)errors4) : errors4 != null)) {
                $this.warn((Function0<String> & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Error while fetching metadata %s for topic partition [%s,%d]: [%s]")).format(Predef$.MODULE$.genericWrapArray(new Object[]{pmd, tmd$1.topic(), BoxesRunTime.boxToInteger(pmd.partitionId()), pmd.error().exception().getClass()})));
            }
        }
    }

    public static final /* synthetic */ void $anonfun$updateInfo$1(BrokerPartitionInfo $this, TopicMetadata tmd) {
        Serializable serializable;
        $this.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Metadata for topic %s is %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{tmd.topic(), tmd})));
        Errors errors = tmd.error();
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !((Object)((Object)errors)).equals((Object)errors2) : errors2 != null)) {
            serializable = $this.topicPartitionInfo.put(tmd.topic(), tmd);
        } else {
            $this.warn((Function0<String> & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Error while fetching metadata [%s] for topic [%s]: %s ")).format(Predef$.MODULE$.genericWrapArray(new Object[]{tmd, tmd.topic(), tmd.error().exception().getClass()})));
            serializable = BoxedUnit.UNIT;
        }
        tmd.partitionsMetadata().foreach((Function1<PartitionMetadata, Object> & Serializable & scala.Serializable)pmd -> {
            BrokerPartitionInfo.$anonfun$updateInfo$4($this, tmd, pmd);
            return BoxedUnit.UNIT;
        });
    }

    public BrokerPartitionInfo(ProducerConfig producerConfig, ProducerPool producerPool, HashMap<String, TopicMetadata> topicPartitionInfo) {
        this.producerConfig = producerConfig;
        this.producerPool = producerPool;
        this.topicPartitionInfo = topicPartitionInfo;
        Logging.$init$(this);
        this.brokerList = producerConfig.brokerList();
        this.brokers = ClientUtils$.MODULE$.parseBrokerList(this.brokerList());
    }
}

