/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.io.Serializable;
import kafka.consumer.Blacklist;
import kafka.consumer.ConsumerThreadId;
import kafka.consumer.TopicCount;
import kafka.consumer.TopicCount$;
import kafka.consumer.TopicFilter;
import kafka.consumer.Whitelist;
import kafka.utils.CoreUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t4Q!\u0001\u0002\u0001\t\u0019\u0011!cV5mI\u000e\f'\u000f\u001a+pa&\u001c7i\\;oi*\u00111\u0001B\u0001\tG>t7/^7fe*\tQ!A\u0003lC\u001a\\\u0017mE\u0002\u0001\u000f5\u0001\"\u0001C\u0006\u000e\u0003%Q\u0011AC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0019%\u0011a!\u00118z%\u00164\u0007C\u0001\b\u0010\u001b\u0005\u0011\u0011B\u0001\t\u0003\u0005)!v\u000e]5d\u0007>,h\u000e\u001e\u0005\t%\u0001\u0011\t\u0011)A\u0005)\u00059!p[+uS2\u001c8\u0001\u0001\t\u0003+ai\u0011A\u0006\u0006\u0003/\u0011\tQ!\u001e;jYNL!!\u0007\f\u0003\u000fi[W\u000b^5mg\"A1\u0004\u0001B\u0001B\u0003%A$\u0001\td_:\u001cX/\\3s\u0013\u0012\u001cFO]5oOB\u0011Q\u0004\n\b\u0003=\t\u0002\"aH\u0005\u000e\u0003\u0001R!!I\n\u0002\rq\u0012xn\u001c;?\u0013\t\u0019\u0013\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003K\u0019\u0012aa\u0015;sS:<'BA\u0012\n\u0011!A\u0003A!A!\u0002\u0013I\u0013a\u0003;pa&\u001cg)\u001b7uKJ\u0004\"A\u0004\u0016\n\u0005-\u0012!a\u0003+pa&\u001cg)\u001b7uKJD\u0001\"\f\u0001\u0003\u0002\u0003\u0006IAL\u0001\u000b]Vl7\u000b\u001e:fC6\u001c\bC\u0001\u00050\u0013\t\u0001\u0014BA\u0002J]RD\u0001B\r\u0001\u0003\u0002\u0003\u0006IaM\u0001\u0016Kb\u001cG.\u001e3f\u0013:$XM\u001d8bYR{\u0007/[2t!\tAA'\u0003\u00026\u0013\t9!i\\8mK\u0006t\u0007\"B\u001c\u0001\t\u0003A\u0014A\u0002\u001fj]&$h\b\u0006\u0004:umbTH\u0010\t\u0003\u001d\u0001AQA\u0005\u001cA\u0002QAQa\u0007\u001cA\u0002qAQ\u0001\u000b\u001cA\u0002%BQ!\f\u001cA\u00029BQA\r\u001cA\u0002MBQ\u0001\u0011\u0001\u0005\u0002\u0005\u000bAdZ3u\u0007>t7/^7feRC'/Z1e\u0013\u0012\u001c\b+\u001a:U_BL7-F\u0001C!\u0011\u0019\u0005\n\b&\u000e\u0003\u0011S!!\u0012$\u0002\u000f5,H/\u00192mK*\u0011q)C\u0001\u000bG>dG.Z2uS>t\u0017BA%E\u0005\u001dA\u0015m\u001d5NCB\u00042a\u0013'O\u001b\u00051\u0015BA'G\u0005\r\u0019V\r\u001e\t\u0003\u001d=K!\u0001\u0015\u0002\u0003!\r{gn];nKJ$\u0006N]3bI&#\u0007\"\u0002*\u0001\t\u0003\u0019\u0016\u0001E4fiR{\u0007/[2D_VtG/T1q+\u0005!\u0006\u0003B&V99J!A\u0016$\u0003\u00075\u000b\u0007\u000fC\u0003Y\u0001\u0011\u0005\u0011,A\u0004qCR$XM\u001d8\u0016\u0003qAC\u0001A._AB\u0011\u0001\u0002X\u0005\u0003;&\u0011!\u0002Z3qe\u0016\u001c\u0017\r^3eC\u0005y\u0016a\u0012+iSN\u00043\r\\1tg\u0002B\u0017m\u001d\u0011cK\u0016t\u0007\u0005Z3qe\u0016\u001c\u0017\r^3eA\u0005tG\rI<jY2\u0004#-\u001a\u0011sK6|g/\u001a3!S:\u0004\u0013\r\t4viV\u0014X\r\t:fY\u0016\f7/\u001a\u0018\"\u0003\u0005\f\u0001\u0002\r\u00182c9\u0002d\u0006\r")
public class WildcardTopicCount
implements TopicCount {
    private final ZkUtils zkUtils;
    private final String consumerIdString;
    private final TopicFilter topicFilter;
    private final int numStreams;
    private final boolean excludeInternalTopics;

    public HashMap<String, Set<ConsumerThreadId>> getConsumerThreadIdsPerTopic() {
        Seq wildcardTopics = (Seq)this.zkUtils.getChildrenParentMayNotExist(ZkUtils$.MODULE$.BrokerTopicsPath()).filter((Function1<String, Object> & Serializable & scala.Serializable)topic -> BoxesRunTime.boxToBoolean(this.topicFilter.isTopicAllowed(topic, this.excludeInternalTopics)));
        return TopicCount$.MODULE$.makeConsumerThreadIdsPerTopic(this.consumerIdString, (Map)Map$.MODULE$.apply(wildcardTopics.map((Function1<String, Tuple2> & Serializable & scala.Serializable)x$2 -> new Tuple2<String, Integer>((String)x$2, BoxesRunTime.boxToInteger($this.numStreams)), Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    public Map<String, Object> getTopicCountMap() {
        return (Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(CoreUtils$.MODULE$.JSONEscapeString(this.topicFilter.regex())), BoxesRunTime.boxToInteger(this.numStreams))}));
    }

    @Override
    public String pattern() {
        String string;
        TopicFilter topicFilter = this.topicFilter;
        if (topicFilter instanceof Whitelist) {
            string = TopicCount$.MODULE$.whiteListPattern();
        } else if (topicFilter instanceof Blacklist) {
            string = TopicCount$.MODULE$.blackListPattern();
        } else {
            throw new MatchError(topicFilter);
        }
        return string;
    }

    public WildcardTopicCount(ZkUtils zkUtils, String consumerIdString, TopicFilter topicFilter, int numStreams, boolean excludeInternalTopics) {
        this.zkUtils = zkUtils;
        this.consumerIdString = consumerIdString;
        this.topicFilter = topicFilter;
        this.numStreams = numStreams;
        this.excludeInternalTopics = excludeInternalTopics;
    }
}

