/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kafka.common.InterBrokerSendThread$;
import kafka.common.RequestAndCompletionHandler;
import kafka.common.UnsentRequests;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005mb!B\u0001\u0003\u0003\u00039!!F%oi\u0016\u0014(I]8lKJ\u001cVM\u001c3UQJ,\u0017\r\u001a\u0006\u0003\u0007\u0011\taaY8n[>t'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\tQ!\u001e;jYNL!!\u0004\u0006\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\u0005\n\u001f\u0001\u0011\t\u0011)A\u0005!u\tAA\\1nKB\u0011\u0011C\u0007\b\u0003%a\u0001\"a\u0005\f\u000e\u0003QQ!!\u0006\u0004\u0002\rq\u0012xn\u001c;?\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0003\u0019\u0001&/\u001a3fM&\u00111\u0004\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005e1\u0012BA\b\r\u0011!y\u0002A!A!\u0002\u0013\u0001\u0013!\u00048fi^|'o[\"mS\u0016tG\u000f\u0005\u0002\"S5\t!E\u0003\u0002$I\u000591\r\\5f]R\u001c(BA\u0003&\u0015\t1s%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Q\u0005\u0019qN]4\n\u0005)\u0012#!\u0004(fi^|'o[\"mS\u0016tG\u000f\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003.\u0003\u0011!\u0018.\\3\u0011\u00059\nT\"A\u0018\u000b\u0005-\u0001$BA\u0002%\u0013\t\u0011tF\u0001\u0003US6,\u0007\"\u0003\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u001b:\u0003=I7/\u00138uKJ\u0014X\u000f\u001d;jE2,\u0007C\u0001\u001c8\u001b\u00051\u0012B\u0001\u001d\u0017\u0005\u001d\u0011un\u001c7fC:L!\u0001\u000e\u0007\t\u000bm\u0002A\u0011\u0001\u001f\u0002\rqJg.\u001b;?)\u0015it\bQ!C!\tq\u0004!D\u0001\u0003\u0011\u0015y!\b1\u0001\u0011\u0011\u0015y\"\b1\u0001!\u0011\u0015a#\b1\u0001.\u0011\u001d!$\b%AA\u0002UBQ\u0001\u0012\u0001\u0007\u0002\u0015\u000b\u0001cZ3oKJ\fG/\u001a*fcV,7\u000f^:\u0015\u0003\u0019\u00032a\u0012'P\u001d\tA%J\u0004\u0002\u0014\u0013&\tq#\u0003\u0002L-\u00059\u0001/Y2lC\u001e,\u0017BA'O\u0005!IE/\u001a:bE2,'BA&\u0017!\tq\u0004+\u0003\u0002R\u0005\tY\"+Z9vKN$\u0018I\u001c3D_6\u0004H.\u001a;j_:D\u0015M\u001c3mKJDQa\u0015\u0001\u0007\u0002Q\u000ba\"\u001e8tK:$X\t\u001f9jefl5/F\u0001V!\t1d+\u0003\u0002X-\t\u0019\u0011J\u001c;\t\u000fe\u0003!\u0019!C\u00055\u0006qQO\\:f]R\u0014V-];fgR\u001cX#A.\u0011\u0005yb\u0016BA/\u0003\u00059)fn]3oiJ+\u0017/^3tiNDaa\u0018\u0001!\u0002\u0013Y\u0016aD;og\u0016tGOU3rk\u0016\u001cHo\u001d\u0011\t\u000b\u0005\u0004A\u0011\u00012\u0002#!\f7/\u00168tK:$(+Z9vKN$8/F\u00016\u0011\u0015!\u0007\u0001\"\u0011f\u0003!\u0019\b.\u001e;e_^tG#\u00014\u0011\u0005Y:\u0017B\u00015\u0017\u0005\u0011)f.\u001b;\t\u000b)\u0004A\u0011I3\u0002\r\u0011|wk\u001c:l\u0011\u0015a\u0007\u0001\"\u0003n\u00031\u0019XM\u001c3SKF,Xm\u001d;t)\tq\u0017\u000f\u0005\u00027_&\u0011\u0001O\u0006\u0002\u0005\u0019>tw\rC\u0003sW\u0002\u0007a.A\u0002o_^DQ\u0001\u001e\u0001\u0005\nU\f\u0001c\u00195fG.$\u0015n]2p]:,7\r^:\u0015\u0005\u00194\b\"\u0002:t\u0001\u0004q\u0007\"\u0002=\u0001\t\u0013I\u0018a\u00054bS2,\u0005\u0010]5sK\u0012\u0014V-];fgR\u001cHC\u00014{\u0011\u0015\u0011x\u000f1\u0001o\u0011\u0015a\b\u0001\"\u0001~\u0003Y\u0019w.\u001c9mKR,w+\u001b;i\t&\u001c8m\u001c8oK\u000e$H\u0003\u00024\u007f\u0003\u000fAaa`>A\u0002\u0005\u0005\u0011a\u0002:fcV,7\u000f\u001e\t\u0004C\u0005\r\u0011bAA\u0003E\ti1\t\\5f]R\u0014V-];fgRDQA]>A\u00029Da!a\u0003\u0001\t\u0003)\u0017AB<bW\u0016,\boB\u0005\u0002\u0010\t\t\t\u0011#\u0001\u0002\u0012\u0005)\u0012J\u001c;fe\n\u0013xn[3s'\u0016tG\r\u00165sK\u0006$\u0007c\u0001 \u0002\u0014\u0019A\u0011AAA\u0001\u0012\u0003\t)b\u0005\u0003\u0002\u0014\u0005]\u0001c\u0001\u001c\u0002\u001a%\u0019\u00111\u0004\f\u0003\r\u0005s\u0017PU3g\u0011\u001dY\u00141\u0003C\u0001\u0003?!\"!!\u0005\t\u0015\u0005\r\u00121CI\u0001\n\u0003\t)#A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003OQ3!NA\u0015W\t\tY\u0003\u0005\u0003\u0002.\u0005]RBAA\u0018\u0015\u0011\t\t$a\r\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001b-\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005e\u0012q\u0006\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public abstract class InterBrokerSendThread
extends ShutdownableThread {
    private final NetworkClient networkClient;
    private final Time time;
    private final UnsentRequests unsentRequests;

    public static boolean $lessinit$greater$default$4() {
        return InterBrokerSendThread$.MODULE$.$lessinit$greater$default$4();
    }

    public abstract Iterable<RequestAndCompletionHandler> generateRequests();

    public abstract int unsentExpiryMs();

    private UnsentRequests unsentRequests() {
        return this.unsentRequests;
    }

    public boolean hasUnsentRequests() {
        return this.unsentRequests().iterator().hasNext();
    }

    @Override
    public void shutdown() {
        this.initiateShutdown();
        this.networkClient.wakeup();
        this.awaitShutdown();
    }

    @Override
    public void doWork() {
        LongRef now = LongRef.create(this.time.milliseconds());
        this.generateRequests().foreach((Function1<RequestAndCompletionHandler, Object> & Serializable & scala.Serializable)request -> {
            InterBrokerSendThread.$anonfun$doWork$1(this, now, request);
            return BoxedUnit.UNIT;
        });
        try {
            long timeout = this.sendRequests(now.elem);
            this.networkClient.poll(timeout, now.elem);
            now.elem = this.time.milliseconds();
            this.checkDisconnects(now.elem);
            this.failExpiredRequests(now.elem);
            this.unsentRequests().clean();
        }
        catch (FatalExitError e) {
            throw e;
        }
        catch (Throwable t) {
            this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unhandled exception caught in InterBrokerSendThread"})).s(Nil$.MODULE$), (Function0<Throwable> & Serializable & scala.Serializable)() -> t);
            throw new FatalExitError();
        }
    }

    private long sendRequests(long now) {
        LongRef pollTimeout = LongRef.create(Long.MAX_VALUE);
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.unsentRequests().nodes()).asScala()).foreach((Function1<Node, Object> & Serializable & scala.Serializable)node -> {
            InterBrokerSendThread.$anonfun$sendRequests$1(this, now, pollTimeout, node);
            return BoxedUnit.UNIT;
        });
        return pollTimeout.elem;
    }

    private void checkDisconnects(long now) {
        Iterator<Map.Entry<Node, ArrayDeque<ClientRequest>>> iterator = this.unsentRequests().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Node, ArrayDeque<ClientRequest>> entry = iterator.next();
            Tuple2<Node, ArrayDeque<ClientRequest>> tuple2 = new Tuple2<Node, ArrayDeque<ClientRequest>>(entry.getKey(), entry.getValue());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Node node = tuple2._1();
            ArrayDeque<ClientRequest> requests = tuple2._2();
            Tuple2<Node, ArrayDeque<ClientRequest>> tuple22 = new Tuple2<Node, ArrayDeque<ClientRequest>>(node, requests);
            Tuple2<Node, ArrayDeque<ClientRequest>> tuple23 = tuple22;
            Node node2 = tuple23._1();
            ArrayDeque<ClientRequest> requests2 = tuple23._2();
            if (requests2.isEmpty() || !this.networkClient.connectionFailed(node2)) continue;
            iterator.remove();
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(requests2).asScala()).foreach((Function1<ClientRequest, Object> & Serializable & scala.Serializable)request -> {
                InterBrokerSendThread.$anonfun$checkDisconnects$1(this, now, node2, request);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void failExpiredRequests(long now) {
        Collection<ClientRequest> expiredRequests = this.unsentRequests().removeExpiredRequests(now, this.unsentExpiryMs());
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(expiredRequests).asScala()).foreach((Function1<ClientRequest, Object> & Serializable & scala.Serializable)request -> {
            InterBrokerSendThread.$anonfun$failExpiredRequests$1(this, now, request);
            return BoxedUnit.UNIT;
        });
    }

    public void completeWithDisconnect(ClientRequest request, long now) {
        RequestCompletionHandler handler = request.callback();
        handler.onComplete(new ClientResponse(request.makeHeader(request.requestBuilder().latestAllowedVersion()), handler, request.destination(), now, now, true, null, null));
    }

    public void wakeup() {
        this.networkClient.wakeup();
    }

    public static final /* synthetic */ void $anonfun$doWork$1(InterBrokerSendThread $this, LongRef now$1, RequestAndCompletionHandler request) {
        RequestCompletionHandler completionHandler = request.handler();
        $this.unsentRequests().put(request.destination(), $this.networkClient.newClientRequest(request.destination().idString(), request.request(), now$1.elem, true, completionHandler));
    }

    public static final /* synthetic */ void $anonfun$sendRequests$1(InterBrokerSendThread $this, long now$2, LongRef pollTimeout$1, Node node) {
        Iterator<ClientRequest> requestIterator = $this.unsentRequests().requestIterator(node);
        while (requestIterator.hasNext()) {
            ClientRequest request = requestIterator.next();
            if ($this.networkClient.ready(node, now$2)) {
                $this.networkClient.send(request, now$2);
                requestIterator.remove();
                continue;
            }
            pollTimeout$1.elem = Math.min(pollTimeout$1.elem, $this.networkClient.connectionDelay(node, now$2));
        }
    }

    public static final /* synthetic */ void $anonfun$checkDisconnects$1(InterBrokerSendThread $this, long now$3, Node node$1, ClientRequest request) {
        if ($this.networkClient.authenticationException(node$1) != null) {
            $this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to send the following request due to authentication error: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{request})));
        }
        $this.completeWithDisconnect(request, now$3);
    }

    public static final /* synthetic */ void $anonfun$failExpiredRequests$1(InterBrokerSendThread $this, long now$4, ClientRequest request) {
        $this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to send the following request after ", " ms: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger($this.unsentExpiryMs()), request})));
        $this.completeWithDisconnect(request, now$4);
    }

    public InterBrokerSendThread(String name, NetworkClient networkClient, Time time, boolean isInterruptible) {
        this.networkClient = networkClient;
        this.time = time;
        super(name, isInterruptible);
        this.unsentRequests = new UnsentRequests();
    }
}

