/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.nio.ByteBuffer;
import kafka.common.KafkaException;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;

public final class ApiUtils$ {
    public static ApiUtils$ MODULE$;
    private final String ProtocolEncoding;

    static {
        new ApiUtils$();
    }

    public String ProtocolEncoding() {
        return this.ProtocolEncoding;
    }

    public String readShortString(ByteBuffer buffer) {
        short size = buffer.getShort();
        if (size < 0) {
            return null;
        }
        byte[] bytes = new byte[size];
        buffer.get(bytes);
        return new String(bytes, this.ProtocolEncoding());
    }

    public void writeShortString(ByteBuffer buffer, String string) {
        if (string == null) {
            buffer.putShort((short)-1);
        } else {
            byte[] encodedString = string.getBytes(this.ProtocolEncoding());
            if (encodedString.length > Short.MAX_VALUE) {
                throw new KafkaException("String exceeds the maximum size of " + Short.MAX_VALUE + ".");
            }
            buffer.putShort((short)encodedString.length);
            buffer.put(encodedString);
        }
    }

    public int shortStringLength(String string) {
        int n;
        if (string == null) {
            n = 2;
        } else {
            byte[] encodedString = string.getBytes(this.ProtocolEncoding());
            if (encodedString.length > Short.MAX_VALUE) {
                throw new KafkaException("String exceeds the maximum size of " + Short.MAX_VALUE + ".");
            }
            n = 2 + encodedString.length;
        }
        return n;
    }

    public int readIntInRange(ByteBuffer buffer, String name, Tuple2<Object, Object> range) {
        int value = buffer.getInt();
        if (value < range._1$mcI$sp() || value > range._2$mcI$sp()) {
            throw new KafkaException(name + " has value " + value + " which is not in the range " + range + ".");
        }
        return value;
    }

    public short readShortInRange(ByteBuffer buffer, String name, Tuple2<Object, Object> range) {
        short value = buffer.getShort();
        if (value < BoxesRunTime.unboxToShort(range._1()) || value > BoxesRunTime.unboxToShort(range._2())) {
            throw new KafkaException(name + " has value " + value + " which is not in the range " + range + ".");
        }
        return value;
    }

    private ApiUtils$() {
        MODULE$ = this;
        this.ProtocolEncoding = "UTF-8";
    }
}

