/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import kafka.admin.ZkSecurityMigrator;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Logging;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.security.JaasUtils;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.StringOps;

public final class ZkSecurityMigrator$
implements Logging {
    public static ZkSecurityMigrator$ MODULE$;
    private final String usageMessage;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ZkSecurityMigrator$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ZkSecurityMigrator$ zkSecurityMigrator$ = this;
        synchronized (zkSecurityMigrator$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String usageMessage() {
        return this.usageMessage;
    }

    public void run(String[] args) {
        boolean bl;
        String jaasFile = System.getProperty("java.security.auth.login.config");
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec<String> zkAclOpt = parser.accepts("zookeeper.acl", "Indicates whether to make the Kafka znodes in ZooKeeper secure or unsecure. The options are 'secure' and 'unsecure'").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec<String> zkUrlOpt = parser.accepts("zookeeper.connect", "Sets the ZooKeeper connect string (ensemble). This parameter takes a comma-separated list of host:port pairs.").withRequiredArg().defaultsTo("localhost:2181", (String[])((Object[])new String[0])).ofType(String.class);
        ArgumentAcceptingOptionSpec<Integer> zkSessionTimeoutOpt = parser.accepts("zookeeper.session.timeout", "Sets the ZooKeeper session timeout.").withRequiredArg().ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(30000), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<Integer> zkConnectionTimeoutOpt = parser.accepts("zookeeper.connection.timeout", "Sets the ZooKeeper connection timeout.").withRequiredArg().ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(30000), (Integer[])((Object[])new Integer[0]));
        OptionSpecBuilder helpOpt = parser.accepts("help", "Print usage information.");
        OptionSet options = parser.parse(args);
        if (options.has(helpOpt)) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, this.usageMessage());
        }
        if (jaasFile == null) {
            String errorMsg = "No JAAS configuration file has been specified. Please make sure that you have set " + new StringOps(Predef$.MODULE$.augmentString("the system property %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{"java.security.auth.login.config"}));
            System.out.println(new StringOps(Predef$.MODULE$.augmentString("ERROR: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{errorMsg})));
            throw new IllegalArgumentException("Incorrect configuration");
        }
        if (!JaasUtils.isZkSecurityEnabled()) {
            String errorMsg = new StringOps(Predef$.MODULE$.augmentString("Security isn't enabled, most likely the file isn't set properly: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{jaasFile}));
            System.out.println(new StringOps(Predef$.MODULE$.augmentString("ERROR: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{errorMsg})));
            throw new IllegalArgumentException("Incorrect configuration");
        }
        String string = options.valueOf(zkAclOpt);
        if ("secure".equals(string)) {
            this.info((Function0<String> & Serializable & scala.Serializable)() -> "zookeeper.acl option is secure");
            bl = true;
        } else if ("unsecure".equals(string)) {
            this.info((Function0<String> & Serializable & scala.Serializable)() -> "zookeeper.acl option is unsecure");
            bl = false;
        } else {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, this.usageMessage());
        }
        boolean zkAcl = bl;
        String zkUrl = options.valueOf(zkUrlOpt);
        int zkSessionTimeout = options.valueOf(zkSessionTimeoutOpt);
        int zkConnectionTimeout = options.valueOf(zkConnectionTimeoutOpt);
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(zkUrl, zkSessionTimeout, zkConnectionTimeout, zkAcl);
        ZkSecurityMigrator migrator = new ZkSecurityMigrator(zkUtils);
        migrator.kafka$admin$ZkSecurityMigrator$$run();
    }

    public void main(String[] args) {
        try {
            this.run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ZkSecurityMigrator$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.usageMessage = "ZooKeeper Migration Tool Help. This tool updates the ACLs of znodes as part of the process of setting up ZooKeeper authentication.";
    }
}

