/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.admin.AdminOperationException;
import kafka.admin.PreferredReplicaLeaderElectionCommand;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxesRunTime;

public final class PreferredReplicaLeaderElectionCommand$
implements Logging {
    public static PreferredReplicaLeaderElectionCommand$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new PreferredReplicaLeaderElectionCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        PreferredReplicaLeaderElectionCommand$ preferredReplicaLeaderElectionCommand$ = this;
        synchronized (preferredReplicaLeaderElectionCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec<String> jsonFileOpt = parser.accepts("path-to-json-file", "The JSON file with the list of partitions for which preferred replica leader election should be done, in the following format - \n{\"partitions\":\n\t[{\"topic\": \"foo\", \"partition\": 1},\n\t {\"topic\": \"foobar\", \"partition\": 2}]\n}\nDefaults to all existing partitions").withRequiredArg().describedAs("list of partitions for which preferred replica leader election needs to be triggered").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> zkConnectOpt = parser.accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "This tool causes leadership for each partition to be transferred back to the 'preferred replica', it can be used to balance leadership among the servers.");
        }
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{zkConnectOpt}));
        String zkConnect = options.valueOf(zkConnectOpt);
        try (KafkaZkClient zkClient = null;){
            try {
                Time time = Time.SYSTEM;
                zkClient = KafkaZkClient$.MODULE$.apply(zkConnect, JaasUtils.isZkSecurityEnabled(), 30000, 30000, Integer.MAX_VALUE, time, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8());
                scala.collection.immutable.Set<TopicPartition> partitionsForPreferredReplicaElection = !options.has(jsonFileOpt) ? zkClient.getAllPartitions() : this.parsePreferredReplicaElectionData(Utils.readFileAsString(options.valueOf(jsonFileOpt)));
                PreferredReplicaLeaderElectionCommand preferredReplicaElectionCommand = new PreferredReplicaLeaderElectionCommand(zkClient, partitionsForPreferredReplicaElection);
                preferredReplicaElectionCommand.moveLeaderToPreferredReplica();
            }
            catch (Throwable e) {
                Predef$.MODULE$.println("Failed to start preferred replica election");
                Predef$.MODULE$.println(Utils.stackTrace(e));
            }
        }
    }

    public scala.collection.immutable.Set<TopicPartition> parsePreferredReplicaElectionData(String jsonString) {
        scala.collection.immutable.Set<TopicPartition> set;
        Option<JsonValue> option = Json$.MODULE$.parseFull(jsonString);
        if (option instanceof Some) {
            Buffer partitions;
            Some some = (Some)option;
            JsonValue js = (JsonValue)some.value();
            Option<JsonValue> option2 = js.asJsonObject().get("partitions");
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                JsonValue partitionsList = (JsonValue)some2.value();
                Iterator partitionsRaw = partitionsList.asJsonArray().iterator().map((Function1<JsonValue, JsonObject> & Serializable & scala.Serializable)x$1 -> x$1.asJsonObject());
                partitions = partitionsRaw.map((Function1<JsonObject, TopicPartition> & Serializable & scala.Serializable)p -> {
                    String topic = p.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
                    int partition = BoxesRunTime.unboxToInt(p.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
                    return new TopicPartition(topic, partition);
                }).toBuffer();
                Iterable duplicatePartitions = CoreUtils$.MODULE$.duplicates(partitions);
                if (duplicatePartitions.nonEmpty()) {
                    throw new AdminOperationException(new StringOps(Predef$.MODULE$.augmentString("Preferred replica election data contains duplicate partitions: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{duplicatePartitions.mkString(",")})));
                }
            } else {
                if (None$.MODULE$.equals(option2)) {
                    throw new AdminOperationException("Preferred replica election data is empty");
                }
                throw new MatchError(option2);
            }
            set = partitions.toSet();
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new AdminOperationException("Preferred replica election data is empty");
            }
            throw new MatchError(option);
        }
        scala.collection.immutable.Set<TopicPartition> set2 = set;
        return set2;
    }

    public void writePreferredReplicaElectionData(KafkaZkClient zkClient, Set<TopicPartition> partitionsUndergoingPreferredReplicaElection) {
        try {
            zkClient.createPreferredReplicaElection(partitionsUndergoingPreferredReplicaElection.toSet());
            Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Created preferred replica election path with %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{partitionsUndergoingPreferredReplicaElection.mkString(",")})));
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw new AdminOperationException("Preferred replica leader election currently in progress for " + new StringOps(Predef$.MODULE$.augmentString("%s. Aborting operation")).format(Predef$.MODULE$.genericWrapArray(new Object[]{zkClient.getPreferredReplicaElection().mkString(",")})));
        }
        catch (Throwable e2) {
            throw new AdminOperationException(e2.toString());
        }
    }

    private PreferredReplicaLeaderElectionCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

