/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipFileReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipFileReader.class);
    private static final String MAC_TEMP_FOLDER = "__MACOSX";
    private static final String MAC_TEMP_FILE = ".DS_Store";

    public List<String> getRecordsFromZipFile(InputStream providedZipFile) throws IOException {
        String prefix = UUID.randomUUID().toString();
        File tempFile = File.createTempFile(prefix, ".zip");
        FileUtils.copyInputStreamToFile(providedZipFile, tempFile);
        LOGGER.info("Temp file: {} created.", (Object)tempFile);
        try (ZipFile zipFile = new ZipFile(tempFile, 5);){
            List<String> list = this.getRecordsFromZipFile(zipFile);
            return list;
        }
    }

    List<String> getRecordsFromZipFile(ZipFile zipFile) throws IOException {
        ArrayList<String> result2 = new ArrayList<String>();
        Iterator entries = zipFile.stream().iterator();
        while (entries.hasNext()) {
            ZipEntry zipEntry = (ZipEntry)entries.next();
            if (!this.accept(zipEntry)) continue;
            result2.add(IOUtils.toString(zipFile.getInputStream(zipEntry), StandardCharsets.UTF_8.name()));
        }
        return result2;
    }

    boolean accept(ZipEntry zipEntry) {
        return !zipEntry.isDirectory() && !zipEntry.getName().startsWith(MAC_TEMP_FOLDER) && !zipEntry.getName().endsWith(MAC_TEMP_FILE);
    }
}

