/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.model;

import eu.europeana.corelib.definitions.jibx.AboutType;
import eu.europeana.corelib.definitions.jibx.NonNegativeIntegerType;
import eu.europeana.corelib.definitions.jibx.Preview;
import eu.europeana.corelib.definitions.jibx.RDF;
import eu.europeana.corelib.definitions.jibx.WebResourceType;
import eu.europeana.metis.mediaprocessing.model.EnrichedRdf;
import eu.europeana.metis.mediaprocessing.model.RdfWrapper;
import eu.europeana.metis.mediaprocessing.model.ResourceMetadata;
import eu.europeana.metis.mediaprocessing.model.UrlType;
import eu.europeana.metis.mediaprocessing.model.WebResource;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class EnrichedRdfImpl
extends RdfWrapper
implements EnrichedRdf {
    private final Map<String, Set<String>> thumbnailTargetNames = new HashMap<String, Set<String>>();

    public EnrichedRdfImpl(RDF rdf) {
        super(rdf);
    }

    private WebResource getOrCreateWebResource(String url) {
        if (this.getRdf().getWebResourceList() == null) {
            this.getRdf().setWebResourceList(new ArrayList<WebResourceType>());
        }
        for (WebResourceType resource : this.getRdf().getWebResourceList()) {
            if (!resource.getAbout().equals(url)) continue;
            return new WebResource(resource);
        }
        WebResourceType resource = new WebResourceType();
        resource.setAbout(url);
        this.getRdf().getWebResourceList().add(resource);
        return new WebResource(resource);
    }

    @Override
    public void enrichResource(ResourceMetadata resource) {
        WebResource webResource = this.getOrCreateWebResource(resource.getResourceUrl());
        resource.getMetaData().updateResource(webResource);
        this.thumbnailTargetNames.put(resource.getResourceUrl(), resource.getThumbnailTargetNames());
    }

    @Override
    public RDF finalizeRdf() {
        String edmPreviewUrl = this.getEdmPreviewThumbnailUrl();
        this.updateEdmPreview(edmPreviewUrl);
        return this.getRdf();
    }

    String getEdmPreviewThumbnailUrl() {
        Optional<String> objectThumbnail = this.getFirstResourceOfType(UrlType.OBJECT).flatMap(this::getWebResource).map(AboutType::getAbout).filter(this::hasEligiblePreviewThumbnail);
        if (objectThumbnail.isPresent()) {
            return objectThumbnail.get();
        }
        Optional<Object> isShownBy = this.getFirstResourceOfType(UrlType.IS_SHOWN_BY).flatMap(this::getWebResource);
        Optional<Object> hasView = this.getFirstResourceOfType(UrlType.HAS_VIEW).flatMap(this::getWebResource);
        BigInteger isShownByResolution = isShownBy.map(WebResourceType::getSpatialResolution).map(NonNegativeIntegerType::getInteger).orElse(BigInteger.ZERO);
        BigInteger hasViewResolution = hasView.map(WebResourceType::getSpatialResolution).map(NonNegativeIntegerType::getInteger).orElse(BigInteger.ZERO);
        Optional<String> isShownByThumbnail = isShownBy.map(AboutType::getAbout).filter(this::hasEligiblePreviewThumbnail);
        Optional<String> hasViewThumbnail = hasView.map(AboutType::getAbout).filter(this::hasEligiblePreviewThumbnail);
        Optional<String> result2 = isShownByThumbnail.isPresent() ? (hasViewThumbnail.isPresent() && isShownByResolution.compareTo(hasViewResolution) < 0 ? hasViewThumbnail : isShownByThumbnail) : hasViewThumbnail;
        return result2.orElse(null);
    }

    private boolean hasEligiblePreviewThumbnail(String resourceUrl) {
        return this.getThumbnailTargetNames(resourceUrl).stream().anyMatch(name -> name.contains("-LARGE"));
    }

    void updateEdmPreview(String url) {
        if (url != null && this.getRdf().getEuropeanaAggregationList() != null && !this.getRdf().getEuropeanaAggregationList().isEmpty()) {
            Preview preview = new Preview();
            preview.setResource(url);
            this.getRdf().getEuropeanaAggregationList().get(0).setPreview(preview);
        }
    }

    Set<String> getResourceUrls() {
        return Collections.unmodifiableSet(this.thumbnailTargetNames.keySet());
    }

    Set<String> getThumbnailTargetNames(String resourceUrl) {
        return Optional.ofNullable(this.thumbnailTargetNames.get(resourceUrl)).map(Collections::unmodifiableSet).orElseGet(Collections::emptySet);
    }
}

