/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.model;

import eu.europeana.metis.mediaprocessing.model.IResourceMetadata;
import eu.europeana.metis.mediaprocessing.model.ResourceMetadata;
import eu.europeana.metis.mediaprocessing.model.Thumbnail;
import eu.europeana.metis.mediaprocessing.model.WebResource;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractResourceMetadata
implements IResourceMetadata {
    private static final long serialVersionUID = 4578729338510378084L;
    private String mimeType;
    private String resourceUrl;
    private long contentSize;
    private Set<String> thumbnailTargetNames;

    protected AbstractResourceMetadata(String mimeType, String resourceUrl, long contentSize) {
        this(mimeType, resourceUrl, contentSize, null);
    }

    protected AbstractResourceMetadata(String mimeType, String resourceUrl, long contentSize, Collection<? extends Thumbnail> thumbnails) {
        this.mimeType = mimeType;
        this.resourceUrl = resourceUrl;
        this.contentSize = contentSize;
        Stream<Object> thumbnailStream = thumbnails == null ? Stream.empty() : thumbnails.stream();
        this.thumbnailTargetNames = thumbnailStream.map(Thumbnail::getTargetName).collect(Collectors.toSet());
    }

    AbstractResourceMetadata() {
    }

    @Override
    public String getResourceUrl() {
        return this.resourceUrl;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public Set<String> getThumbnailTargetNames() {
        return Optional.ofNullable(this.thumbnailTargetNames).map(Collections::unmodifiableSet).orElseGet(Collections::emptySet);
    }

    public long getContentSize() {
        return this.contentSize;
    }

    protected void updateResource(WebResource resource) {
        resource.setMimeType(this.mimeType);
        resource.setFileSize(this.contentSize);
    }

    protected abstract ResourceMetadata prepareForSerialization();
}

