/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.extraction;

import eu.europeana.metis.mediaprocessing.MediaExtractor;
import eu.europeana.metis.mediaprocessing.exception.MediaExtractionException;
import eu.europeana.metis.mediaprocessing.exception.MediaProcessorException;
import eu.europeana.metis.mediaprocessing.extraction.AudioVideoProcessor;
import eu.europeana.metis.mediaprocessing.extraction.CommandExecutor;
import eu.europeana.metis.mediaprocessing.extraction.ImageProcessor;
import eu.europeana.metis.mediaprocessing.extraction.MediaProcessor;
import eu.europeana.metis.mediaprocessing.extraction.TextProcessor;
import eu.europeana.metis.mediaprocessing.extraction.ThumbnailGenerator;
import eu.europeana.metis.mediaprocessing.http.MimeTypeDetectHttpClient;
import eu.europeana.metis.mediaprocessing.http.ResourceDownloadClient;
import eu.europeana.metis.mediaprocessing.model.RdfResourceEntry;
import eu.europeana.metis.mediaprocessing.model.Resource;
import eu.europeana.metis.mediaprocessing.model.ResourceExtractionResult;
import eu.europeana.metis.mediaprocessing.model.UrlType;
import eu.europeana.metis.utils.MediaType;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import org.apache.tika.Tika;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaExtractorImpl
implements MediaExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaExtractorImpl.class);
    private static final Set<UrlType> URL_TYPES_FOR_FULL_PROCESSING = Collections.unmodifiableSet(EnumSet.of(UrlType.IS_SHOWN_BY, UrlType.HAS_VIEW, UrlType.OBJECT));
    private static final Set<UrlType> URL_TYPES_FOR_REDUCED_PROCESSING = Collections.singleton(UrlType.IS_SHOWN_AT);
    private final ResourceDownloadClient fullProcessingDownloadClient;
    private final ResourceDownloadClient reducedProcessingDownloadClient;
    private final MimeTypeDetectHttpClient mimeTypeDetectHttpClient;
    private final Tika tika;
    private final ImageProcessor imageProcessor;
    private final AudioVideoProcessor audioVideoProcessor;
    private final TextProcessor textProcessor;

    MediaExtractorImpl(ResourceDownloadClient fullProcessingDownloadClient, ResourceDownloadClient reducedProcessingDownloadClient, MimeTypeDetectHttpClient mimeTypeDetectHttpClient, Tika tika, ImageProcessor imageProcessor, AudioVideoProcessor audioVideoProcessor, TextProcessor textProcessor) {
        this.fullProcessingDownloadClient = fullProcessingDownloadClient;
        this.reducedProcessingDownloadClient = reducedProcessingDownloadClient;
        this.mimeTypeDetectHttpClient = mimeTypeDetectHttpClient;
        this.tika = tika;
        this.imageProcessor = imageProcessor;
        this.audioVideoProcessor = audioVideoProcessor;
        this.textProcessor = textProcessor;
    }

    public MediaExtractorImpl(int redirectCount, int thumbnailGenerateTimeout, int audioVideoProbeTimeout, int connectTimeout, int socketTimeout, int downloadTimeout) throws MediaProcessorException {
        ThumbnailGenerator thumbnailGenerator = new ThumbnailGenerator(new CommandExecutor(thumbnailGenerateTimeout));
        this.fullProcessingDownloadClient = new ResourceDownloadClient(redirectCount, this::shouldDownloadForFullProcessing, connectTimeout, socketTimeout, downloadTimeout);
        this.reducedProcessingDownloadClient = new ResourceDownloadClient(redirectCount, mimeType -> false, connectTimeout, socketTimeout, downloadTimeout);
        this.mimeTypeDetectHttpClient = new MimeTypeDetectHttpClient(connectTimeout, socketTimeout, downloadTimeout);
        this.tika = new Tika();
        this.imageProcessor = new ImageProcessor(thumbnailGenerator);
        this.audioVideoProcessor = new AudioVideoProcessor(new CommandExecutor(audioVideoProbeTimeout));
        this.textProcessor = new TextProcessor(thumbnailGenerator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResourceExtractionResult performMediaExtraction(RdfResourceEntry resourceEntry) throws MediaExtractionException {
        ProcessingMode mode = this.getMode(resourceEntry);
        if (mode == ProcessingMode.NONE) {
            return null;
        }
        ResourceDownloadClient httpClient = mode == ProcessingMode.FULL ? this.fullProcessingDownloadClient : this.reducedProcessingDownloadClient;
        try (Resource resource = (Resource)httpClient.download(resourceEntry);){
            ResourceExtractionResult resourceExtractionResult = this.performProcessing(resource, mode);
            return resourceExtractionResult;
        }
        catch (IOException | RuntimeException e) {
            throw new MediaExtractionException("Problem while processing " + resourceEntry.getResourceUrl(), e);
        }
    }

    ProcessingMode getMode(RdfResourceEntry resourceEntry) {
        ProcessingMode result2 = URL_TYPES_FOR_FULL_PROCESSING.stream().anyMatch(resourceEntry.getUrlTypes()::contains) ? ProcessingMode.FULL : (URL_TYPES_FOR_REDUCED_PROCESSING.stream().anyMatch(resourceEntry.getUrlTypes()::contains) ? ProcessingMode.REDUCED : ProcessingMode.NONE);
        return result2;
    }

    String detectAndVerifyMimeType(Resource resource, ProcessingMode mode) throws MediaExtractionException {
        String detectedMimeType;
        boolean hasContent;
        if (mode == ProcessingMode.NONE) {
            throw new IllegalStateException();
        }
        try {
            hasContent = resource.hasContent();
            detectedMimeType = hasContent ? this.tika.detect(resource.getContentPath()) : (String)this.mimeTypeDetectHttpClient.download(resource.getActualLocation().toURL());
        }
        catch (IOException e) {
            throw new MediaExtractionException("Mime type checking error", e);
        }
        String providedMimeType = resource.getProvidedMimeType();
        if (!("application/xhtml+xml".equals(detectedMimeType) && providedMimeType.startsWith("text/html") || detectedMimeType.equals(providedMimeType))) {
            LOGGER.info("Invalid mime type provided (should be {}, was {}): {}", detectedMimeType, providedMimeType, resource.getResourceUrl());
        }
        if (mode == ProcessingMode.FULL && this.shouldDownloadForFullProcessing(detectedMimeType) && !hasContent) {
            throw new MediaExtractionException("File content is not downloaded and mimeType does not support processing without a downloaded file.");
        }
        return detectedMimeType;
    }

    MediaProcessor chooseMediaProcessor(MediaType mediaType) {
        MediaProcessor processor;
        switch (mediaType) {
            case TEXT: {
                processor = this.textProcessor;
                break;
            }
            case AUDIO: 
            case VIDEO: {
                processor = this.audioVideoProcessor;
                break;
            }
            case IMAGE: {
                processor = this.imageProcessor;
                break;
            }
            default: {
                processor = null;
            }
        }
        return processor;
    }

    ResourceExtractionResult performProcessing(Resource resource, ProcessingMode mode) throws MediaExtractionException {
        if (mode == ProcessingMode.NONE) {
            throw new IllegalStateException();
        }
        String detectedMimeType = this.detectAndVerifyMimeType(resource, mode);
        MediaProcessor processor = this.chooseMediaProcessor(MediaType.getMediaType(detectedMimeType));
        ResourceExtractionResult result2 = processor == null ? null : (mode == ProcessingMode.FULL ? processor.extractMetadata(resource, detectedMimeType) : processor.copyMetadata(resource, detectedMimeType));
        return result2;
    }

    @Override
    public void close() throws IOException {
        try {
            this.fullProcessingDownloadClient.close();
        }
        finally {
            this.reducedProcessingDownloadClient.close();
        }
    }

    boolean shouldDownloadForFullProcessing(String mimeType) {
        return Optional.of(MediaType.getMediaType(mimeType)).map(this::chooseMediaProcessor).map(MediaProcessor::downloadResourceForFullProcessing).orElse(Boolean.FALSE);
    }

    static enum ProcessingMode {
        FULL,
        REDUCED,
        NONE;

    }
}

