/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.cache.redis;

import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.exceptions.JedisConnectionException;

@Component
public class RedisProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisProvider.class);
    private static final int JEDIS_TIMEOUT = 600000;
    private static final int TIME_BETWEEN_EVICTION_RUNS_MILLISECONDS = 60000;
    private static final int TESTS_PER_EVICTION_RUN = 10;
    private static final int MAX_NUMBER_OF_IDLE_CONNECTIONS = 5;
    private JedisPool pool;
    private final String host;
    private final int port;
    private final String password;

    public RedisProvider(String host, int port, String password) {
        this.host = host;
        this.port = port;
        this.password = password;
        this.initPool(host, port, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPool(String host, int port, String password) {
        RedisProvider redisProvider = this;
        synchronized (redisProvider) {
            if (this.pool == null || this.pool.isClosed()) {
                LOGGER.info("Get new pool from Redis Host: {}, port: {}{}", host, port, StringUtils.isNotEmpty(password) ? " using a password." : ".");
                JedisPoolConfig poolConfig = new JedisPoolConfig();
                poolConfig.setTestOnBorrow(true);
                poolConfig.setTestOnReturn(true);
                poolConfig.setMaxIdle(5);
                poolConfig.setMinIdle(1);
                poolConfig.setTestWhileIdle(true);
                poolConfig.setNumTestsPerEvictionRun(10);
                poolConfig.setTimeBetweenEvictionRunsMillis(60000L);
                this.pool = StringUtils.isNotEmpty(password) ? new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, 600000, password) : new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, 600000);
            }
            try {
                this.pool.getResource();
            }
            catch (JedisConnectionException e) {
                LOGGER.error("Cannot get resource from pool..", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Jedis getJedis() {
        RedisProvider redisProvider = this;
        synchronized (redisProvider) {
            LOGGER.info("Requesting a new jedis connection");
            try {
                return this.pool.getResource();
            }
            catch (RuntimeException e) {
                LOGGER.error("Cannot get resource from pool..", e);
                this.close();
                this.initPool(this.host, this.port, this.password);
                return this.pool.getResource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void close() {
        RedisProvider redisProvider = this;
        synchronized (redisProvider) {
            if (this.pool != null && !this.pool.isClosed()) {
                this.pool.close();
            }
        }
    }
}

