/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.spouts.kafka;

import eu.europeana.cloud.service.dps.DpsTask;
import eu.europeana.cloud.service.dps.storm.spouts.kafka.TaskQueueFiller;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.storm.spout.ISpoutOutputCollector;
import org.apache.storm.spout.SpoutOutputCollector;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectorWrapper
extends SpoutOutputCollector {
    private TaskQueueFiller taskQueueFiller;
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectorWrapper.class);

    public CollectorWrapper(ISpoutOutputCollector delegate, TaskQueueFiller taskQueueFiller) {
        super(delegate);
        this.taskQueueFiller = taskQueueFiller;
    }

    public List<Integer> emit(String streamId, List<Object> tuple, Object messageId) {
        try {
            DpsTask dpsTask = new ObjectMapper().readValue((String)tuple.get(0), DpsTask.class);
            if (dpsTask != null) {
                this.taskQueueFiller.addNewTask(dpsTask);
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
        }
        return Collections.emptyList();
    }
}

