/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.io;

import com.google.gson.Gson;
import com.rits.cloning.Cloner;
import eu.europeana.cloud.service.dps.storm.AbstractDpsBolt;
import eu.europeana.cloud.service.dps.storm.StormTaskTuple;
import eu.europeana.cloud.service.dps.storm.io.ReadFileBolt;
import eu.europeana.metis.mediaprocessing.RdfConverterFactory;
import eu.europeana.metis.mediaprocessing.RdfDeserializer;
import eu.europeana.metis.mediaprocessing.model.RdfResourceEntry;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseFileBolt
extends ReadFileBolt {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParseFileBolt.class);
    private Gson gson;
    private RdfDeserializer rdfDeserializer;

    public ParseFileBolt(String ecloudMcsAddress) {
        super(ecloudMcsAddress);
    }

    @Override
    public void execute(StormTaskTuple stormTaskTuple) {
        block17: {
            try (InputStream stream = this.getFileStreamByStormTuple(stormTaskTuple);){
                byte[] fileContent = IOUtils.toByteArray(stream);
                List<RdfResourceEntry> rdfResourceEntries = this.rdfDeserializer.getResourceEntriesForMediaExtraction(fileContent);
                if (rdfResourceEntries.size() == 0) {
                    StormTaskTuple tuple = new Cloner().deepClone(stormTaskTuple);
                    LOGGER.info("The EDM file has no resource Links ");
                    this.outputCollector.emit((List)tuple.toStormTuple());
                    break block17;
                }
                for (RdfResourceEntry rdfResourceEntry : rdfResourceEntries) {
                    if (AbstractDpsBolt.taskStatusChecker.hasKillFlag(stormTaskTuple.getTaskId())) {
                        break;
                    }
                    StormTaskTuple tuple = new Cloner().deepClone(stormTaskTuple);
                    LOGGER.info("Sending this resource link {} to be processed ", (Object)rdfResourceEntry.getResourceUrl());
                    tuple.addParameter("RESOURCE_LINK", this.gson.toJson(rdfResourceEntry));
                    tuple.addParameter("RESOURCE_LINKS_COUNT", String.valueOf(rdfResourceEntries.size()));
                    tuple.addParameter("RESOURCE_URL", rdfResourceEntry.getResourceUrl());
                    this.outputCollector.emit((List)tuple.toStormTuple());
                }
            }
            catch (Exception e) {
                LOGGER.error("Unable to read and parse file ", e);
                this.emitErrorNotification(stormTaskTuple.getTaskId(), stormTaskTuple.getFileUrl(), e.getMessage(), "Error while reading and parsing the EDM file. The full error is: " + ExceptionUtils.getStackTrace(e));
            }
        }
    }

    @Override
    public void prepare() {
        super.prepare();
        try {
            this.rdfDeserializer = new RdfConverterFactory().createRdfDeserializer();
            this.gson = new Gson();
        }
        catch (Exception e) {
            LOGGER.error("Unable to initialize RDF Deserializer ", e);
            throw new RuntimeException(e);
        }
    }
}

