/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.io;

import eu.europeana.cloud.client.uis.rest.CloudException;
import eu.europeana.cloud.client.uis.rest.UISClient;
import eu.europeana.cloud.common.exceptions.ProviderDoesNotExistException;
import eu.europeana.cloud.common.model.CloudId;
import eu.europeana.cloud.mcs.driver.exception.DriverException;
import eu.europeana.cloud.service.dps.PluginParameterKeys;
import eu.europeana.cloud.service.dps.storm.StormTaskTuple;
import eu.europeana.cloud.service.dps.storm.io.WriteRecordBolt;
import eu.europeana.cloud.service.dps.storm.utils.TaskTupleUtility;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import eu.europeana.cloud.service.uis.exception.IdHasBeenMappedException;
import eu.europeana.cloud.service.uis.exception.RecordDoesNotExistException;
import java.io.IOException;
import java.net.URI;
import org.slf4j.LoggerFactory;

public class HarvestingWriteRecordBolt
extends WriteRecordBolt {
    private static final long serialVersionUID = 1L;
    private String ecloudUisAddress;
    private UISClient uisClient;

    public HarvestingWriteRecordBolt(String ecloudMcsAddress, String ecloudUisAddress) {
        super(ecloudMcsAddress);
        this.ecloudUisAddress = ecloudUisAddress;
        this.LOGGER = LoggerFactory.getLogger(HarvestingWriteRecordBolt.class);
    }

    @Override
    public void prepare() {
        this.uisClient = new UISClient(this.ecloudUisAddress);
        super.prepare();
    }

    @Override
    protected URI createRepresentationAndUploadFile(StormTaskTuple stormTaskTuple) throws IOException, MCSException, CloudException, DriverException {
        String providerId = stormTaskTuple.getParameter("PROVIDER_ID");
        String localId = stormTaskTuple.getParameter("CLOUD_LOCAL_IDENTIFIER");
        String additionalLocalIdentifier = stormTaskTuple.getParameter("ADDITIONAL_LOCAL_IDENTIFIER");
        String authenticationHeader = stormTaskTuple.getParameter("AUTHORIZATION_HEADER");
        String cloudId = this.getCloudId(authenticationHeader, providerId, localId, additionalLocalIdentifier);
        String representationName = stormTaskTuple.getParameter("NEW_REPRESENTATION_NAME");
        if ((representationName == null || representationName.isEmpty()) && stormTaskTuple.getSourceDetails() != null && (representationName = stormTaskTuple.getParameter("SCHEMA_NAME")) == null) {
            representationName = PluginParameterKeys.PLUGIN_PARAMETERS.get("NEW_REPRESENTATION_NAME");
        }
        return this.createRepresentation(stormTaskTuple, providerId, cloudId, representationName, authenticationHeader);
    }

    private URI createRepresentation(StormTaskTuple stormTaskTuple, String providerId, String cloudId, String representationName, String authenticationHeader) throws IOException, MCSException, DriverException {
        int retries = 3;
        while (true) {
            try {
                return this.recordServiceClient.createRepresentation(cloudId, representationName, providerId, stormTaskTuple.getFileByteDataAsStream(), stormTaskTuple.getParameter("OUTPUT_FILE_NAME"), TaskTupleUtility.getParameterFromTuple(stormTaskTuple, "OUTPUT_MIME_TYPE"), "Authorization", authenticationHeader);
            }
            catch (Exception e) {
                if (e.getCause() instanceof ProviderDoesNotExistException) {
                    this.LOGGER.error("Error while creating Representation.");
                    throw e;
                }
                if (retries-- > 0) {
                    this.LOGGER.warn("Error while creating Representation. Retries left: {} ", (Object)retries);
                    this.waitForSpecificTime();
                    continue;
                }
                this.LOGGER.error("Error while creating Representation.");
                throw e;
            }
            break;
        }
    }

    private String getCloudId(String authorizationHeader, String providerId, String localId, String additionalLocalIdentifier) throws CloudException {
        CloudId cloudId = this.getCloudId(providerId, localId, authorizationHeader);
        String result2 = cloudId != null ? cloudId.getId() : this.createCloudId(providerId, localId, authorizationHeader);
        if (additionalLocalIdentifier != null) {
            this.attachAdditionalLocalIdentifier(additionalLocalIdentifier, result2, providerId, authorizationHeader);
        }
        return result2;
    }

    private boolean attachAdditionalLocalIdentifier(String additionalLocalIdentifier, String cloudId, String providerId, String authorizationHeader) throws CloudException {
        int retries = 3;
        while (true) {
            try {
                return this.uisClient.createMapping(cloudId, providerId, additionalLocalIdentifier, "Authorization", authorizationHeader);
            }
            catch (Exception e) {
                if (e.getCause() instanceof IdHasBeenMappedException) {
                    return true;
                }
                if (e.getCause() instanceof ProviderDoesNotExistException) {
                    this.LOGGER.error("Error while mapping localId to cloudId.");
                    throw e;
                }
                if (retries-- > 0) {
                    this.LOGGER.warn("Error while mapping localId to cloudId. Retries left: {} ", (Object)retries);
                    this.waitForSpecificTime();
                    continue;
                }
                this.LOGGER.error("Error while creating CloudId.");
                throw e;
            }
            break;
        }
    }

    private CloudId getCloudId(String providerId, String localId, String authenticationHeader) throws CloudException {
        int retries = 3;
        while (true) {
            try {
                return this.uisClient.getCloudId(providerId, localId, "Authorization", authenticationHeader);
            }
            catch (Exception e) {
                if (e.getCause() instanceof RecordDoesNotExistException) {
                    return null;
                }
                if (e.getCause() instanceof ProviderDoesNotExistException) {
                    this.LOGGER.error("Error while getting CloudId.");
                    throw e;
                }
                if (retries-- > 0) {
                    this.LOGGER.warn("Error while getting CloudId. Retries left: {}", (Object)retries);
                    this.waitForSpecificTime();
                    continue;
                }
                this.LOGGER.error("Error while getting CloudId.");
                throw e;
            }
            break;
        }
    }

    private String createCloudId(String providerId, String localId, String authenticationHeader) throws CloudException {
        int retries = 3;
        while (true) {
            try {
                return this.uisClient.createCloudId(providerId, localId, "Authorization", authenticationHeader).getId();
            }
            catch (Exception e) {
                if (e.getCause() instanceof ProviderDoesNotExistException) {
                    this.LOGGER.error("Error while creating CloudId.");
                    throw e;
                }
                if (retries-- > 0) {
                    this.LOGGER.warn("Error while creating CloudId. Retries left: {} ", (Object)retries);
                    this.waitForSpecificTime();
                    continue;
                }
                this.LOGGER.error("Error while creating CloudId.");
                throw e;
            }
            break;
        }
    }
}

