/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.runtime;

import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.exceptions.DistributionException;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.runtime.Executable;
import de.flapdoodle.embed.process.runtime.IStopable;
import de.flapdoodle.embed.process.store.IArtifactStore;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Starter<CONFIG extends IExecutableProcessConfig, EXECUTABLE extends Executable<CONFIG, PROCESS>, PROCESS extends IStopable> {
    private static Logger logger = LoggerFactory.getLogger(Starter.class);
    private final IRuntimeConfig runtime;

    protected Starter(IRuntimeConfig config) {
        this.runtime = config;
    }

    public EXECUTABLE prepare(CONFIG config) {
        return this.prepare(config, Distribution.detectFor(config.version()));
    }

    public EXECUTABLE prepare(CONFIG config, Distribution distribution) {
        try {
            IArtifactStore artifactStore = this.runtime.getArtifactStore();
            if (artifactStore.checkDistribution(distribution)) {
                IExtractedFileSet files2 = this.runtime.getArtifactStore().extractFileSet(distribution);
                return this.newExecutable(config, distribution, this.runtime, files2);
            }
            throw new DistributionException("could not find Distribution", distribution);
        }
        catch (IOException iox) {
            String messageOnException = config.supportConfig().messageOnException(this.getClass(), iox);
            if (messageOnException == null) {
                messageOnException = "prepare executable";
            }
            logger.error(messageOnException, iox);
            throw new DistributionException(distribution, (Throwable)iox);
        }
    }

    protected abstract EXECUTABLE newExecutable(CONFIG var1, Distribution var2, IRuntimeConfig var3, IExtractedFileSet var4);
}

