/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.extract;

import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImmutableExtractedFileSet
implements IExtractedFileSet {
    private final File _executable;
    private final Map<FileType, List<File>> _files;
    private final File _baseDir;
    private final boolean baseDirIsGenerated;

    ImmutableExtractedFileSet(File baseDir, boolean baseDirIsGenerated, File executable, Map<FileType, List<File>> files2) {
        this.baseDirIsGenerated = baseDirIsGenerated;
        if (executable == null) {
            throw new NullPointerException("executable is NULL");
        }
        if (files2 == null) {
            throw new NullPointerException("files is NULL");
        }
        if (baseDir == null) {
            throw new NullPointerException("baseDir is NULL");
        }
        this._baseDir = baseDir;
        this._executable = executable;
        HashMap copy = new HashMap();
        for (FileType key : files2.keySet()) {
            copy.put(key, Collections.unmodifiableList(new ArrayList(files2.get((Object)key))));
        }
        this._files = Collections.unmodifiableMap(copy);
    }

    @Override
    public File baseDir() {
        return this._baseDir;
    }

    @Override
    public File executable() {
        return this._executable;
    }

    @Override
    public boolean baseDirIsGenerated() {
        return this.baseDirIsGenerated;
    }

    @Override
    public List<File> files(FileType type) {
        List<File> ret = this._files.get((Object)type);
        if (ret == null) {
            ret = Collections.emptyList();
        }
        return ret;
    }

    public static Builder builder(File baseDir) {
        if (baseDir == null) {
            throw new NullPointerException("generatedBaseDir is null");
        }
        return new Builder().baseDir(baseDir);
    }

    public static class Builder {
        File _executable = null;
        File _baseDir = null;
        Map<FileType, List<File>> _files = new HashMap<FileType, List<File>>();
        boolean _baseDirIsGenerated;

        public Builder executable(File executable) {
            if (this._executable != null) {
                throw new IllegalArgumentException("executable already set to " + this._executable);
            }
            this._executable = executable;
            return this;
        }

        public Builder baseDir(File baseDir) {
            this._baseDir = baseDir;
            return this;
        }

        public Builder baseDirIsGenerated(boolean baseDirIsGenerated) {
            this._baseDirIsGenerated = baseDirIsGenerated;
            return this;
        }

        public Builder file(FileType type, File file) {
            if (type == FileType.Executable) {
                return this.executable(file);
            }
            List<File> collection = this._files.get((Object)type);
            if (collection == null) {
                collection = new ArrayList<File>();
                this._files.put(type, collection);
            }
            collection.add(file);
            return this;
        }

        public IExtractedFileSet build() {
            return new ImmutableExtractedFileSet(this._baseDir, this._baseDirIsGenerated, this._executable, this._files);
        }
    }
}

