/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.runtime;

import de.flapdoodle.embed.mongo.config.IMongoDumpConfig;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.runtime.AbstractMongo;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MongoDump
extends AbstractMongo {
    public static List<String> getCommandLine(IMongoDumpConfig config, IExtractedFileSet files2) throws UnknownHostException {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(Arrays.asList(files2.executable().getAbsolutePath()));
        if (config.isVerbose()) {
            ret.add("-v");
        }
        MongoDump.applyNet(config.net(), ret);
        if (config.getDatabaseName() != null) {
            ret.add("--db");
            ret.add(config.getDatabaseName());
        }
        if (config.getCollectionName() != null) {
            ret.add("--collection");
            ret.add(config.getCollectionName());
        }
        if (config.getQuery() != null) {
            ret.add("--query");
            ret.add(config.getQuery());
        }
        if (config.getQueryFile() != null) {
            ret.add("--queryFile");
            ret.add(config.getQueryFile());
        }
        if (config.getReadPreference() != null) {
            ret.add("--readPreference");
            ret.add(config.getReadPreference());
        }
        if (config.isForceTableScan()) {
            ret.add("--forceTableScan");
        }
        if (config.getArchive() != null) {
            ret.add("--archive");
            ret.add(config.getArchive());
        }
        if (config.isDumpDbUsersAndRoles()) {
            ret.add("--dumpDbUsersAndRoles");
        }
        if (config.getOut() != null) {
            ret.add("--out");
            ret.add(config.getOut());
        }
        if (config.isGzip()) {
            ret.add("--gzip");
        }
        if (config.isRepair()) {
            ret.add("--repair");
        }
        if (config.isOplog()) {
            ret.add("--oplog");
        }
        if (config.getExcludeCollection() != null) {
            ret.add("--excludeCollection");
            ret.add(config.getExcludeCollection());
        }
        if (config.getExcludeCollectionWithPrefix() != null) {
            ret.add("--excludeCollectionWithPrefix");
            ret.add(config.getExcludeCollectionWithPrefix());
        }
        if (config.getNumberOfParallelCollections() != null) {
            ret.add("--numParallelCollections");
            ret.add(config.getNumberOfParallelCollections().toString());
        }
        System.out.println("MongoDump arguments: " + ret);
        return ret;
    }

    protected static void applyNet(Net net, List<String> ret) {
        ret.add("--port");
        ret.add("" + net.getPort());
        if (net.getBindIp() != null) {
            ret.add("--host");
            ret.add(net.getBindIp());
        }
    }
}

