/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.config.AbstractMongoConfigBuilder;
import de.flapdoodle.embed.mongo.config.IMongoRestoreConfig;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.SupportConfig;
import de.flapdoodle.embed.mongo.config.Timeout;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.process.builder.TypedProperty;
import java.io.IOException;

public class MongoRestoreConfigBuilder
extends AbstractMongoConfigBuilder<IMongoRestoreConfig> {
    protected static final TypedProperty<Boolean> VERBOSE = TypedProperty.with("verbose", Boolean.class);
    protected static final TypedProperty<String> DB_NAME = TypedProperty.with("db", String.class);
    protected static final TypedProperty<String> COLLECTION = TypedProperty.with("collection", String.class);
    protected static final TypedProperty<Boolean> OBJECT_CHECK = TypedProperty.with("objCheck", Boolean.class);
    protected static final TypedProperty<Boolean> OPLOG_REPLAY = TypedProperty.with("oplogReplay", Boolean.class);
    protected static final TypedProperty<Long> OPLOG_LIMIT = TypedProperty.with("oplogLimit", Long.class);
    protected static final TypedProperty<String> ARCHIVE = TypedProperty.with("archive", String.class);
    protected static final TypedProperty<Boolean> RESTORE_DB_USERS_ROLES = TypedProperty.with("restoreDbUsersAndRoles", Boolean.class);
    protected static final TypedProperty<String> DIR = TypedProperty.with("dir", String.class);
    protected static final TypedProperty<Boolean> GZIP = TypedProperty.with("gzip", Boolean.class);
    protected static final TypedProperty<Boolean> DROP = TypedProperty.with("drop", Boolean.class);
    protected static final TypedProperty<String> WRITE_CONCERN = TypedProperty.with("writeConcern", String.class);
    protected static final TypedProperty<Boolean> NO_INDEX_RESTORE = TypedProperty.with("noIndexRestore", Boolean.class);
    protected static final TypedProperty<Boolean> NO_OPTIONS_RESTORE = TypedProperty.with("noOptionsRestore", Boolean.class);
    protected static final TypedProperty<Boolean> KEEP_INDEX_VERSION = TypedProperty.with("keepIndexVersion", Boolean.class);
    protected static final TypedProperty<Boolean> MAINTAIN_INSERTION_ORDER = TypedProperty.with("maintainInsertionOrder", Boolean.class);
    protected static final TypedProperty<Integer> NUM_PARALLEL_COLLECTIONS = TypedProperty.with("numParallelCollections", Integer.class);
    protected static final TypedProperty<Integer> NUM_INSERTION_WORKERS = TypedProperty.with("numInsertionWorkersPerCollection", Integer.class);
    protected static final TypedProperty<Boolean> STOP_ON_ERROR = TypedProperty.with("stopOnError", Boolean.class);
    protected static final TypedProperty<Boolean> BYPASS_DOCUMENT_VALIDATION = TypedProperty.with("bypassDocumentValidation", Boolean.class);

    public MongoRestoreConfigBuilder() throws IOException {
        this.property(PID_FILE).setDefault("mongorestore.pid");
        this.property(VERBOSE).setDefault(false);
        this.property(GZIP).setDefault(Boolean.FALSE);
        this.property(OBJECT_CHECK).setDefault(Boolean.FALSE);
        this.property(OPLOG_REPLAY).setDefault(Boolean.FALSE);
        this.property(RESTORE_DB_USERS_ROLES).setDefault(Boolean.FALSE);
        this.property(NO_INDEX_RESTORE).setDefault(Boolean.FALSE);
        this.property(NO_OPTIONS_RESTORE).setDefault(Boolean.FALSE);
        this.property(KEEP_INDEX_VERSION).setDefault(Boolean.FALSE);
        this.property(MAINTAIN_INSERTION_ORDER).setDefault(Boolean.FALSE);
        this.property(STOP_ON_ERROR).setDefault(Boolean.FALSE);
        this.property(BYPASS_DOCUMENT_VALIDATION).setDefault(Boolean.FALSE);
        this.property(NUM_PARALLEL_COLLECTIONS).setDefault(4);
        this.property(NUM_INSERTION_WORKERS).setDefault(1);
    }

    public MongoRestoreConfigBuilder version(IFeatureAwareVersion version) {
        this.version().set(version);
        return this;
    }

    public MongoRestoreConfigBuilder timeout(Timeout timeout) {
        this.timeout().set(timeout);
        return this;
    }

    public MongoRestoreConfigBuilder net(Net net) {
        this.net().set(net);
        return this;
    }

    public MongoRestoreConfigBuilder verbose(Boolean verbose) {
        this.set(VERBOSE, verbose);
        return this;
    }

    public MongoRestoreConfigBuilder db(String dbName) {
        this.set(DB_NAME, dbName);
        return this;
    }

    public MongoRestoreConfigBuilder collection(String collection) {
        this.set(COLLECTION, collection);
        return this;
    }

    public MongoRestoreConfigBuilder objectCheck(Boolean shouldCheckObjects) {
        this.set(OBJECT_CHECK, shouldCheckObjects);
        return this;
    }

    public MongoRestoreConfigBuilder oplogReplay(Boolean shouldReplayOplog) {
        this.set(OPLOG_REPLAY, shouldReplayOplog);
        return this;
    }

    public MongoRestoreConfigBuilder oplogLimit(Long oplogLimit) {
        this.set(OPLOG_LIMIT, oplogLimit);
        return this;
    }

    public MongoRestoreConfigBuilder archive(String archive) {
        this.set(ARCHIVE, archive);
        return this;
    }

    public MongoRestoreConfigBuilder restoreDbUsersAndRoles(Boolean restoreDbUsersAndRoles) {
        this.set(RESTORE_DB_USERS_ROLES, restoreDbUsersAndRoles);
        return this;
    }

    public MongoRestoreConfigBuilder dir(String directory) {
        this.set(DIR, directory);
        return this;
    }

    public MongoRestoreConfigBuilder gzip(Boolean gzip) {
        this.set(GZIP, gzip);
        return this;
    }

    public MongoRestoreConfigBuilder dropCollection(boolean dropCollection) {
        this.set(DROP, dropCollection);
        return this;
    }

    public MongoRestoreConfigBuilder writeConcern(String writeConcern) {
        this.set(WRITE_CONCERN, writeConcern);
        return this;
    }

    public MongoRestoreConfigBuilder noIndexRestore(boolean noIndexRestore) {
        this.set(NO_INDEX_RESTORE, noIndexRestore);
        return this;
    }

    public MongoRestoreConfigBuilder noOptionsRestore(boolean noOptionsRestore) {
        this.set(NO_OPTIONS_RESTORE, noOptionsRestore);
        return this;
    }

    public MongoRestoreConfigBuilder keepIndexVersion(boolean keepIndexVersion) {
        this.set(KEEP_INDEX_VERSION, keepIndexVersion);
        return this;
    }

    public MongoRestoreConfigBuilder maintainInsertionOrder(boolean maintainInsertionOrder) {
        this.set(MAINTAIN_INSERTION_ORDER, maintainInsertionOrder);
        return this;
    }

    public MongoRestoreConfigBuilder numParallelCollections(Integer numParallelCollections) {
        this.set(NUM_PARALLEL_COLLECTIONS, numParallelCollections);
        return this;
    }

    public MongoRestoreConfigBuilder numInsertionWorkers(Integer numInsertionWorkers) {
        this.set(NUM_INSERTION_WORKERS, numInsertionWorkers);
        return this;
    }

    public MongoRestoreConfigBuilder stopOnError(boolean stopOnError) {
        this.set(STOP_ON_ERROR, stopOnError);
        return this;
    }

    public MongoRestoreConfigBuilder bypassDocumentValidation(boolean bypassDocumentValidation) {
        this.set(BYPASS_DOCUMENT_VALIDATION, bypassDocumentValidation);
        return this;
    }

    @Override
    public IMongoRestoreConfig build() {
        Net net = this.net().get();
        Timeout timeout = this.timeout().get();
        return new ImmutableMongoRestoreConfig(this.get(VERSION, null), net, timeout, this.get(VERBOSE, false), (String)this.get(PID_FILE), this.get(DB_NAME, null), this.get(COLLECTION, null), this.get(OBJECT_CHECK, false), this.get(OPLOG_REPLAY, false), this.get(OPLOG_LIMIT, null), this.get(ARCHIVE, null), this.get(RESTORE_DB_USERS_ROLES, false), this.get(DIR, null), this.get(GZIP, false), this.get(DROP, false), this.get(WRITE_CONCERN, null), this.get(NO_INDEX_RESTORE, false), this.get(NO_OPTIONS_RESTORE, false), this.get(KEEP_INDEX_VERSION, false), this.get(MAINTAIN_INSERTION_ORDER, false), this.get(NUM_PARALLEL_COLLECTIONS, 4), this.get(NUM_INSERTION_WORKERS, 1), this.get(STOP_ON_ERROR, false), this.get(BYPASS_DOCUMENT_VALIDATION, false));
    }

    static class ImmutableMongoRestoreConfig
    extends AbstractMongoConfigBuilder.ImmutableMongoConfig
    implements IMongoRestoreConfig {
        private final boolean _verbose;
        private final String _databaseName;
        private final String _collectionName;
        private final boolean _objectCheck;
        private final boolean _oplogReplay;
        private final Long _oplogLimit;
        private final String _archive;
        private final boolean _restoreDbUsersRoles;
        private final String _dir;
        private final boolean _gzip;
        private final boolean _dropCollection;
        private final String _writeConcern;
        private final boolean _noIndexRestore;
        private final boolean _noOptionsRestore;
        private final boolean _keepIndexVersion;
        private final boolean _maintainInsertionOrder;
        private final Integer _numParallelCollections;
        private final Integer _numInsertionWorkers;
        private final boolean _stopOnError;
        private final boolean _bypassDocumentValidation;

        public ImmutableMongoRestoreConfig(IFeatureAwareVersion version, Net net, Timeout timeout, boolean verbose, String pidFile, String database, String collection, boolean objectCheck, boolean oplogReplay, Long oplogLimit, String archive, boolean restoreDbUsersAndRoles, String dir, boolean gzip, boolean drop, String writeConcern, boolean noIndexRestore, boolean noOptionsRestore, boolean keepIndexVersion, boolean maintainInsertionOrder, Integer numParallelCollections, Integer numInsertionWorkers, boolean stopOnError, boolean bypassDocumentValidation) {
            super(new SupportConfig(Command.MongoRestore), version, net, null, null, timeout, null, pidFile);
            this._verbose = verbose;
            this._databaseName = database;
            this._collectionName = collection;
            this._objectCheck = objectCheck;
            this._oplogReplay = oplogReplay;
            this._oplogLimit = oplogLimit;
            this._archive = archive;
            this._restoreDbUsersRoles = restoreDbUsersAndRoles;
            this._dir = dir;
            this._gzip = gzip;
            this._dropCollection = drop;
            this._writeConcern = writeConcern;
            this._noIndexRestore = noIndexRestore;
            this._noOptionsRestore = noOptionsRestore;
            this._keepIndexVersion = keepIndexVersion;
            this._maintainInsertionOrder = maintainInsertionOrder;
            this._numParallelCollections = numParallelCollections;
            this._numInsertionWorkers = numInsertionWorkers;
            this._stopOnError = stopOnError;
            this._bypassDocumentValidation = bypassDocumentValidation;
        }

        @Override
        public boolean isVerbose() {
            return this._verbose;
        }

        @Override
        public String getDatabaseName() {
            return this._databaseName;
        }

        @Override
        public String getCollectionName() {
            return this._collectionName;
        }

        @Override
        public Long getOplogLimit() {
            return this._oplogLimit;
        }

        @Override
        public String getArchive() {
            return this._archive;
        }

        @Override
        public String getDir() {
            return this._dir;
        }

        @Override
        public Integer getNumberOfParallelCollections() {
            return this._numParallelCollections;
        }

        @Override
        public Integer getNumberOfInsertionWorkersPerCollection() {
            return this._numInsertionWorkers;
        }

        @Override
        public String getWriteConcern() {
            return this._writeConcern;
        }

        @Override
        public boolean isObjectCheck() {
            return this._objectCheck;
        }

        @Override
        public boolean isOplogReplay() {
            return this._oplogReplay;
        }

        @Override
        public boolean isRestoreDbUsersAndRoles() {
            return this._restoreDbUsersRoles;
        }

        @Override
        public boolean isGzip() {
            return this._gzip;
        }

        @Override
        public boolean isDropCollection() {
            return this._dropCollection;
        }

        @Override
        public boolean isNoIndexRestore() {
            return this._noIndexRestore;
        }

        @Override
        public boolean isNoOptionsRestore() {
            return this._noOptionsRestore;
        }

        @Override
        public boolean isKeepIndexVersion() {
            return this._keepIndexVersion;
        }

        @Override
        public boolean isMaintainInsertionOrder() {
            return this._maintainInsertionOrder;
        }

        @Override
        public boolean isStopOnError() {
            return this._stopOnError;
        }

        @Override
        public boolean isBypassDocumentValidation() {
            return this._bypassDocumentValidation;
        }
    }
}

