/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.config.IMongoCmdOptions;
import de.flapdoodle.embed.process.builder.AbstractBuilder;
import de.flapdoodle.embed.process.builder.TypedProperty;

public class MongoCmdOptionsBuilder
extends AbstractBuilder<IMongoCmdOptions> {
    protected static final TypedProperty<Integer> SYNC_DELAY = TypedProperty.with("syncDelay", Integer.class);
    protected static final TypedProperty<String> STORAGE_ENGINE = TypedProperty.with("storageEngine", String.class);
    protected static final TypedProperty<Boolean> VERBOSE = TypedProperty.with("verbose", Boolean.class);
    protected static final TypedProperty<Boolean> NOPREALLOC = TypedProperty.with("noprealloc", Boolean.class);
    protected static final TypedProperty<Boolean> SMALLFILES = TypedProperty.with("smallfiles", Boolean.class);
    protected static final TypedProperty<Boolean> NOJOURNAL = TypedProperty.with("nojournal", Boolean.class);
    protected static final TypedProperty<Boolean> ENABLE_TEXTSEARCH = TypedProperty.with("enableTextSearch", Boolean.class);
    protected static final TypedProperty<Boolean> ENABLE_AUTH = TypedProperty.with("auth", Boolean.class);
    protected static final TypedProperty<Boolean> MASTER = TypedProperty.with("master", Boolean.class);

    public MongoCmdOptionsBuilder() {
        this.property(SYNC_DELAY).setDefault(0);
        this.property(STORAGE_ENGINE).setDefault(null);
        this.property(VERBOSE).setDefault(false);
        this.property(NOPREALLOC).setDefault(true);
        this.property(SMALLFILES).setDefault(true);
        this.property(NOJOURNAL).setDefault(true);
        this.property(ENABLE_TEXTSEARCH).setDefault(false);
        this.property(ENABLE_AUTH).setDefault(false);
        this.property(MASTER).setDefault(false);
    }

    public MongoCmdOptionsBuilder useNoPrealloc(boolean value) {
        this.set(NOPREALLOC, value);
        return this;
    }

    public MongoCmdOptionsBuilder useSmallFiles(boolean value) {
        this.set(SMALLFILES, value);
        return this;
    }

    public MongoCmdOptionsBuilder useNoJournal(boolean value) {
        this.set(NOJOURNAL, value);
        return this;
    }

    public MongoCmdOptionsBuilder syncDelay(int delay) {
        this.set(SYNC_DELAY, delay);
        return this;
    }

    public MongoCmdOptionsBuilder verbose(boolean verbose) {
        this.set(VERBOSE, verbose);
        return this;
    }

    public MongoCmdOptionsBuilder enableTextSearch(boolean verbose) {
        this.set(ENABLE_TEXTSEARCH, verbose);
        return this;
    }

    public MongoCmdOptionsBuilder useStorageEngine(String storageEngine) {
        this.set(STORAGE_ENGINE, storageEngine);
        return this;
    }

    public MongoCmdOptionsBuilder enableAuth(boolean enable) {
        this.set(ENABLE_AUTH, enable);
        return this;
    }

    public MongoCmdOptionsBuilder master(boolean enable) {
        this.set(MASTER, enable);
        return this;
    }

    public MongoCmdOptionsBuilder defaultSyncDelay() {
        this.set(SYNC_DELAY, null);
        return this;
    }

    @Override
    public IMongoCmdOptions build() {
        Integer syncDelay = this.get(SYNC_DELAY, null);
        String storageEngine = this.get(STORAGE_ENGINE, null);
        boolean verbose = this.get(VERBOSE);
        boolean noPrealloc = this.get(NOPREALLOC);
        boolean smallFiles = this.get(SMALLFILES);
        boolean noJournal = this.get(NOJOURNAL);
        boolean enableTextSearch = this.get(ENABLE_TEXTSEARCH);
        boolean auth = this.get(ENABLE_AUTH);
        boolean master = this.get(MASTER);
        return new MongoCmdOptions(syncDelay, storageEngine, verbose, noPrealloc, smallFiles, noJournal, enableTextSearch, auth, master);
    }

    static class MongoCmdOptions
    implements IMongoCmdOptions {
        private final Integer _syncDelay;
        private final boolean _verbose;
        private final boolean _noPrealloc;
        private final boolean _smallFiles;
        private final boolean _noJournal;
        private final boolean _enableTextSearch;
        private final boolean _auth;
        private final boolean _master;
        private final String _storageEngine;

        public MongoCmdOptions(Integer syncDelay, String storageEngine, boolean verbose, boolean noPrealloc, boolean smallFiles, boolean noJournal, boolean enableTextSearch, boolean auth, boolean master) {
            this._syncDelay = syncDelay;
            this._storageEngine = storageEngine;
            this._verbose = verbose;
            this._noPrealloc = noPrealloc;
            this._smallFiles = smallFiles;
            this._noJournal = noJournal;
            this._enableTextSearch = enableTextSearch;
            this._auth = auth;
            this._master = master;
        }

        @Override
        public Integer syncDelay() {
            return this._syncDelay;
        }

        @Override
        public String storageEngine() {
            return this._storageEngine;
        }

        @Override
        public boolean isVerbose() {
            return this._verbose;
        }

        @Override
        public boolean useNoPrealloc() {
            return this._noPrealloc;
        }

        @Override
        public boolean useSmallFiles() {
            return this._smallFiles;
        }

        @Override
        public boolean useNoJournal() {
            return this._noJournal;
        }

        @Override
        public boolean enableTextSearch() {
            return this._enableTextSearch;
        }

        @Override
        public boolean auth() {
            return this._auth;
        }

        @Override
        public boolean master() {
            return this._master;
        }
    }
}

